/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.hsi.TreeOrderVisitor;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.FunctionChecker;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class ContractSlotChecker
extends LeafAdapter
implements TreeOrderVisitor {
    private final ErrorReporter errors;
    private final NestedVisitor sv;
    private final ContractMethodDecl cmd;
    private int pos;
    private Type ty;

    public ContractSlotChecker(ErrorReporter errors, NestedVisitor sv, CurrentTCState state, ObjectActionHandler inMeth) {
        this.errors = errors;
        this.sv = sv;
        this.cmd = inMeth.contractMethod();
        if (inMeth.nestedVars() != null && !inMeth.nestedVars().patterns().isEmpty()) {
            throw new CantHappenException("contract method " + inMeth.name() + " cannot handle nested vars; handler methods should add lambdas, I don't know about other cases");
        }
        this.pos = 0;
    }

    @Override
    public void argSlot(ArgSlot s) {
        throw new NotImplementedException();
    }

    @Override
    public void matchConstructor(StructDefn ctor) {
        throw new NotImplementedException();
    }

    @Override
    public void matchField(StructField fld) {
        throw new NotImplementedException();
    }

    @Override
    public void matchType(Type want, VarName var, FunctionIntro intro) {
        NamedType defined = this.cmd.args.get((int)this.pos++).type.namedDefn();
        if (defined != want) {
            this.errors.message(var.loc, "cannot bind " + var.var + " to " + ((NamedType)want).name() + " when the contract specifies " + defined.name());
            this.ty = new ErrorType();
        } else {
            this.ty = want;
        }
    }

    @Override
    public void varInIntro(VarName vn, VarPattern vp, FunctionIntro intro) {
        if (this.pos > this.cmd.args.size()) {
            throw new NotImplementedException("Argument is out of range: " + this.pos + " " + this.cmd.args.size());
        }
        if (this.pos == this.cmd.args.size() && this.cmd.handler == null) {
            throw new NotImplementedException("There is no handler for " + this.cmd.name.uniqueName() + " but have var arg with pos = " + this.pos);
        }
        this.ty = this.pos == this.cmd.args.size() ? this.cmd.handler.type.namedDefn() : this.cmd.args.get((int)this.pos).type.namedDefn();
        ++this.pos;
        vp.bindType(this.ty);
    }

    @Override
    public void endField(StructField fld) {
        throw new NotImplementedException();
    }

    @Override
    public void endConstructor(StructDefn ctor) {
        throw new NotImplementedException();
    }

    @Override
    public void endArg(Slot s) {
        this.sv.result(new FunctionChecker.ArgResult(this.ty));
        this.ty = null;
    }

    @Override
    public void patternsDone(LogicHolder fn) {
        throw new NotImplementedException();
    }
}

