/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.HashMap;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.DependencyGroup;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.ut.UnitTestClose;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.FunctionGroupTCState;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;

public class CloseCardChecker
extends LeafAdapter
implements ResultAware {
    private final NestedVisitor sv;
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final String fnCxt;
    private Type card;

    public CloseCardChecker(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, String fnCxt, UnitTestClose utc) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.fnCxt = fnCxt;
        sv.push(this);
        this.state = new FunctionGroupTCState(repository, new DependencyGroup(new LogicHolder[0]));
        sv.push(new ExpressionChecker(errors, repository, this.state, sv, fnCxt, false));
    }

    @Override
    public void visitExpr(Expr e, int nargs) {
        this.sv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.sv, this.fnCxt, false));
    }

    @Override
    public void result(Object r) {
        this.card = ((ExpressionChecker.ExprResult)r).type;
    }

    @Override
    public void leaveUnitTestClose(UnitTestClose utc) {
        if (this.card instanceof ErrorType) {
            this.sv.result(this.card);
            return;
        }
        if (!(this.card instanceof CardDefinition)) {
            this.errors.message(utc.card.location(), "close requires a card variable");
            this.sv.result(null);
            return;
        }
        this.state.groupDone(this.errors, new HashMap<TypeBinder, PosType>(), new HashMap<TypeBinder, PosType>());
        this.state.bindIntroducedVarTypes(this.errors);
        this.sv.result(null);
    }
}

