/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.CheckTypeExpr;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;

public class CheckTypeExprChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final NestedVisitor nv;
    private final String fnCxt;
    private final boolean inTemplate;
    private ExpressionChecker.ExprResult typeValue;

    public CheckTypeExprChecker(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, NestedVisitor nv, String fnCxt, boolean inTemplate) {
        this.errors = errors;
        this.repository = repository;
        this.state = state;
        this.nv = nv;
        this.fnCxt = fnCxt;
        this.inTemplate = inTemplate;
        nv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        this.nv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate));
    }

    @Override
    public void result(Object r) {
        this.typeValue = (ExpressionChecker.ExprResult)r;
    }

    @Override
    public void leaveCheckTypeExpr(CheckTypeExpr expr) {
        if (this.typeValue == null || this.typeValue.type instanceof ErrorType) {
            this.nv.result(new ErrorType());
            return;
        }
        if (!this.typeValue.type.incorporates(expr.type.location(), expr.type.namedDefn()) && !expr.type.namedDefn().incorporates(expr.type.location(), this.typeValue.type)) {
            this.errors.message(this.typeValue.location(), "expression cannot be a " + expr.type.name());
            this.nv.result(new ErrorType());
            return;
        }
        this.nv.result(LoadBuiltins.bool);
    }
}

