/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.NamedType;
import org.zinutils.exceptions.CantHappenException;

public class CastExprChecker
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final CurrentTCState state;
    private final NestedVisitor nv;
    private final String fnCxt;
    private final boolean inTemplate;
    private NamedType castTo;
    private ExpressionChecker.ExprResult original;

    public CastExprChecker(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, NestedVisitor nv, String fnCxt, boolean inTemplate) {
        this.errors = errors;
        this.repository = repository;
        this.state = state;
        this.nv = nv;
        this.fnCxt = fnCxt;
        this.inTemplate = inTemplate;
        nv.push(this);
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        this.castTo = var.namedDefn();
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        this.nv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate));
    }

    @Override
    public void result(Object r) {
        if (this.original != null) {
            throw new CantHappenException("too many results");
        }
        this.original = (ExpressionChecker.ExprResult)r;
    }

    @Override
    public void leaveCastExpr(CastExpr expr) {
        this.nv.result(this.castTo);
    }
}

