/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.CurrentTCState;
import org.flasck.flas.tc3.CurryArgumentType;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.ExpressionChecker;
import org.flasck.flas.tc3.MemberExpressionChecker;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.PosType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeChecker;
import org.flasck.flas.tc3.UnifiableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyExpressionChecker
extends LeafAdapter
implements ResultAware {
    public static final Logger logger = LoggerFactory.getLogger((String)"TypeChecker");
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final NestedVisitor nv;
    private final List<PosType> results = new ArrayList<PosType>();
    private final CurrentTCState state;
    private final String fnCxt;
    private final boolean inTemplate;
    private Expr tmp;

    public ApplyExpressionChecker(ErrorReporter errors, RepositoryReader repository, CurrentTCState state, NestedVisitor nv, String fnCxt, boolean inTemplate) {
        this.errors = errors;
        this.repository = repository;
        this.state = state;
        this.nv = nv;
        this.fnCxt = fnCxt;
        this.inTemplate = inTemplate;
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        this.tmp = expr;
        this.nv.push(new ExpressionChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, this.inTemplate));
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        this.tmp = expr;
        this.nv.push(new MemberExpressionChecker(this.errors, this.repository, this.state, this.nv, this.fnCxt, false));
        return expr.boundEarly();
    }

    @Override
    public void result(Object r) {
        if (r instanceof ExpressionChecker.IgnoreMe) {
            return;
        }
        ExpressionChecker.ExprResult ty = (ExpressionChecker.ExprResult)r;
        if (ty == null || ty.type == null) {
            throw new NullPointerException("Cannot handle null type");
        }
        this.results.add(TypeChecker.instantiateFreshPolys(this.tmp, this.state, new TreeMap<String, UnifiableType>(), ty, false));
    }

    @Override
    public void leaveApplyExpr(ApplyExpr expr) {
        PosType pai;
        int pos;
        if (expr.fn instanceof UnresolvedOperator && ((UnresolvedOperator)expr.fn).op.equals("[]")) {
            this.handleListBuilder(expr);
            return;
        }
        if (expr.fn instanceof UnresolvedOperator && ((UnresolvedOperator)expr.fn).op.equals("()")) {
            this.handleTupleBuilder(expr);
            return;
        }
        if (expr.fn instanceof UnresolvedOperator && ((UnresolvedOperator)expr.fn).op.equals("{}")) {
            this.handleHashBuilder(expr);
            return;
        }
        PosType pfn = this.results.remove(0);
        Type fn = pfn.type;
        logger.debug("attempting to check application of " + expr.fn + " " + fn + " to " + this.results);
        if (fn instanceof ErrorType) {
            this.nv.result(fn);
            return;
        }
        if (fn instanceof ContractDecl) {
            this.errors.message(pfn.location(), "cannot use a contract as a function");
            this.nv.result(new ErrorType());
            return;
        }
        if (fn instanceof ObjectDefn) {
            this.errors.message(pfn.location(), "must use a ctor to create an object");
            this.nv.result(new ErrorType());
            return;
        }
        if (fn instanceof UnifiableType) {
            UnifiableType ut = (UnifiableType)fn;
            this.nv.result(ut.canBeAppliedTo(expr.location(), this.results));
            return;
        }
        if (fn.argCount() < this.results.size()) {
            if (fn instanceof StructDefn && fn.argCount() == this.results.size() - 1 && this.results.get((int)(this.results.size() - 1)).type == LoadBuiltins.hash) {
                this.results.remove(this.results.size() - 1);
            } else {
                if (fn.argCount() == this.results.size() - 1 && this.results.get((int)(this.results.size() - 1)).type instanceof HandlerImplements) {
                    this.errors.message(pfn.pos, "use -> to provide handlers");
                    this.nv.result(new ErrorType());
                    return;
                }
                if (fn instanceof HandlerImplements && fn.argCount() == this.results.size() - 1 && ((HandlerImplements)fn).getParent() != null && !((HandlerImplements)fn).inCard) {
                    PosType parent = this.results.remove(0);
                    NamedType parentType = ((HandlerImplements)fn).getParent();
                    if (parent.type != parentType) {
                        this.errors.message(pfn.pos, "handler " + expr.fn + " expects " + parentType.signature() + " not " + parent.type.signature());
                        this.nv.result(new ErrorType());
                        return;
                    }
                } else {
                    this.errors.message(pfn.pos, expr.fn + " expects: " + fn.argCount() + " has: " + this.results.size());
                    this.nv.result(new ErrorType());
                    return;
                }
            }
        }
        ArrayList<Type> tocurry = new ArrayList<Type>();
        int max = fn instanceof Apply ? ((Apply)fn).argCountConsideringHandler() : fn.argCount();
        for (pos = 0; !this.results.isEmpty() && pos < max; ++pos) {
            pai = this.results.remove(0);
            Type ai = pai.type;
            if (ai instanceof ErrorType) {
                this.nv.result(ai);
                return;
            }
            InputPosition loc = ((Locatable)expr.args.get(pos)).location();
            Type fi = fn.get(pos);
            if (ai instanceof CurryArgumentType) {
                tocurry.add(fi);
                continue;
            }
            if (fi instanceof ErrorType || ai instanceof ErrorType) {
                this.nv.result(new ErrorType());
                return;
            }
            if (fi.incorporates(loc, ai)) continue;
            logger.info("TC Error: " + expr.fn + " was expecting " + fi.signature() + " not " + ai.signature());
            this.errors.message(loc, "function '" + expr.fn + "' was expecting " + fi.signature() + " not " + ai.signature());
            this.nv.result(new ErrorType());
            return;
        }
        if (!this.results.isEmpty()) {
            pai = this.results.remove(0);
            if (pai.type instanceof HandlerImplements) {
                this.errors.message(expr.location(), "unexpected handler as argument; did you forget '->' ?");
                this.nv.result(new ErrorType());
                return;
            }
            String name = "function '" + expr.fn;
            if (expr.fn instanceof MemberExpr) {
                name = "method '" + ((MemberExpr)expr.fn).fld;
            }
            this.errors.message(expr.location(), "excess arguments to " + name + "'");
            this.nv.result(new ErrorType());
            return;
        }
        while (pos < fn.argCount()) {
            tocurry.add(fn.get(pos++));
        }
        if (!tocurry.isEmpty()) {
            tocurry.add(fn.get(pos));
            boolean wh = false;
            if (fn instanceof Apply) {
                wh = ((Apply)fn).withHandler();
            }
            this.nv.result(new Apply(tocurry).withHandler(wh));
        } else {
            this.nv.result(fn.get(pos));
        }
    }

    private void handleListBuilder(ApplyExpr expr) {
        if (expr.args.isEmpty()) {
            this.nv.result(LoadBuiltins.nil);
        } else {
            this.results.remove(0);
            PosType ty = this.state.consolidate(expr.location(), this.results);
            this.nv.result(new PolyInstance(expr.location(), LoadBuiltins.cons, Arrays.asList(ty.type)));
        }
    }

    private void handleTupleBuilder(ApplyExpr expr) {
        if (expr.args.size() < 2) {
            throw new RuntimeException("Tuples must have at least two elements");
        }
        PosType op = this.results.remove(0);
        ArrayList<Type> tys = new ArrayList<Type>();
        for (PosType pt : this.results) {
            tys.add(pt.type);
        }
        this.nv.result(new PolyInstance(expr.location(), ((PolyInstance)op.type).struct(), tys));
    }

    private void handleHashBuilder(ApplyExpr expr) {
        if (expr.args.isEmpty()) {
            this.nv.result(LoadBuiltins.hash);
        } else {
            this.results.remove(0);
            for (PosType e : this.results) {
                if (e.type == LoadBuiltins.hashPairType) continue;
                this.errors.message(e.pos, "invalid entry in hash: " + e.type.signature());
                this.nv.result(new ErrorType());
                return;
            }
            this.nv.result(LoadBuiltins.hash);
        }
    }
}

