/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tc3;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.tc3.SignatureNeedsParensType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.ShouldBeError;

public class Apply
implements Type,
SignatureNeedsParensType {
    public static final InputPosition unknown = new InputPosition("unknown", 1, 0, null, "unknown");
    public final List<Type> tys;
    private boolean withHandler;

    public Apply(Type ... types) {
        if (types.length < 2) {
            throw new RuntimeException("Must have at least one input and one output");
        }
        this.tys = new ArrayList<Type>();
        for (Type t : types) {
            if (t == null) {
                throw new CantHappenException("cannot have null type");
            }
            this.tys.add(t);
        }
    }

    public Apply(List<Type> types) {
        if (types.size() < 2) {
            throw new RuntimeException("Must have at least one input and one output");
        }
        for (Type t : types) {
            if (t != null) continue;
            throw new CantHappenException("cannot have null type");
        }
        this.tys = types;
    }

    public Apply(List<Type> argTypes, Type result) {
        if (argTypes.isEmpty()) {
            throw new RuntimeException("Must have at least one input and one output");
        }
        this.tys = new ArrayList<Type>();
        this.tys.addAll(argTypes);
        this.tys.add(result);
        for (Type t : this.tys) {
            if (t != null) continue;
            throw new CantHappenException("cannot have null type");
        }
    }

    @Override
    public String signature() {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (int i = 0; i < this.tys.size(); ++i) {
            boolean needParens;
            Type t = this.tys.get(i);
            sb.append(sep);
            sep = "->";
            if (t == null) {
                sb.append("<<UNDEFINED>>");
                continue;
            }
            boolean bl = needParens = t instanceof SignatureNeedsParensType && i < this.tys.size() - 1;
            if (needParens) {
                sb.append("(");
            }
            sb.append(t.signature());
            if (!needParens) continue;
            sb.append(")");
        }
        return sb.toString();
    }

    public Type appliedTo(StateHolder ty) {
        if (ty != this.tys.get(0)) {
            throw new ShouldBeError("Applying an Apply to the wrong type");
        }
        if (this.tys.size() == 2) {
            return this.tys.get(1);
        }
        ArrayList<Type> copy = new ArrayList<Type>(this.tys);
        copy.remove(0);
        return new Apply(copy);
    }

    public Type discard(int discard) {
        if (this.tys.size() < discard + 1) {
            throw new ShouldBeError("Only have " + this.tys.size() + "; cannot discard " + discard);
        }
        if (this.tys.size() == discard + 1) {
            return this.tys.get(discard);
        }
        ArrayList<Type> copy = new ArrayList<Type>(this.tys);
        while (discard-- > 0) {
            copy.remove(0);
        }
        return new Apply(copy);
    }

    public int argCountConsideringHandler() {
        return this.tys.size() - 1 - (this.withHandler ? 1 : 0);
    }

    @Override
    public int argCount() {
        return this.tys.size() - 1;
    }

    @Override
    public Type get(int pos) {
        return this.tys.get(pos);
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        if (other instanceof UnifiableType) {
            return other.incorporates(pos, this);
        }
        if (!(other instanceof Apply)) {
            return false;
        }
        List<Type> otys = ((Apply)other).tys;
        if (this.tys.size() != otys.size()) {
            return false;
        }
        for (int i = 0; i < this.tys.size(); ++i) {
            UnifiableType ut;
            Type fi = this.tys.get(i);
            Type oi = otys.get(i);
            if (oi instanceof UnifiableType) {
                ut = (UnifiableType)oi;
                ut.incorporatedBy(unknown, fi);
                continue;
            }
            if (fi instanceof UnifiableType) {
                ut = (UnifiableType)fi;
                ut.isPassed(unknown, oi);
                continue;
            }
            if (fi.incorporates(unknown, oi)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Type t : this.tys) {
            sb.append("-->");
            if (t == null) {
                sb.append("<<UNDEFINED>>");
                continue;
            }
            sb.append("(" + t.toString() + ")");
        }
        return sb.toString();
    }

    public Type withHandler(boolean withHandler) {
        this.withHandler = withHandler;
        return this;
    }

    public boolean withHandler() {
        return this.withHandler;
    }
}

