/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.stories;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAMultiParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final List<TDAParsing> parsers = new ArrayList<TDAParsing>();
    private TDAParsing chosen;

    @SafeVarargs
    public TDAMultiParser(ErrorReporter errors, TDAParserConstructor ... klz) {
        this.errors = errors;
        for (TDAParserConstructor k : klz) {
            this.parsers.add(k.construct(errors));
        }
    }

    public void add(TDAParsing parser) {
        this.parsers.add(parser);
    }

    public void add(int pos, TDAParsing parser) {
        this.parsers.add(pos, parser);
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ErrorMark mark = this.errors.mark();
        TDAParsing nested = null;
        this.chosen = null;
        for (TDAParsing p : this.parsers) {
            if (this.chosen == null) {
                toks.reset(0);
                nested = p.tryParsing(toks);
                if (nested == null) continue;
                this.chosen = p;
                continue;
            }
            p.choseOther();
        }
        if (nested != null) {
            return nested;
        }
        toks.reset(0);
        if (!mark.hasMoreNow()) {
            this.errors.message(toks, "syntax error");
        }
        return new IgnoreNestedParser(this.errors);
    }

    public boolean contains(Class<?> cls) {
        for (TDAParsing p : this.parsers) {
            if (!cls.isInstance(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void scopeComplete(InputPosition location) {
        if (this.chosen != null) {
            this.chosen.scopeComplete(location);
        }
    }
}

