/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TemplateNestedField;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.resolver.RepositoryResolver;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeHelpers;
import org.zinutils.exceptions.HaventConsideredThisException;

public class TemplateNestingChain
implements NestingChain {
    private final TemplateNamer namer;
    private final List<Link> links = new ArrayList<Link>();

    public TemplateNestingChain(TemplateNamer namer) {
        this.namer = namer;
    }

    @Override
    public InputPosition location() {
        if (this.links.isEmpty()) {
            return null;
        }
        return this.links.get(this.links.size() - 1).location();
    }

    @Override
    public void clean() {
        Iterator<Link> it = this.links.iterator();
        while (it.hasNext()) {
            Link l = it.next();
            if (l.inferred) {
                it.remove();
                continue;
            }
            l.clean();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    @Override
    public Iterator<Link> iterator() {
        return this.links.iterator();
    }

    @Override
    public void declare(TypeReference typeReference, VarName nameVar) {
        this.links.add(new Link(typeReference, nameVar));
    }

    @Override
    public List<TypeReference> types() {
        ArrayList<TypeReference> ret = new ArrayList<TypeReference>();
        for (Link l : this.links) {
            if (l.decl == null) continue;
            ret.add(l.decl);
        }
        return ret;
    }

    @Override
    public void addInferred(InputPosition loc, Type ty) {
        if (!this.links.isEmpty() && this.links.get((int)0).decl != null) {
            return;
        }
        this.links.add(new Link(ty, this.namer.nameVar(loc, "_expr" + (this.links.size() + 1))));
    }

    @Override
    public void resolvedTypes(ErrorReporter errors) {
        for (Link l : this.links) {
            if (l.actual != null) continue;
            if (l.decl != null && l.decl.namedDefn() != null) {
                l.actual = l.decl.namedDefn();
                continue;
            }
            if (errors.hasErrors()) continue;
            throw new HaventConsideredThisException("type of " + l.name.uniqueName() + " was not resolved");
        }
    }

    @Override
    public RepositoryEntry resolve(RepositoryResolver resolver, UnresolvedVar var) {
        for (Link l : this.links) {
            Type sd;
            StructField field;
            Type ty;
            if (l.actual == null) continue;
            if (l.name != null && l.name.var.equals(var.var)) {
                return new TemplateNestedField(var.location, l.name, l.actual, null);
            }
            if (l.actual instanceof StructDefn) {
                ty = (StructDefn)l.actual;
                StructField field2 = ((FieldsDefn)ty).findField(var.var);
                if (field2 == null) continue;
                resolver.visitTypeReference(field2.type, true, -1);
                return new TemplateNestedField(var.location, l.name, field2.type(), field2);
            }
            if (!TypeHelpers.isList(l.actual) || !((ty = TypeHelpers.extractListPoly(l.actual)) instanceof StructDefn) || (field = ((FieldsDefn)(sd = ty)).findField(var.var)) == null) continue;
            resolver.visitTypeReference(field.type, true, -1);
            return new TemplateNestedField(var.location, l.name, field.type(), field);
        }
        return null;
    }

    public class Link {
        final TypeReference decl;
        final VarName name;
        Type actual;
        private boolean inferred;

        public Link(TypeReference decl, VarName nameVar) {
            this.decl = decl;
            this.name = nameVar;
            this.actual = null;
            this.inferred = false;
        }

        public Link(Type type, VarName name) {
            this.decl = null;
            this.name = name;
            this.actual = type;
            this.inferred = true;
        }

        public VarName name() {
            return this.name;
        }

        public Type type() {
            return this.actual;
        }

        public void clean() {
            this.actual = null;
        }

        public InputPosition location() {
            return this.name.loc;
        }
    }
}

