/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.NumericLiteral;
import org.flasck.flas.commonBase.ParenExpr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.TemplateName;
import org.flasck.flas.commonBase.names.UnitTestName;
import org.flasck.flas.compiler.ModuleExtensible;
import org.flasck.flas.compiler.modules.TraversalProcessor;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AccessRestrictions;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.ConstructorMatch;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.FunctionTypeReference;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.Implements;
import org.flasck.flas.parsedForm.ImplementsContract;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.ServiceDefinition;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateEvent;
import org.flasck.flas.parsedForm.TemplateNestedField;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleTypeReference;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.parsedForm.assembly.SubRouting;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parsedForm.ut.TestStepHolder;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.parsedForm.ut.UnitTestRender;
import org.flasck.flas.parsedForm.ut.UnitTestSend;
import org.flasck.flas.parsedForm.ut.UnitTestShove;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.RepositoryVisitor;
import org.flasck.flas.resolver.ApplicationRoutingResolver;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.resolver.RepositoryResolverModule;
import org.flasck.flas.resolver.Resolver;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;
import org.flasck.flas.tc3.Tuple;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.TypeHelpers;
import org.flasck.flas.tokenizers.PolyTypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.CardType;
import org.ziniki.splitter.FieldType;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class RepositoryResolver
extends LeafAdapter
implements Resolver,
ModuleExtensible {
    private static final Logger logger = LoggerFactory.getLogger((String)"Resolver");
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private final List<NameOfThing> scopeStack = new ArrayList<NameOfThing>();
    private NameOfThing scope;
    private Implements currentlyImplementing;
    private Template currentTemplate;
    private UnresolvedVar currShoveExpr;
    private Set<String> currentBindings;
    private NestingChain templateNestingChain;
    private RepositoryEntry inside;
    private boolean assigning;
    private final Iterable<TraversalProcessor> modules;
    private boolean lookDownwards;
    private ApplicationRoutingResolver applicationRouting;

    public RepositoryResolver(ErrorReporter errors, RepositoryReader repository) {
        this.errors = errors;
        this.repository = repository;
        this.modules = ServiceLoader.load(TraversalProcessor.class);
    }

    @Override
    public void resolveAll() {
        this.repository.traverse(this);
    }

    @Override
    public void currentScope(NameOfThing scope) {
        this.scope = scope;
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        this.scopeStack.add(0, this.scope);
        this.scope = fn.name();
        this.inside = fn;
    }

    @Override
    public void visitFunctionIntro(FunctionIntro fi) {
        this.scopeStack.add(0, this.scope);
        this.scope = fi.name();
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        this.scopeStack.add(0, this.scope);
        this.scope = meth.name();
        this.inside = meth;
        if (this.currentlyImplementing != null && this.currentlyImplementing.actualType() != null && !meth.isBroken()) {
            ContractDecl cd = this.currentlyImplementing.actualType();
            ContractMethodDecl cm = cd.getMethod(meth.name().name);
            if (cm != null) {
                if (meth.argCount() < cm.args.size()) {
                    InputPosition loc = meth.location().locAtEnd();
                    if (!meth.args().isEmpty()) {
                        loc = meth.args().get(meth.args().size() - 1).location().locAtEnd();
                    }
                    this.errors.message(loc.plus(1), "insufficient arguments provided to contract method '" + meth.name().name + "'");
                } else if (meth.argCount() > cm.args.size()) {
                    InputPosition loc = meth.args().get(cm.args.size()).location();
                    this.errors.message(loc, "excess arguments provided to contract method '" + meth.name().name + "'");
                }
                meth.bindFromContract(cm);
            } else {
                this.errors.message(meth.location(), "there is no method '" + meth.name().name + "' on '" + cd.name().uniqueName() + "'");
            }
        }
    }

    @Override
    public void visitObjectCtor(ObjectCtor ctor) {
        this.scopeStack.add(0, this.scope);
        this.scope = ctor.name();
        this.inside = ctor;
    }

    @Override
    public void visitConstructorMatch(ConstructorMatch p, boolean isNested) {
        RepositoryEntry defn = this.find(p.location(), this.scope, p.ctor);
        if (defn == null) {
            this.errors.message(p.location(), "cannot find type '" + p.ctor + "'");
            return;
        }
        if (!(defn instanceof StructDefn)) {
            this.errors.message(p.location(), p.ctor + " is not a struct defn");
            return;
        }
        p.bind((StructDefn)defn);
    }

    @Override
    public void leaveFunctionIntro(FunctionIntro fi) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveFunction(FunctionDefinition fn) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveObjectMethod(ObjectMethod meth) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveObjectCtor(ObjectCtor oa) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void visitTuple(TupleAssignment ta) {
        this.scopeStack.add(0, this.scope);
        this.scope = ta.scopePackage();
    }

    @Override
    public void leaveTuple(TupleAssignment e) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void visitStructDefn(StructDefn sd) {
        this.scopeStack.add(0, this.scope);
        this.scope = sd.name();
    }

    @Override
    public void visitUnionTypeDefn(UnionTypeDefn ud) {
        this.scopeStack.add(0, this.scope);
        this.scope = ud.name();
    }

    @Override
    public void visitObjectDefn(ObjectDefn sd) {
        this.scopeStack.add(0, this.scope);
        this.scope = sd.name();
    }

    @Override
    public void visitCardDefn(CardDefinition cd) {
        this.scopeStack.add(0, this.scope);
        this.scope = cd.name();
    }

    @Override
    public void visitAgentDefn(AgentDefinition sd) {
        this.scopeStack.add(0, this.scope);
        this.scope = sd.name();
    }

    @Override
    public void visitServiceDefn(ServiceDefinition sd) {
        this.scopeStack.add(0, this.scope);
        this.scope = sd.name();
    }

    @Override
    public void visitImplements(ImplementsContract ic) {
        this.scopeStack.add(0, this.scope);
        this.scope = ic.name();
        this.currentlyImplementing = ic;
    }

    @Override
    public void visitProvides(Provides p) {
        this.scopeStack.add(0, this.scope);
        this.scope = p.name();
        this.currentlyImplementing = p;
    }

    @Override
    public void visitHandlerImplements(HandlerImplements hi) {
        this.scopeStack.add(0, this.scope);
        this.scope = hi.name();
        this.currentlyImplementing = hi;
    }

    @Override
    public void leaveProvides(Provides p) {
        this.currentlyImplementing = null;
        ContractDecl d = p.actualType();
        if (d == null) {
            if (p.implementsType().namedDefn() != null) {
                this.errors.message(p.implementsType().location(), p.implementsType().name() + " is not a contract");
            }
            return;
        }
        if (d.type != ContractDecl.ContractType.SERVICE) {
            this.errors.message(p.implementsType().location(), "cannot provide non-service contract");
            return;
        }
        block0: for (ContractMethodDecl cmd : d.methods) {
            if (!cmd.required) continue;
            for (ObjectMethod m : p.implementationMethods) {
                if (!m.name().name.equals(cmd.name.name)) continue;
                continue block0;
            }
            this.errors.message(p.location(), "must implement required contract method " + cmd.name.uniqueName());
        }
    }

    @Override
    public void leaveImplements(ImplementsContract ic) {
        this.currentlyImplementing = null;
        ContractDecl d = ic.actualType();
        if (d == null) {
            if (ic.implementsType().namedDefn() != null) {
                this.errors.message(ic.implementsType().location(), ic.implementsType().name() + " is not a contract");
            }
            return;
        }
        if (d.type != ContractDecl.ContractType.CONTRACT) {
            this.errors.message(ic.implementsType().location(), "cannot implement " + d.type.toString().toLowerCase() + " contract");
            return;
        }
        block0: for (ContractMethodDecl cmd : d.methods) {
            if (!cmd.required) continue;
            for (ObjectMethod m : ic.implementationMethods) {
                if (!m.name().name.equals(cmd.name.name)) continue;
                continue block0;
            }
            this.errors.message(ic.location(), "must implement required contract method " + cmd.name.uniqueName());
        }
    }

    @Override
    public void leaveHandlerImplements(HandlerImplements hi) {
        this.currentlyImplementing = null;
        ContractDecl d = hi.actualType();
        if (d == null) {
            if (hi.implementsType().namedDefn() != null) {
                this.errors.message(hi.implementsType().location(), hi.implementsType().name() + " is not a contract");
            }
            return;
        }
        if (d.type != ContractDecl.ContractType.HANDLER) {
            this.errors.message(hi.implementsType().location(), "handler cannot implement " + (d.type == ContractDecl.ContractType.SERVICE ? "service" : "non-handler") + " contract");
            return;
        }
        block0: for (ContractMethodDecl cmd : d.methods) {
            if (!cmd.required) continue;
            for (ObjectMethod m : hi.implementationMethods) {
                if (!m.name().name.equals(cmd.name.name)) continue;
                continue block0;
            }
            this.errors.message(hi.location(), "must implement required contract method " + cmd.name.uniqueName());
        }
    }

    @Override
    public void leaveStructDefn(StructDefn sd) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveUnionTypeDefn(UnionTypeDefn ud) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveObjectDefn(ObjectDefn sd) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveCardDefn(CardDefinition cd) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveAgentDefn(AgentDefinition sd) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveServiceDefn(ServiceDefinition sd) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        Object e;
        String s = expr.asName();
        if (s != null && (e = this.repository.get(s)) != null) {
            expr.bind((RepositoryEntry)e, true);
            return true;
        }
        return false;
    }

    @Override
    public void leaveMemberExpr(MemberExpr expr, boolean done) {
        RepositoryEntry defn;
        if (expr.boundEarly()) {
            return;
        }
        Expr from = expr.from;
        while (from instanceof ParenExpr) {
            from = (Expr)((ParenExpr)from).expr;
        }
        if (!(expr.fld instanceof UnresolvedVar)) {
            return;
        }
        UnresolvedVar fld = (UnresolvedVar)expr.fld;
        String var = fld.var;
        if (from instanceof MemberExpr) {
            defn = expr.defn();
            if (defn == null) {
                return;
            }
        } else if (from instanceof UnresolvedVar) {
            uv = (UnresolvedVar)from;
            defn = ((UnresolvedVar)uv).defn();
            if (defn == null) {
                return;
            }
        } else if (from instanceof TypeReference) {
            uv = (TypeReference)from;
            defn = (RepositoryEntry)((Object)((TypeReference)uv).namedDefn());
            if (defn == null) {
                return;
            }
        } else {
            if (from instanceof ApplyExpr) {
                return;
            }
            if (from instanceof CastExpr) {
                CastExpr ce = (CastExpr)from;
                NamedType nt = ce.type.namedDefn();
                if (nt == null) {
                    return;
                }
                this.processMemberOfType(expr, nt, var);
                return;
            }
            throw new NotImplementedException("cannot handle elt " + expr.from.getClass());
        }
        if (defn instanceof ObjectDefn) {
            ObjectDefn od = (ObjectDefn)defn;
            ObjectActionHandler ctor = od.getConstructor(var);
            if (ctor == null) {
                this.errors.message(expr.fld.location(), "object " + od.name().uniqueName() + " does not have a ctor " + var);
                return;
            }
            NameOfThing card = this.scope.containingCard();
            if (card == null && !(this.scope instanceof UnitTestName) && !((FunctionName)this.scope).isUnitTest()) {
                this.errors.message(expr.fld.location(), "object " + od.name().uniqueName() + " cannot be created outside card, object or test scope");
                return;
            }
            expr.bind(ctor, false);
        } else if (defn instanceof UnitDataDeclaration) {
            NamedType nt = ((UnitDataDeclaration)defn).ofType.namedDefn();
            this.processMemberOfType(expr, nt, var);
        } else if (defn instanceof TypedPattern) {
            this.processMemberOfType(expr, ((TypedPattern)defn).type.namedDefn(), var);
        } else if (defn instanceof StructField) {
            sft = ((StructField)defn).type.namedDefn();
            this.processMemberOfType(expr, sft, var);
        } else if (defn instanceof TemplateNestedField) {
            TemplateNestedField tnf = (TemplateNestedField)defn;
            if (tnf.type() == null) {
                throw new CantHappenException("cannot handle TNF without type");
            }
            this.processMemberOfType(expr, (NamedType)tnf.type(), var);
        } else if (defn instanceof ObjectContract) {
            ObjectContract oc = (ObjectContract)defn;
            NamedType nd = oc.implementsType().namedDefn();
            if (!(nd instanceof ContractDecl)) {
                this.errors.message(expr.from.location(), "member must refer to a contract");
                return;
            }
            ContractDecl cd = (ContractDecl)nd;
            this.processMemberOfType(expr, cd, var);
        } else if (defn instanceof RequiresContract) {
            RequiresContract rc = (RequiresContract)defn;
            ContractDecl cd = (ContractDecl)rc.implementsType().namedDefn();
            this.processMemberOfType(expr, cd, var);
        } else if (defn instanceof Provides) {
            Provides p = (Provides)defn;
            ContractDecl cd = (ContractDecl)p.implementsType().namedDefn();
            this.processMemberOfType(expr, cd, var);
        } else if (defn instanceof HandlerLambda) {
            sft = ((TypedPattern)((HandlerLambda)defn).patt).type.namedDefn();
            this.processMemberOfType(expr, sft, var);
        } else if (defn instanceof IntroduceVar) {
            IntroduceVar iv = (IntroduceVar)defn;
            if (iv.introducedAs() != null) {
                this.processMemberOfType(expr, (NamedType)iv.introducedAs(), var);
            }
        } else if (!(defn instanceof FunctionDefinition) && !(defn instanceof VarPattern)) {
            throw new NotImplementedException("cannot handle " + defn.getClass());
        }
    }

    private void processMemberOfType(MemberExpr expr, NamedType nt, String var) {
        Object re;
        if (nt == null) {
            if (!this.errors.hasErrors()) {
                throw new CantHappenException("this should have been an error somewhere: expr = " + expr);
            }
            return;
        }
        if (nt instanceof PolyInstance) {
            nt = ((PolyInstance)nt).struct();
        }
        if ((re = this.repository.get(nt.name().uniqueName() + "." + var)) != null) {
            ((UnresolvedVar)expr.fld).bind((RepositoryEntry)re);
        }
        if (nt instanceof StructDefn) {
            StructDefn sd = (StructDefn)nt;
            StructField sf = sd.findField(var);
            if (LoadBuiltins.event.hasCase(sd) && "source".equals(var)) {
                expr.bind(LoadBuiltins.event, false);
                return;
            }
            if (sf == null) {
                this.errors.message(expr.fld.location(), "there is no field '" + var + "' in " + nt.name().uniqueName());
                return;
            }
            expr.bind(sf, false);
        } else if (nt instanceof ObjectDefn) {
            ObjectDefn od = (ObjectDefn)nt;
            if (od.getConstructor(var) != null) {
                this.errors.message(expr.fld.location(), "cannot call constructor on an instance; use type name");
                return;
            }
            FieldAccessor acor = od.getAccessor(var);
            if (acor != null) {
                if (((RepositoryEntry)((Object)acor)).validContexts() == RepositoryEntry.ValidContexts.TESTS) {
                    this.errors.message(expr.fld.location(), ((RepositoryEntry)((Object)acor)).name().uniqueName() + " may only be used in tests");
                    return;
                }
                expr.bind((RepositoryEntry)((Object)acor), false);
                return;
            }
            ObjectMethod om = od.getMethod(var);
            if (om != null) {
                expr.bind(om, false);
                return;
            }
            if (od.state() != null) {
                StructField sf = od.state().findField(var);
                if (sf == null) {
                    return;
                }
                expr.bind(sf, false);
                return;
            }
            this.errors.message(expr.fld.location(), "object " + od.name().uniqueName() + " does not have a method, acor or member " + var);
        } else {
            if (nt instanceof CardDefinition) {
                CardDefinition cd = (CardDefinition)nt;
                if (cd.state() != null) {
                    StructField sf = cd.state().findField(var);
                    if (sf == null) {
                        return;
                    }
                    expr.bind(sf, false);
                    return;
                }
                throw new NotImplementedException("no member " + var + " in " + cd);
            }
            if (nt instanceof AgentDefinition) {
                AgentDefinition cd = (AgentDefinition)nt;
                if (cd.state() != null) {
                    StructField sf = cd.state().findField(var);
                    if (sf == null) {
                        return;
                    }
                    expr.bind(sf, false);
                    return;
                }
                throw new NotImplementedException("no member " + var + " in " + cd);
            }
            if (nt instanceof HandlerImplements) {
                HandlerImplements hi = (HandlerImplements)nt;
                ObjectMethod method = hi.getMethod(var);
                if (method == null) {
                    throw new NotImplementedException("no method " + var + " in " + hi);
                }
                expr.bind(method, false);
            } else if (nt instanceof ContractDecl) {
                ContractDecl cd = (ContractDecl)nt;
                ContractMethodDecl method = cd.getMethod(var);
                if (method == null) {
                    this.errors.message(expr.location, "there is no method '" + var + "' on '" + cd.name().uniqueName() + "'");
                } else {
                    expr.bind(method, false);
                }
            } else if (nt instanceof ApplicationRouting) {
                ApplicationRouting ar = (ApplicationRouting)nt;
                ApplicationRouting.CardBinding card = ar.getCard(var);
                if (card == null) {
                    this.errors.message(expr.fld.location(), "there is no routing entry for " + var);
                } else {
                    expr.bind(card, false);
                }
            } else if (nt instanceof UnionTypeDefn) {
                this.errors.message(expr.fld.location(), "cannot access members of unions");
            } else {
                throw new NotImplementedException("cannot handle member of type " + nt.getClass());
            }
        }
    }

    @Override
    public void visitAssignSlot(Expr slot) {
        this.assigning = true;
    }

    @Override
    public void leaveAssignMessage(AssignMessage msg) {
        this.assigning = false;
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        RepositoryEntry defn = null;
        if (this.templateNestingChain != null) {
            defn = this.templateNestingChain.resolve(this, var);
        }
        if (this.applicationRouting != null) {
            defn = this.applicationRouting.resolve(this, var);
        }
        if (defn == null) {
            defn = this.find(var.location, this.scope, var.var);
        }
        if (defn == null) {
            if (this.templateNestingChain != null && this.templateNestingChain.isEmpty()) {
                this.errors.message(var.location, "there is no bound chain for '" + this.currentTemplate.name().baseName() + "' when resolving '" + var.var + "'");
            } else {
                this.errors.message(var.location, "cannot resolve '" + var.var + "'");
            }
            return;
        }
        if (this.inside instanceof ObjectCtor && !this.assigning && defn instanceof StructField) {
            StructField sf = (StructField)defn;
            if (sf.container instanceof StateDefinition && sf.init == null) {
                this.errors.message(var.location(), "cannot use uninitialized field '" + var.var + "' in constructor " + this.inside.name().uniqueName());
                return;
            }
        }
        var.bind(defn);
    }

    @Override
    public void visitUnresolvedOperator(UnresolvedOperator operator, int nargs) {
        if (operator.op.equals("-") && nargs == 1) {
            operator.bind(LoadBuiltins.unaryMinus);
            return;
        }
        RepositoryEntry defn = this.find(operator.location, this.scope, operator.op);
        if (defn == null) {
            this.errors.message(operator.location, "cannot resolve '" + operator.op + "'");
            return;
        }
        operator.bind(defn);
    }

    @Override
    public void visitTypeReference(TypeReference ref, boolean expectPolys, int exprNargs) {
        if (ref instanceof FunctionTypeReference) {
            this.handleFunctionTypeReference((FunctionTypeReference)ref, expectPolys, exprNargs);
            return;
        }
        if (ref instanceof TupleTypeReference) {
            this.handleTupleTypeReference((TupleTypeReference)ref, expectPolys, exprNargs);
            return;
        }
        String tn = ref.name();
        RepositoryEntry defn = this.find(ref.location(), this.scope, tn);
        if (defn == null) {
            if (expectPolys && PolyTypeToken.validate(tn) && this.inside instanceof FunctionDefinition) {
                defn = ((FunctionDefinition)this.inside).allocatePoly(ref.location(), tn);
            } else if (!this.lookDownwards || (defn = this.findInside(ref.location(), tn)) == null) {
                this.errors.message(ref.location(), "cannot resolve '" + tn + "'");
                return;
            }
        }
        if (ref.isDynamic()) {
            throw new NotImplementedException();
        }
        if (!(defn instanceof NamedType)) {
            this.errors.message(ref.location(), defn.name().uniqueName() + " is not a type");
            return;
        }
        if (expectPolys) {
            PolyHolder ph;
            NamedType nt = (NamedType)((Object)defn);
            if (nt instanceof PolyHolder && (ph = (PolyHolder)nt).hasPolys()) {
                List<PolyType> nd = ph.polys();
                List<TypeReference> nu = ref.polys();
                int ndp = nd.size();
                if (ndp != nu.size()) {
                    this.errors.message(ref.location().locAtEnd(), "expected " + ndp + " poly vars");
                    return;
                }
                ErrorMark mark = this.errors.mark();
                ArrayList<Type> bound = new ArrayList<Type>();
                for (TypeReference tr : nu) {
                    this.visitTypeReference(tr, expectPolys, exprNargs);
                    if (mark.hasMoreNow()) {
                        return;
                    }
                    Type arg = tr.defn();
                    if (arg == null) {
                        throw new CantHappenException("have null type in resolved reference");
                    }
                    if (tn.equals("Crobag") && !TypeHelpers.isEntity(arg)) {
                        if (arg != null) {
                            this.errors.message(tr.location(), "a Crobag can only contain entities, not " + arg.signature());
                        }
                        return;
                    }
                    bound.add(arg);
                }
                ref.bind(new PolyInstance(ref.location(), (NamedType)((Object)defn), bound));
                return;
            }
        } else if (ref.hasPolys()) {
            this.errors.message(ref.location(), "poly vars are not required or allowed here");
        }
        ref.bind((NamedType)((Object)defn));
    }

    private void handleFunctionTypeReference(FunctionTypeReference ref, boolean expectPolys, int exprNargs) {
        ArrayList<Type> boundTo = new ArrayList<Type>();
        for (TypeReference k : ref.args) {
            this.visitTypeReference(k, expectPolys, exprNargs);
            boundTo.add(k.namedDefn());
        }
        ref.bind(new Apply(boundTo));
    }

    private void handleTupleTypeReference(TupleTypeReference ref, boolean expectPolys, int exprNargs) {
        ArrayList<Type> boundTo = new ArrayList<Type>();
        Tuple tt = new Tuple(ref.location(), ref.members.size());
        for (TypeReference k : ref.members) {
            this.visitTypeReference(k, expectPolys, exprNargs);
            boundTo.add(k.defn());
        }
        ref.bind(new PolyInstance(ref.location(), tt, boundTo));
    }

    @Override
    public void visitContractDecl(ContractDecl cd) {
        this.scopeStack.add(0, this.scope);
        this.scope = cd.name();
    }

    @Override
    public void leaveContractMethod(ContractMethodDecl cmd) {
        boolean dobind = true;
        for (TypedPattern tp : cmd.args) {
            if (!(tp.type.namedDefn() instanceof ContractDecl)) continue;
            this.errors.message(tp.location(), "method arguments may not be contracts");
            dobind = false;
        }
        if (cmd.handler != null) {
            if (!(cmd.handler.type.namedDefn() instanceof ContractDecl)) {
                this.errors.message(cmd.handler.location(), "method handler must be a handler contract");
                dobind = false;
            } else if (((ContractDecl)cmd.handler.type.namedDefn()).type != ContractDecl.ContractType.HANDLER) {
                this.errors.message(cmd.handler.location(), "method handler must be a handler contract");
                dobind = false;
            }
        }
        if (dobind) {
            cmd.bindType();
        }
    }

    @Override
    public void leaveContractDecl(ContractDecl cd) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void visitApplicationRouting(ApplicationRouting e) {
        this.scopeStack.add(0, this.scope);
        this.scope = e.packageName();
        this.applicationRouting = new ApplicationRoutingResolver(this.errors, e);
    }

    @Override
    public void visitSubRouting(SubRouting r) {
        this.applicationRouting.nest();
        if (r.path.startsWith("{") && r.path.endsWith("}")) {
            this.applicationRouting.parameter(r.location(), r.path.substring(1, r.path.length() - 1));
        }
    }

    @Override
    public void leaveCardAssignment(ApplicationRouting.CardBinding card) {
        this.applicationRouting.leaveCardAssignment(card);
    }

    @Override
    public void leaveSubRouting(SubRouting r) {
        this.applicationRouting.unnest();
    }

    @Override
    public void leaveApplicationRouting(ApplicationRouting e) {
        this.scope = this.scopeStack.remove(0);
        this.applicationRouting = null;
    }

    @Override
    public void visitTemplate(Template t, boolean isFirst) {
        this.currentTemplate = t;
        this.currentBindings = new TreeSet<String>();
        TemplateName name = t.name();
        CardData webInfo = null;
        webInfo = this.repository.findWeb(name.baseName());
        if (webInfo == null) {
            this.errors.message(name.location(), "there is no web template defined for " + name.baseName());
            return;
        }
        if (isFirst && webInfo.type() != CardType.CARD) {
            this.errors.message(name.location(), "first web template must be a card template, not item " + name.baseName());
            return;
        }
        if (!isFirst && webInfo.type() != CardType.ITEM) {
            this.errors.message(name.location(), "secondary web templates must be item templates, not card " + name.baseName());
            return;
        }
        t.bindWebInfo(webInfo);
        this.inside = t;
    }

    @Override
    public void afterTemplateChainTypes(Template t) {
        if (t.nestingChain() != null) {
            this.templateNestingChain = t.nestingChain();
            t.nestingChain().resolvedTypes(this.errors);
        }
    }

    @Override
    public void visitTemplateBinding(TemplateBinding b) {
        CardData ce = this.currentTemplate.webinfo();
        if (ce == null) {
            return;
        }
        String slot = b.assignsTo.text;
        InputPosition slotLoc = b.assignsTo.location();
        if (!ce.hasField(slot)) {
            this.errors.message(slotLoc, "there is no slot " + slot + " in " + this.currentTemplate.name().baseName());
            return;
        }
        if (this.currentBindings.contains(slot)) {
            this.errors.message(slotLoc, "cannot bind to " + slot + " multiple times");
            return;
        }
        this.currentBindings.add(slot);
        FieldType type = ce.get(slot);
        switch (type) {
            case STYLE: {
                if (!b.doesAssignment()) break;
                this.errors.message(slotLoc, "style field cannot be assigned to");
                break;
            }
            case CONTENT: 
            case IMAGE: 
            case LINK: {
                if (b.doesAssignment()) break;
                this.errors.message(slotLoc, "content field must be assigned to");
                break;
            }
            case CONTAINER: {
                if (b.doesAssignment()) break;
                this.errors.message(slotLoc, "container field must be assigned to");
                break;
            }
            case PUNNET: {
                if (b.doesAssignment()) break;
                this.errors.message(slotLoc, "container field must be assigned to");
                break;
            }
            case CARD: 
            case ITEM: {
                this.errors.message(slotLoc, "cannot add bindings for field of type " + type.toString().toLowerCase());
            }
        }
        b.assignsTo.fieldType(type);
    }

    @Override
    public void visitTemplateEvent(TemplateEvent te) {
        ObjectMethod om;
        RepositoryEntry defn = this.find(te.location(), this.scope, te.handler);
        boolean isEH = false;
        if (defn == null) {
            this.errors.message(te.location(), "cannot resolve '" + te.handler + "'");
            return;
        }
        if (defn instanceof ObjectMethod && (om = (ObjectMethod)defn).isEvent()) {
            isEH = true;
            te.bindHandler(om);
        }
        if (!isEH) {
            this.errors.message(te.location(), defn.name().uniqueName() + " is not an event handler");
            return;
        }
    }

    @Override
    public void leaveTemplateBindingOption(TemplateBindingOption option) {
        if (option.sendsTo != null) {
            UnresolvedVar uv;
            ObjectDefn object = null;
            Expr oe = option.expr;
            if (oe instanceof UnresolvedVar && (uv = (UnresolvedVar)oe).defn() instanceof StructField && ((StructField)uv.defn()).type.namedDefn() instanceof ObjectDefn) {
                object = (ObjectDefn)((StructField)uv.defn()).type.namedDefn();
            }
            String tname = option.sendsTo.name.baseName();
            if (object != null) {
                Template otd = object.getTemplate(tname);
                if (otd == null) {
                    this.errors.message(option.sendsTo.location(), "template " + tname + " is not defined for object " + object.name().baseName());
                } else if (otd.nestingChain() != null) {
                    this.errors.message(option.sendsTo.location(), "cannot send to internal template " + tname + " for " + object.name().baseName());
                } else {
                    option.sendsTo.bindTo(otd);
                }
            } else {
                RepositoryEntry defn = this.find(option.sendsTo.location(), this.scope, tname);
                if (defn == null) {
                    this.errors.message(option.sendsTo.location(), "template " + tname + " is not defined");
                } else if (!(defn instanceof Template)) {
                    this.errors.message(option.sendsTo.location(), "cannot send to " + tname + " which is not a template");
                } else {
                    Template template = (Template)defn;
                    option.sendsTo.bindTo(template);
                    Type ty = this.figureTemplateValueType(oe);
                    if (ty != null) {
                        template.canUse(ty);
                    }
                }
            }
        } else {
            Type ofType = this.isListish(option.expr);
            logger.info("I feel we should be able to do something with the fact that we are filling a container of " + ofType);
        }
    }

    private Type isListish(Expr expr) {
        if (!(expr instanceof UnresolvedVar)) {
            return null;
        }
        RepositoryEntry defn = ((UnresolvedVar)expr).defn();
        if (defn == null) {
            return null;
        }
        if (!(defn instanceof StructField)) {
            return null;
        }
        Type t = ((StructField)defn).type();
        if (TypeHelpers.isListLike(t)) {
            return TypeHelpers.extractListPoly(t);
        }
        return null;
    }

    private Type figureTemplateValueType(Expr oe) {
        if (oe instanceof StringLiteral) {
            return LoadBuiltins.string;
        }
        if (oe instanceof NumericLiteral) {
            return LoadBuiltins.number;
        }
        if (oe instanceof UnresolvedVar) {
            RepositoryEntry rd = ((UnresolvedVar)oe).defn();
            if (rd == null) {
                throw new CantHappenException("unbound var: " + oe);
            }
            if (rd instanceof StructField) {
                PolyInstance pi;
                NamedType pis;
                StructField sf = (StructField)rd;
                Type st = sf.type();
                if (st == null) {
                    return null;
                }
                if (st instanceof PolyInstance && ((pis = (pi = (PolyInstance)st).struct()).equals(LoadBuiltins.list) || pis.equals(LoadBuiltins.crobag))) {
                    st = pi.polys().get(0);
                }
                if (st instanceof StructDefn) {
                    return st;
                }
                if (st instanceof Primitive) {
                    return st;
                }
                this.errors.message(oe.location(), "expected a struct value, not " + st.signature());
                return null;
            }
            if (rd instanceof TemplateNestedField) {
                TemplateNestedField tnf = (TemplateNestedField)rd;
                Type ty = tnf.type();
                if (ty == null) {
                    this.errors.message(oe.location(), "cannot infer types here; explicitly type chained element " + ((UnresolvedVar)oe).var);
                } else if (TypeHelpers.isList(ty)) {
                    ty = TypeHelpers.extractListPoly(ty);
                }
                return ty;
            }
            throw new NotImplementedException("not handling " + rd.getClass());
        }
        if (oe instanceof MemberExpr) {
            MemberExpr me = (MemberExpr)oe;
            if (me.from instanceof UnresolvedVar) {
                Type ty = this.figureTemplateValueType(me.from);
                if (ty instanceof StructDefn) {
                    StructDefn sd = (StructDefn)ty;
                    StructField fld = sd.findField(((UnresolvedVar)me.fld).var);
                    if (fld == null) {
                        this.errors.message(me.fld.location(), "no field " + ((UnresolvedVar)me.fld).var);
                        return null;
                    }
                    return fld.type();
                }
                this.errors.message(oe.location(), "insufficient information to deduce type of expression");
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void leaveTemplate(Template t) {
        this.currentTemplate = null;
        this.templateNestingChain = null;
    }

    @Override
    public void visitUnitTest(UnitTestCase e) {
        this.scopeStack.add(0, this.scope);
        this.scope = e.name;
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        this.scopeStack.add(0, this.scope);
        this.scope = udd.name;
        this.lookDownwards = true;
    }

    @Override
    public void leaveUnitDataDeclaration(UnitDataDeclaration udd) {
        this.lookDownwards = false;
        this.scope = this.scopeStack.remove(0);
        this.checkValidityOfUDDConstruction(udd);
    }

    @Override
    public void visitUnitTestShove(UnitTestShove s) {
        this.currShoveExpr = null;
    }

    @Override
    public void visitShoveSlot(UnresolvedVar v) {
        if (this.currShoveExpr == null) {
            this.visitUnresolvedVar(v, 0);
            if (v.defn() == null) {
                return;
            }
            this.currShoveExpr = v;
        } else if (this.currShoveExpr.defn() instanceof UnitDataDeclaration) {
            UnitDataDeclaration udd = (UnitDataDeclaration)this.currShoveExpr.defn();
            NamedType ty = udd.ofType.namedDefn();
            if (ty instanceof PolyInstance) {
                ty = ((PolyInstance)ty).struct();
            }
            if (ty instanceof StateHolder) {
                StateHolder st = (StateHolder)((Object)ty);
                if (st.state() == null) {
                    this.errors.message(v.location, ty + " does not have state");
                    return;
                }
                StructField f = st.state().findField(v.var);
                if (f == null) {
                    this.errors.message(v.location, "there is no field " + v.var + " in " + ty.name().uniqueName());
                    return;
                }
                v.bind(f);
                this.currShoveExpr = v;
            } else if (ty instanceof StructDefn) {
                StructDefn sd = (StructDefn)ty;
                StructField f = sd.findField(v.var);
                if (f == null) {
                    this.errors.message(v.location, "there is no field " + v.var + " in " + ty.name().uniqueName());
                    return;
                }
                v.bind(f);
                this.currShoveExpr = v;
            } else {
                this.errors.message(v.location, "cannot shove into " + v.var);
            }
        } else {
            throw new NotImplementedException("Cannot handle shove of var " + this.currShoveExpr.defn());
        }
    }

    @Override
    public void visitUnitTestSend(UnitTestSend s) {
        this.scopeStack.add(0, this.scope);
    }

    @Override
    public void leaveUnitTestSend(UnitTestSend s) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void leaveUnitTestRender(UnitTestRender r) {
        UnitDataDeclaration udd = (UnitDataDeclaration)r.card.defn();
        ObjectDefn od = (ObjectDefn)udd.ofType.namedDefn();
        Template otd = od.getTemplate(r.template.name.baseName());
        if (otd == null) {
            this.errors.message(r.template.location(), "there is no template " + r.template.name.baseName());
            return;
        }
        r.template.bindTo(otd);
    }

    private void checkValidityOfUDDConstruction(UnitDataDeclaration udd) {
        NamedType defn = udd.ofType.namedDefn();
        if (defn == null) {
            if (!this.errors.hasErrors()) {
                throw new RuntimeException("the UDD type did not get resolved");
            }
            return;
        }
        if (defn instanceof PolyInstance) {
            defn = ((PolyInstance)defn).struct();
        }
        if (defn instanceof ContractDecl) {
            ContractDecl cd = (ContractDecl)defn;
            if (udd.expr != null && cd.type != ContractDecl.ContractType.HANDLER) {
                this.errors.message(udd.location(), "a contract data declaration may not be initialized");
            }
            if (!udd.fields.isEmpty()) {
                this.errors.message(udd.location(), "a contract data declaration does not have fields to initialize");
            }
        } else if (defn instanceof StructDefn) {
            StructDefn sd = (StructDefn)defn;
            if (udd.expr == null && udd.fields.isEmpty() && sd.argCount() != 0) {
                this.errors.message(udd.location(), "either an expression or at least one field assignment must be specified for " + defn.name().uniqueName());
            }
        } else if (defn instanceof UnionTypeDefn) {
            if (udd.expr == null) {
                this.errors.message(udd.location(), "an expression must be specified for " + defn.name().uniqueName());
            }
        } else if (defn instanceof HandlerImplements) {
            HandlerImplements hi = (HandlerImplements)defn;
            if (udd.expr == null && udd.fields.isEmpty() && hi.argCount() != 0) {
                this.errors.message(udd.name.location, "an expression must be specified for " + defn.name().uniqueName());
            }
        } else if (defn instanceof ObjectDefn) {
            if (udd.expr == null) {
                this.errors.message(udd.name.location, "an expression must be specified for " + defn.name().uniqueName());
            }
        } else if (defn instanceof CardDefinition) {
            if (udd.expr != null) {
                this.errors.message(udd.location(), "cards may not be initialized");
            }
        } else if (defn instanceof AgentDefinition) {
            if (udd.expr != null) {
                this.errors.message(udd.location(), "agents may not be initialized");
            }
        } else if (defn instanceof ServiceDefinition) {
            if (udd.expr != null) {
                this.errors.message(udd.location(), "services may not be initialized");
            }
        } else {
            throw new RuntimeException("udd not handled: " + defn.getClass());
        }
    }

    @Override
    public void leaveUnitTest(TestStepHolder e) {
        this.scope = this.scopeStack.remove(0);
    }

    @Override
    public void visitSystemTestStage(SystemTestStage e) {
        this.scopeStack.add(0, this.scope);
        this.scope = e.name;
    }

    @Override
    public void leaveSystemTestStage(SystemTestStage e) {
        this.scope = this.scopeStack.remove(0);
    }

    private RepositoryEntry find(InputPosition pos, NameOfThing s, String var) {
        RepositoryEntry ret = this.recfind(s, var);
        if (ret == null) {
            return ret;
        }
        if (ret instanceof AccessRestrictions) {
            ((AccessRestrictions)((Object)ret)).check(this.errors, pos, s);
        }
        return ret;
    }

    private RepositoryEntry recfind(NameOfThing s, String var) {
        if (s == null) {
            return this.repository.get(var);
        }
        String name = s.uniqueName() + "." + var;
        boolean found = true;
        Object defn = this.repository.get(name);
        if (defn != null) {
            ObjectMethod om;
            if (defn instanceof ObjectMethod && (om = (ObjectMethod)defn).contractMethod() != null) {
                found = false;
            }
            if (found) {
                return defn;
            }
        }
        return this.recfind(s.container(), var);
    }

    private RepositoryEntry findInside(InputPosition loc, String tn) {
        String scope = this.scope.packageName().uniqueName();
        return this.repository.findNested(this.errors, loc, scope, tn);
    }

    @Override
    public <T extends TraversalProcessor> T forModule(Class<T> extension, Class<? extends RepositoryVisitor> phase) {
        for (TraversalProcessor tp : this.modules) {
            if (!tp.is(extension) || !phase.isInstance(this)) continue;
            if (tp instanceof RepositoryResolverModule) {
                ((RepositoryResolverModule)((Object)tp)).init(this.errors, this.repository);
                ((RepositoryResolverModule)((Object)tp)).currentScope(this.scope);
            }
            return (T)((TraversalProcessor)extension.cast(tp));
        }
        return null;
    }

    public void pushScope(NameOfThing name) {
        this.scopeStack.add(0, this.scope);
        this.scope = name;
    }

    public void popScope() {
        this.scopeStack.remove(0);
    }
}

