/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.resolver;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.resolver.RepositoryResolver;

public class ApplicationRoutingResolver
extends LeafAdapter {
    private final ApplicationRouting e;
    private final List<Scope> scopes = new ArrayList<Scope>();
    private final ErrorReporter errors;

    public ApplicationRoutingResolver(ErrorReporter errors, ApplicationRouting e) {
        this.errors = errors;
        this.e = e;
        this.scopes.add(0, new Scope());
    }

    public void nest() {
        this.scopes.add(0, new Scope());
    }

    public void parameter(InputPosition pos, String param) {
        this.scopes.get((int)0).defns.put(param, new ParameterRepositoryEntry(pos, param));
    }

    @Override
    public void leaveCardAssignment(ApplicationRouting.CardBinding card) {
        RepositoryEntry defn = (RepositoryEntry)((Object)card.cardType.namedDefn());
        if (defn == null) {
            defn = new ParameterRepositoryEntry(card.location(), card.var.var);
        } else if (!(defn instanceof CardDefinition)) {
            this.errors.message(card.cardType.location(), card.cardType.name() + " is not a Card");
        }
        this.scopes.get((int)0).defns.put(card.var.var, defn);
    }

    public void unnest() {
        this.scopes.remove(0);
    }

    public RepositoryEntry resolve(RepositoryResolver resolver, UnresolvedVar var) {
        for (Scope s : this.scopes) {
            if (!s.defns.containsKey(var.var)) continue;
            return s.defns.get(var.var);
        }
        return null;
    }

    public class Scope {
        private Map<String, RepositoryEntry> defns = new TreeMap<String, RepositoryEntry>();
    }

    public class ParameterRepositoryEntry
    implements RepositoryEntry {
        private final InputPosition pos;
        private final String param;

        public ParameterRepositoryEntry(InputPosition pos, String param) {
            this.pos = pos;
            this.param = param;
        }

        @Override
        public NameOfThing name() {
            return new VarName(this.pos, ApplicationRoutingResolver.this.e.name(), this.param);
        }

        @Override
        public InputPosition location() {
            return this.pos;
        }

        @Override
        public void dumpTo(PrintWriter pw) {
            pw.println("parameter " + this.param);
        }
    }
}

