/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.PendingField;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class PendingState
implements TDAParsing {
    private final ErrorReporter errors;
    private final Repository repository;
    private final List<PendingField> fields = new ArrayList<PendingField>();
    private final List<PolyType> polys;
    private StateDefinition sd;

    public PendingState(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        this.errors = errors;
        this.repository = repository;
        this.polys = polys;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        switch (kw.text) {
            case "member": {
                ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                PendingField f = new PendingField(this.errors, tok);
                this.fields.add(f);
                return f;
            }
        }
        throw new NotImplementedException("cannot handle flim field keyword " + kw.text);
    }

    private void create(InputPosition pos) {
        this.sd = new StateDefinition(pos);
    }

    public StateDefinition resolve() {
        for (PendingField pf : this.fields) {
            StructField sf = pf.resolve(this.repository, this.sd, this.polys);
            sf.fullName(new VarName(sf.loc, this.sd.name(), sf.name));
            this.sd.addField(sf);
        }
        return this.sd;
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.create(location);
    }
}

