/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.List;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.PendingType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tokenizers.PackageNameToken;
import org.zinutils.exceptions.CantHappenException;

public class PendingPolyType
implements PendingType {
    private final PackageNameToken pnt;

    public PendingPolyType(PackageNameToken ty) {
        this.pnt = ty;
    }

    @Override
    public Type resolve(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        for (PolyType pt : polys) {
            if (!pt.shortName().equals(this.pnt.text)) continue;
            return pt;
        }
        throw new CantHappenException("could not find " + this.pnt.text + " in " + polys);
    }

    @Override
    public TypeReference resolveAsRef(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        PolyType pt = (PolyType)this.resolve(errors, repository, polys);
        TypeReference tr = new TypeReference(this.pnt.location, this.pnt.text, new TypeReference[0]);
        tr.bind(pt);
        return tr;
    }
}

