/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.PendingType;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tokenizers.PackageNameToken;

public class PendingNamedType
implements PendingType {
    private final PackageNameToken pnt;

    public PendingNamedType(PackageNameToken ty) {
        this.pnt = ty;
    }

    @Override
    public Type resolve(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        Object ret = repository.get(this.pnt.text);
        if (ret == null) {
            errors.message(this.pnt.location, "no such type " + this.pnt.text);
            return new ErrorType();
        }
        if (!(ret instanceof Type)) {
            errors.message(this.pnt.location, this.pnt.text + " is not a type name");
            return new ErrorType();
        }
        return (Type)ret;
    }

    @Override
    public TypeReference resolveAsRef(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        ArrayList<TypeReference> ftpolys = new ArrayList<TypeReference>();
        TypeReference tr = new TypeReference(this.pnt.location, this.pnt.text, ftpolys);
        Type r = this.resolve(errors, repository, polys);
        if (r instanceof NamedType) {
            tr.bind((NamedType)r);
        }
        return tr;
    }
}

