/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.flim.FlimTypeReader;
import org.flasck.flas.repository.flim.PendingContractArg;
import org.flasck.flas.repository.flim.PendingType;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public abstract class PendingMethod
implements TDAParsing {
    private final ErrorReporter errors;
    protected final List<PendingContractArg> args = new ArrayList<PendingContractArg>();
    protected PendingContractArg handler;

    public PendingMethod(ErrorReporter errors) {
        this.errors = errors;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        switch (kw.text) {
            case "arg": {
                final ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                return new FlimTypeReader(this.errors){

                    @Override
                    public void collect(PendingType ty) {
                        PendingMethod.this.args.add(new PendingContractArg(ty, tok.location, tok.text));
                    }
                };
            }
            case "handler": {
                final ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                return new FlimTypeReader(this.errors){

                    @Override
                    public void collect(PendingType ty) {
                        PendingMethod.this.handler = new PendingContractArg(ty, tok.location, tok.text);
                    }
                };
            }
        }
        throw new NotImplementedException("cannot handle flim keyword " + kw.text);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

