/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.jsgen.packaging.JSUploader;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.Traverser;
import org.flasck.flas.repository.flim.FlimVisitor;
import org.flasck.jvm.ziniki.ContentObject;
import org.flasck.jvm.ziniki.FileContentObject;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;

public class FlimWriter {
    private final Repository repository;
    private final File flimdir;
    private final JSUploader uploader;

    public FlimWriter(Repository repository, File flimdir) {
        this.repository = repository;
        this.flimdir = flimdir;
        this.uploader = null;
    }

    public FlimWriter(Repository repository, JSUploader uploader) {
        try {
            this.repository = repository;
            this.flimdir = Files.createTempDirectory("flimdir", new FileAttribute[0]).toFile();
            this.uploader = uploader;
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    public Set<String> export(String pkg) {
        try {
            FileUtils.assertDirectory((File)this.flimdir);
            File file = new File(this.flimdir, pkg + ".flim");
            PrintWriter pw = new PrintWriter(file);
            IndentWriter iw = new IndentWriter(pw, "\t").indent();
            PackageName pkgName = "root.package".equals(pkg) ? new PackageName(false) : new PackageName(pkg);
            FlimVisitor vizier = new FlimVisitor(pkgName, iw);
            new Traverser(vizier).forPackage(pkgName).withObjectMethods().doTraversal(this.repository);
            for (String s : vizier.referencedPackages()) {
                iw.println("usespackage " + s);
            }
            pw.close();
            if (this.uploader != null) {
                this.uploader.uploadFlim((ContentObject)new FileContentObject(file));
            }
            return vizier.referencedPackages();
        }
        catch (IOException e) {
            System.out.println("could not write flim " + pkg + " to " + this.flimdir);
            return null;
        }
    }
}

