/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.compiler.ModuleExtensible;
import org.flasck.flas.compiler.modules.TraversalProcessor;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryVisitor;
import org.flasck.flas.repository.flim.FlimModule;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;
import org.flasck.flas.tc3.Type;
import org.zinutils.bytecode.mock.IndentWriter;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class FlimVisitor
extends LeafAdapter
implements ModuleExtensible {
    private final PackageName pkg;
    private final IndentWriter iw;
    private IndentWriter sfw;
    private IndentWriter cdw;
    private IndentWriter odw;
    private final Set<String> packagesReferenced = new TreeSet<String>();
    private boolean inctor;
    private final Iterable<TraversalProcessor> modules = ServiceLoader.load(TraversalProcessor.class);

    public FlimVisitor(PackageName pkgName, IndentWriter iw) {
        this.pkg = pkgName;
        this.iw = iw;
    }

    public Set<String> referencedPackages() {
        return this.packagesReferenced;
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        this.reference((RepositoryEntry)((Object)var.namedDefn()));
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        this.reference(var.defn());
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (expr.boundEarly()) {
            this.reference(expr.defn());
        }
        return expr.boundEarly();
    }

    private void reference(RepositoryEntry e) {
        String baseName = e.name().packageName().baseName();
        if (baseName == null) {
            return;
        }
        if (baseName.equals(this.pkg.uniqueName())) {
            return;
        }
        this.packagesReferenced.add(baseName);
    }

    @Override
    public void visitStructDefn(StructDefn s) {
        String pkn = this.figurePackageName(s.name().container());
        if (pkn != null) {
            this.iw.println("struct " + pkn + " " + s.name.baseName());
            this.sfw = this.iw.indent();
            for (PolyType v : s.polys()) {
                this.sfw.println("poly " + v.shortName());
            }
        }
    }

    @Override
    public void visitStructField(StructField sf) {
        if (this.sfw != null) {
            this.sfw.println("field " + sf.name);
            IndentWriter fiw = this.sfw.indent();
            fiw.println("init " + (sf.init != null));
            this.showType(fiw, sf.type());
        }
    }

    @Override
    public void leaveStructDefn(StructDefn s) {
        this.sfw = null;
    }

    @Override
    public void visitUnionTypeDefn(UnionTypeDefn ud) {
        String pkn = this.figurePackageName(ud.name().container());
        if (pkn != null) {
            this.iw.println("union " + pkn + " " + ud.name().baseName());
            IndentWriter ufw = this.iw.indent();
            for (PolyType v : ud.polys()) {
                ufw.println("poly " + v.shortName());
            }
            for (TypeReference e : ud.cases) {
                ufw.println("member");
                this.showType(ufw.indent(), e.namedDefn());
            }
        }
    }

    @Override
    public void visitContractDecl(ContractDecl cd) {
        String pkn = this.figurePackageName(cd.name().container());
        if (pkn != null) {
            this.iw.println("contract " + pkn + " " + cd.type.toString().toLowerCase() + " " + cd.name().baseName());
            this.cdw = this.iw.indent();
        }
    }

    @Override
    public void visitContractMethod(ContractMethodDecl cmd) {
        if (this.cdw != null) {
            this.cdw.println("method " + cmd.name.name + " " + cmd.required);
            for (TypedPattern a : cmd.args) {
                IndentWriter aw = this.cdw.indent();
                aw.println("arg " + a.var.var);
                this.showType(aw.indent(), a.type());
            }
            if (cmd.handler != null) {
                IndentWriter hw = this.cdw.indent();
                hw.println("handler " + cmd.handler.var.var);
                this.showType(hw.indent(), cmd.handler.type());
            }
        }
    }

    @Override
    public void leaveContractDecl(ContractDecl cd) {
        this.cdw = null;
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        String pkn = this.figurePackageName(fn.name().container());
        if (pkn != null) {
            this.iw.println("function " + pkn + " " + fn.name().baseName());
            IndentWriter aiw = this.iw.indent();
            this.showPolyVars(aiw, fn.type());
            this.showType(aiw, fn.type());
        }
    }

    @Override
    public void visitObjectDefn(ObjectDefn obj) {
        String pkn = this.figurePackageName(obj.name().container());
        if (pkn != null) {
            this.iw.println("object " + pkn + " " + obj.name().baseName());
            this.odw = this.iw.indent();
            for (PolyType pt : obj.polys()) {
                this.odw.println("poly " + pt.shortName());
            }
        }
    }

    @Override
    public void visitStateDefinition(StateDefinition state) {
        if (this.odw != null && !this.inctor) {
            this.odw.println("state");
            for (StructField e : state.fields) {
                IndentWriter fw = this.odw.indent();
                fw.println("member " + e.name);
                this.showType(fw.indent(), e.type());
            }
        }
    }

    @Override
    public void visitObjectCtor(ObjectCtor oc) {
        if (this.odw != null) {
            this.odw.println("ctor " + oc.name().name.replace("_ctor_", ""));
            this.processArgs(oc.args());
            this.inctor = true;
        }
    }

    @Override
    public void leaveObjectCtor(ObjectCtor oa) {
        this.inctor = false;
    }

    @Override
    public void visitObjectAccessor(ObjectAccessor oa) {
        if (this.odw != null) {
            this.odw.println("acor " + oa.name().name);
            this.showType(this.odw.indent(), oa.type());
        }
    }

    @Override
    public void visitObjectMethod(ObjectMethod om) {
        if (this.odw != null) {
            this.odw.println("method " + om.name().name);
            this.processArgs(om.args());
        }
    }

    private void processArgs(List<Pattern> list) {
        for (Pattern p : list) {
            Pattern tp;
            IndentWriter adw = this.odw.indent();
            if (p instanceof TypedPattern) {
                tp = (TypedPattern)p;
                adw.println("arg " + ((TypedPattern)tp).var.var);
                this.showType(adw.indent(), ((TypedPattern)tp).type());
                continue;
            }
            if (p instanceof VarPattern) {
                tp = (VarPattern)p;
                adw.println("arg " + ((VarPattern)tp).var);
                this.showType(adw.indent(), ((VarPattern)tp).type());
                continue;
            }
            throw new HaventConsideredThisException("are ctormatch patterns allowed here?");
        }
    }

    @Override
    public void leaveObjectDefn(ObjectDefn obj) {
        this.odw = null;
    }

    private void showPolyVars(IndentWriter aiw, Type type) {
        TreeSet<String> vars = new TreeSet<String>();
        this.figurePolyVars(vars, type);
        for (String s : vars) {
            aiw.println("var " + s);
        }
    }

    private void figurePolyVars(TreeSet<String> vars, Type type) {
        if (type instanceof PolyType) {
            vars.add(((PolyType)type).shortName());
        } else if (type instanceof Apply) {
            Apply a = (Apply)type;
            for (int i = 0; i <= a.argCount(); ++i) {
                this.figurePolyVars(vars, a.get(i));
            }
        } else if (type instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)type;
            for (Type t : pi.polys()) {
                this.figurePolyVars(vars, t);
            }
        } else if (!(type instanceof StructDefn || type instanceof UnionTypeDefn || type instanceof ObjectDefn || type instanceof Primitive)) {
            throw new NotImplementedException("poly vars from type " + type.getClass());
        }
    }

    private String figurePackageName(NameOfThing container) {
        if (container == null || !(container instanceof PackageName)) {
            return null;
        }
        PackageName pn = (PackageName)container;
        if (pn.isBuiltin()) {
            return null;
        }
        if (pn.uniqueName() == null && this.pkg.uniqueName() != null) {
            return null;
        }
        if (pn.uniqueName() != null && this.pkg.uniqueName() == null) {
            return null;
        }
        if (this.pkg.uniqueName() != null && !this.pkg.uniqueName().equals(pn.uniqueName())) {
            return null;
        }
        if (this.pkg.uniqueName() == null) {
            return "null";
        }
        return pn.uniqueName();
    }

    private void showType(IndentWriter aiw, Type type) {
        if (type instanceof PolyType) {
            aiw.println("poly " + ((PolyType)type).shortName());
        } else if (type instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)type;
            aiw.println("instance");
            IndentWriter piw = aiw.indent();
            this.showType(piw, pi.struct());
            for (Type pt : pi.polys()) {
                this.showType(piw, pt);
            }
        } else if (type instanceof NamedType) {
            aiw.println("named " + ((NamedType)type).signature());
        } else if (type instanceof Apply) {
            aiw.println("apply");
            IndentWriter iiw = aiw.indent();
            Apply ty = (Apply)type;
            for (int i = 0; i <= ty.argCount(); ++i) {
                this.showType(iiw, ty.get(i));
            }
        } else {
            throw new NotImplementedException("cannot handle " + type);
        }
    }

    @Override
    public <T extends TraversalProcessor> T forModule(Class<T> extension, Class<? extends RepositoryVisitor> phase) {
        for (TraversalProcessor tp : this.modules) {
            if (!tp.is(extension) || !phase.isInstance(this)) continue;
            return (T)((TraversalProcessor)extension.cast(tp));
        }
        return null;
    }

    public void obtain(FlimModule writer) {
        writer.inject(this.iw);
    }
}

