/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimTypeReader;
import org.flasck.flas.repository.flim.PendingType;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PolyTypeToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.zinutils.exceptions.NotImplementedException;

public class FlimUnion
implements TDAParsing {
    private final ErrorReporter errors;
    private final Repository repository;
    private final SolidName tn;
    private final List<PendingType> members = new ArrayList<PendingType>();
    private final List<PolyType> polys = new ArrayList<PolyType>();
    private UnionTypeDefn ud;

    public FlimUnion(ErrorReporter errors, Repository repository, SolidName tn) {
        this.errors = errors;
        this.repository = repository;
        this.tn = tn;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        switch (kw.text) {
            case "member": {
                return new FlimTypeReader(this.errors){

                    @Override
                    public void collect(PendingType ty) {
                        FlimUnion.this.members.add(ty);
                    }
                };
            }
            case "poly": {
                PolyTypeToken ta = PolyTypeToken.from(this.errors, toks);
                this.polys.add(new PolyType(kw.location, new SolidName(this.tn, ta.text)));
                return new NoNestingParser(this.errors);
            }
        }
        throw new NotImplementedException("cannot handle flim field keyword " + kw.text + " at " + kw.location.file + " : " + kw.location.lineNo);
    }

    private void create(InputPosition pos) {
        this.ud = new UnionTypeDefn(pos, false, this.tn, this.polys);
        this.repository.newUnion(this.errors, this.ud);
    }

    public void resolve() {
        for (PendingType um : this.members) {
            this.ud.cases.add(um.resolveAsRef(this.errors, this.repository, this.polys));
        }
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.create(location);
    }
}

