/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.flim.FlimApplyReader;
import org.flasck.flas.repository.flim.FlimInstanceReader;
import org.flasck.flas.repository.flim.PendingNamedType;
import org.flasck.flas.repository.flim.PendingPolyType;
import org.flasck.flas.repository.flim.PendingType;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PackageNameToken;
import org.flasck.flas.tokenizers.PolyTypeToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.zinutils.exceptions.NotImplementedException;

public abstract class FlimTypeReader
implements TDAParsing {
    protected final ErrorReporter errors;

    public FlimTypeReader(ErrorReporter errors) {
        this.errors = errors;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        return this.tryWith(toks, kw);
    }

    protected TDAParsing tryWith(Tokenizable toks, KeywordToken kw) {
        switch (kw.text) {
            case "apply": {
                return new FlimApplyReader(this.errors, this);
            }
            case "instance": {
                return new FlimInstanceReader(this.errors, this);
            }
            case "named": {
                PackageNameToken ty = PackageNameToken.from(this.errors, toks);
                this.collect(new PendingNamedType(ty));
                return new NoNestingParser(this.errors);
            }
            case "poly": {
                PackageNameToken ty = PackageNameToken.from(this.errors, toks);
                this.collect(new PendingPolyType(ty));
                return new NoNestingParser(this.errors);
            }
            case "var": {
                PolyTypeToken ty = PolyTypeToken.from(this.errors, toks);
                this.definePolyVar(ty.location, ty.text);
                return new NoNestingParser(this.errors);
            }
        }
        throw new NotImplementedException("cannot handle flim field keyword " + kw.text);
    }

    protected void definePolyVar(InputPosition location, String text) {
        throw new NotImplementedException("not defined here but in subclass");
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    public abstract void collect(PendingType var1);
}

