/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.ObjectName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimContract;
import org.flasck.flas.repository.flim.FlimFunction;
import org.flasck.flas.repository.flim.FlimObject;
import org.flasck.flas.repository.flim.FlimStruct;
import org.flasck.flas.repository.flim.FlimUnion;
import org.flasck.flas.repository.flim.ReadFlimModule;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PackageNameToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class FlimTop
implements TDAParsing {
    private final ErrorReporter errors;
    private final Repository repository;
    private final String pkg;
    private final List<FlimContract> contracts = new ArrayList<FlimContract>();
    private final List<FlimFunction> functions = new ArrayList<FlimFunction>();
    private final List<FlimStruct> structs = new ArrayList<FlimStruct>();
    private final List<FlimUnion> unions = new ArrayList<FlimUnion>();
    private final List<FlimObject> objects = new ArrayList<FlimObject>();
    public final Set<String> uses = new TreeSet<String>();
    private final Iterable<ReadFlimModule> modules = ServiceLoader.load(ReadFlimModule.class);

    public FlimTop(ErrorReporter errors, Repository repository, String pkg) {
        this.errors = errors;
        this.repository = repository;
        this.pkg = pkg;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        PackageName container;
        InputPosition pos = toks.realinfo();
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        PackageNameToken inpkg = PackageNameToken.from(this.errors, toks);
        if (kw.text.equals("usespackage")) {
            this.uses.add(inpkg.text);
            return new NoNestingParser(this.errors);
        }
        if (this.pkg.equals("root.package") && "null".equals(inpkg.text)) {
            container = new PackageName(false);
        } else if (inpkg.text.equals(this.pkg)) {
            container = new PackageName(this.pkg);
        } else {
            this.errors.message(inpkg.location, "invalid package name");
            return new IgnoreNestedParser(this.errors);
        }
        switch (kw.text) {
            case "contract": {
                ContractDecl.ContractType ct = ContractDecl.ContractType.valueOf(VarNameToken.from((ErrorReporter)this.errors, (Tokenizable)toks).text.toUpperCase());
                TypeNameToken tnt = TypeNameToken.unqualified(this.errors, toks);
                SolidName cn = new SolidName(container, tnt.text);
                FlimContract fc = new FlimContract(this.errors, this.repository, cn, ct);
                this.contracts.add(fc);
                return fc;
            }
            case "struct": {
                TypeNameToken tnt = TypeNameToken.unqualified(this.errors, toks);
                SolidName tn = new SolidName(container, tnt.text);
                FlimStruct fs = new FlimStruct(this.errors, this.repository, tn);
                this.structs.add(fs);
                return fs;
            }
            case "union": {
                TypeNameToken tnt = TypeNameToken.unqualified(this.errors, toks);
                SolidName tn = new SolidName(container, tnt.text);
                FlimUnion fs = new FlimUnion(this.errors, this.repository, tn);
                this.unions.add(fs);
                return fs;
            }
            case "function": {
                ValidIdentifierToken ft = VarNameToken.from(this.errors, toks);
                FlimFunction pf = new FlimFunction(this.errors, this.repository, FunctionName.function(pos, container, ft.text));
                this.functions.add(pf);
                return pf;
            }
            case "object": {
                TypeNameToken tnt = TypeNameToken.unqualified(this.errors, toks);
                ObjectName on = new ObjectName(container, tnt.text);
                FlimObject fs = new FlimObject(this.errors, this.repository, on);
                this.objects.add(fs);
                return fs;
            }
        }
        for (ReadFlimModule m : this.modules) {
            TDAParsing inner = null;
            inner = m.readLine(this.errors, this.repository, kw, container, toks);
            if (inner == null) continue;
            return inner;
        }
        throw new NotImplementedException("cannot handle flim keyword " + kw.text);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    public void resolve() {
        for (FlimStruct flimStruct : this.structs) {
            flimStruct.resolve();
        }
        for (FlimUnion flimUnion : this.unions) {
            flimUnion.resolve();
        }
        for (FlimFunction flimFunction : this.functions) {
            flimFunction.bindType();
        }
        for (FlimContract flimContract : this.contracts) {
            flimContract.resolveMethods();
        }
        for (FlimObject flimObject : this.objects) {
            flimObject.resolve();
        }
    }

    public String pkgName() {
        return this.pkg;
    }

    public String toString() {
        return "FlimTop[" + this.pkg + "]";
    }
}

