/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.PendingField;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PolyTypeToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class FlimStruct
implements TDAParsing {
    private final ErrorReporter errors;
    private final Repository repository;
    private final SolidName tn;
    private final List<PendingField> fields = new ArrayList<PendingField>();
    private final List<PolyType> polys = new ArrayList<PolyType>();
    private StructDefn sd;

    public FlimStruct(ErrorReporter errors, Repository repository, SolidName tn) {
        this.errors = errors;
        this.repository = repository;
        this.tn = tn;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        switch (kw.text) {
            case "field": {
                ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                PendingField f = new PendingField(this.errors, tok);
                this.fields.add(f);
                return f;
            }
            case "poly": {
                PolyTypeToken ta = PolyTypeToken.from(this.errors, toks);
                this.polys.add(new PolyType(kw.location, new SolidName(this.tn, ta.text)));
                return new NoNestingParser(this.errors);
            }
        }
        throw new NotImplementedException("cannot handle flim field keyword " + kw.text);
    }

    private void create(InputPosition pos) {
        this.sd = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, this.tn, false, this.polys);
        this.repository.newStruct(this.errors, this.sd);
    }

    public void resolve() {
        for (PendingField pf : this.fields) {
            StructField sf = pf.resolve(this.repository, this.sd, this.polys);
            sf.fullName(new VarName(sf.loc, this.sd.name(), sf.name));
            this.sd.addField(sf);
            this.repository.newStructField(this.errors, sf);
        }
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.create(location);
    }
}

