/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.Blocker;
import org.flasck.flas.blocker.TDANester;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimTop;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.graphs.DirectedAcyclicGraph;
import org.zinutils.utils.FileUtils;

public class FlimReader {
    static final Logger logger = LoggerFactory.getLogger((String)"Compiler");
    private final ErrorReporter errors;
    private final Repository repository;

    public FlimReader(ErrorReporter errors, Repository repository) {
        this.errors = errors;
        this.repository = repository;
    }

    public void read(DirectedAcyclicGraph<String> pkgs, File flimdir, List<File> butNot) {
        if (flimdir == null) {
            return;
        }
        if (!flimdir.exists()) {
            logger.warn("cannot read flim dir " + flimdir);
            return;
        }
        ArrayList<String> ignore = new ArrayList<String>();
        for (File i : butNot) {
            ignore.add(i.getName());
        }
        if (ignore.contains("root.package")) {
            return;
        }
        HashSet<FlimTop> importers = new HashSet<FlimTop>();
        for (File f : FileUtils.findFilesMatching((File)flimdir, (String)"*.flim")) {
            String name = FileUtils.dropExtension((String)f.getName());
            if (ignore.contains(name) || pkgs.hasNode((Object)name)) continue;
            logger.info("reading flim file for " + name + " from " + f);
            this.repository.readingFLIM(name);
            FlimTop importer = this.importFlim(f, name);
            if (importer == null) continue;
            importers.add(importer);
            pkgs.ensure((Object)name);
            for (String s : importer.uses) {
                pkgs.ensure((Object)s);
                pkgs.ensureLink((Object)name, (Object)s);
            }
        }
        if (this.errors.hasErrors()) {
            return;
        }
        for (FlimTop ft : importers) {
            this.repository.selectPackage(ft.pkgName());
            ft.resolve();
        }
    }

    public FlimTop read(DirectedAcyclicGraph<String> pkgs, String pkg, ContentObject co) {
        FlimTop importer = this.importFlim(new InputStreamReader(co.asStream()), pkg, pkg);
        pkgs.ensure((Object)pkg);
        for (String s : importer.uses) {
            pkgs.ensure((Object)s);
            pkgs.ensureLink((Object)pkg, (Object)s);
        }
        return importer;
    }

    private FlimTop importFlim(File f, String name) {
        String fn = f.getName();
        try {
            FileReader r = new FileReader(f);
            return this.importFlim(r, name, fn);
        }
        catch (FileNotFoundException ex) {
            this.errors.message(new InputPosition(fn, -1, -1, null, null), "file does not exist");
            return null;
        }
    }

    private FlimTop importFlim(Reader r, String name, String fn) {
        block13: {
            FlimTop flimTop;
            FlimTop ret = new FlimTop(this.errors, this.repository, name);
            Blocker blocker = new Blocker(this.errors, new TDANester(this.errors, ret));
            LineNumberReader lnr = new LineNumberReader(r);
            try {
                String s;
                blocker.newFile();
                while ((s = lnr.readLine()) != null) {
                    blocker.present(fn, lnr.getLineNumber(), s);
                }
                blocker.flush();
                flimTop = ret;
            }
            catch (IOException ex) {
                try {
                    try {
                        this.errors.message(new InputPosition(fn, lnr.getLineNumber(), -1, null, null), ex.toString());
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        lnr.close();
                    }
                }
                catch (FileNotFoundException ex2) {
                    this.errors.message(new InputPosition(fn, -1, -1, null, null), "file does not exist");
                    break block13;
                }
                catch (IOException ex3) {
                    this.errors.message(new InputPosition(fn, -1, -1, null, null), ex3.toString());
                    break block13;
                }
                catch (Throwable t) {
                    this.errors.reportException(t);
                }
            }
            lnr.close();
            return flimTop;
        }
        return null;
    }
}

