/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.PendingObjectAcor;
import org.flasck.flas.repository.flim.PendingObjectCtor;
import org.flasck.flas.repository.flim.PendingObjectMethod;
import org.flasck.flas.repository.flim.PendingState;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PolyTypeToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class FlimObject
implements TDAParsing {
    private final ErrorReporter errors;
    private final Repository repository;
    private final SolidName on;
    private PendingState state;
    private final List<PendingObjectCtor> ctors = new ArrayList<PendingObjectCtor>();
    private final List<PendingObjectAcor> acors = new ArrayList<PendingObjectAcor>();
    private final List<PendingObjectMethod> methods = new ArrayList<PendingObjectMethod>();
    private final List<PolyType> polys = new ArrayList<PolyType>();
    private ObjectDefn od;

    public FlimObject(ErrorReporter errors, Repository repository, SolidName tn) {
        this.errors = errors;
        this.repository = repository;
        this.on = tn;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        switch (kw.text) {
            case "state": {
                this.state = new PendingState(this.errors, this.repository, this.polys);
                return this.state;
            }
            case "ctor": {
                ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                PendingObjectCtor ctor = new PendingObjectCtor(this.errors, kw.location, FunctionName.objectCtor(kw.location, this.on, tok.text));
                this.ctors.add(ctor);
                return ctor;
            }
            case "acor": {
                ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                PendingObjectAcor acor = new PendingObjectAcor(this.errors, FunctionName.function(kw.location, this.on, tok.text));
                this.acors.add(acor);
                return acor;
            }
            case "method": {
                ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                PendingObjectMethod meth = new PendingObjectMethod(this.errors, kw.location, FunctionName.objectMethod(kw.location, this.on, tok.text));
                this.methods.add(meth);
                return meth;
            }
            case "poly": {
                PolyTypeToken ta = PolyTypeToken.from(this.errors, toks);
                this.polys.add(new PolyType(kw.location, new SolidName(this.on, ta.text)));
                return new NoNestingParser(this.errors);
            }
        }
        throw new NotImplementedException("cannot handle flim field keyword " + kw.text + " at " + kw.location.file + " : " + kw.location.lineNo);
    }

    private void create(InputPosition pos) {
        this.od = new ObjectDefn(pos, pos, this.on, false, this.polys);
        this.repository.newObject(this.errors, this.od);
    }

    public void resolve() {
        ObjectActionHandler oc;
        if (this.state != null) {
            this.od.defineState(this.state.resolve());
        }
        for (PendingObjectCtor c : this.ctors) {
            oc = c.resolve(this.errors, this.repository, this.od);
            this.od.addConstructor((ObjectCtor)oc);
        }
        for (PendingObjectAcor a : this.acors) {
            ObjectAccessor oa = a.resolve(this.errors, this.repository, this.od, this.polys);
            this.od.addAccessor(oa);
        }
        for (PendingObjectMethod m : this.methods) {
            oc = m.resolve(this.errors, this.repository, this.od);
            this.od.addMethod((ObjectMethod)oc);
        }
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.create(location);
    }

    public String toString() {
        return "FlimObject[" + this.on + "]";
    }
}

