/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimTypeReader;
import org.flasck.flas.repository.flim.PendingType;
import org.flasck.flas.tc3.ErrorType;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Type;

public class FlimInstanceReader
extends FlimTypeReader
implements PendingType {
    private final FlimTypeReader parent;
    private final List<PendingType> args = new ArrayList<PendingType>();
    private InputPosition location;

    public FlimInstanceReader(ErrorReporter errors, FlimTypeReader parent) {
        super(errors);
        this.parent = parent;
    }

    @Override
    public void collect(PendingType ty) {
        this.args.add(ty);
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.location = location;
        this.parent.collect(this);
    }

    @Override
    public Type resolve(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        Type rt = this.args.get(0).resolve(errors, repository, polys);
        if (rt instanceof ErrorType) {
            return rt;
        }
        NamedType nt = (NamedType)rt;
        ArrayList<Type> inpolys = new ArrayList<Type>();
        for (int i = 1; i < this.args.size(); ++i) {
            inpolys.add(this.args.get(i).resolve(errors, repository, polys));
        }
        return new PolyInstance(this.location, nt, inpolys);
    }

    @Override
    public TypeReference resolveAsRef(ErrorReporter errors, Repository repository, List<PolyType> polys) {
        Type resolve = this.resolve(errors, repository, polys);
        if (resolve instanceof ErrorType) {
            return null;
        }
        PolyInstance pi = (PolyInstance)resolve;
        ArrayList<TypeReference> inpolys = new ArrayList<TypeReference>();
        for (int i = 1; i < this.args.size(); ++i) {
            inpolys.add(this.args.get(i).resolveAsRef(errors, repository, polys));
        }
        TypeReference tr = new TypeReference(pi.location(), pi.name().baseName(), inpolys);
        tr.bind(pi);
        return tr;
    }
}

