/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimTypeReader;
import org.flasck.flas.repository.flim.PendingType;
import org.zinutils.exceptions.CantHappenException;

public class FlimFunction
extends FlimTypeReader
implements TDAParsing {
    private final Repository repository;
    private final FunctionName fn;
    private final List<PolyType> polys = new ArrayList<PolyType>();
    private final List<PendingType> args = new ArrayList<PendingType>();
    private StateHolder holder;
    private FunctionDefinition fd;

    public FlimFunction(ErrorReporter errors, Repository repository, FunctionName fn) {
        super(errors);
        this.repository = repository;
        this.fn = fn;
    }

    public void create() {
        this.fd = new FunctionDefinition(this.fn, this.args.size(), this.holder);
        this.fd.dontGenerate();
        this.repository.functionDefn(this.errors, this.fd);
    }

    @Override
    protected void definePolyVar(InputPosition location, String text) {
        this.polys.add(new PolyType(location, new SolidName(this.fn, text)));
    }

    @Override
    public void collect(PendingType ty) {
        this.args.add(ty);
    }

    public void bindType() {
        if (this.args.size() != 1) {
            throw new CantHappenException("should have one arg at the end of the day, even if it's an apply");
        }
        this.fd.bindType(this.args.get(0).resolve(this.errors, this.repository, this.polys));
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.create();
    }
}

