/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimContractMethod;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class FlimContract
implements TDAParsing {
    private final ErrorReporter errors;
    private final Repository repository;
    private final SolidName name;
    private final ContractDecl.ContractType type;
    private final List<FlimContractMethod> methods = new ArrayList<FlimContractMethod>();
    private ContractDecl cd;

    public FlimContract(ErrorReporter errors, Repository repository, SolidName name, ContractDecl.ContractType type) {
        this.errors = errors;
        this.repository = repository;
        this.name = name;
        this.type = type;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        switch (kw.text) {
            case "method": {
                ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
                ValidIdentifierToken reqd = VarNameToken.from(this.errors, toks);
                FlimContractMethod ret = new FlimContractMethod(this.errors, this.repository, this.name, tok.location, tok.text, Boolean.parseBoolean(reqd.text));
                this.methods.add(ret);
                return ret;
            }
        }
        throw new NotImplementedException("cannot handle flim keyword " + kw.text);
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.create(location);
    }

    private void create(InputPosition location) {
        this.cd = new ContractDecl(location, location, this.type, this.name, false);
        this.repository.newContract(this.errors, this.cd);
    }

    public void resolveMethods() {
        for (FlimContractMethod fcm : this.methods) {
            this.cd.addMethod(fcm.resolve(this.errors, this.repository));
        }
    }
}

