/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.ConstPattern;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.NumericLiteral;
import org.flasck.flas.commonBase.ParenExpr;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.commonBase.names.CSName;
import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.ObjectName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.compiler.DeferMeException;
import org.flasck.flas.compiler.modules.TraverserModule;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.CMSlot;
import org.flasck.flas.hsi.HSIVisitor;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.hsi.TreeOrderVisitor;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.ActionMessage;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.CheckTypeExpr;
import org.flasck.flas.parsedForm.ConstructorMatch;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.CurrentContainer;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.HandlerHolder;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.ImplementsContract;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.MakeAcor;
import org.flasck.flas.parsedForm.MakeSend;
import org.flasck.flas.parsedForm.Messages;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PatternsHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.SendMessage;
import org.flasck.flas.parsedForm.ServiceDefinition;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateCustomization;
import org.flasck.flas.parsedForm.TemplateEvent;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.assembly.ApplicationAssembly;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.parsedForm.assembly.LibraryAssembly;
import org.flasck.flas.parsedForm.assembly.RoutingAction;
import org.flasck.flas.parsedForm.assembly.RoutingActions;
import org.flasck.flas.parsedForm.assembly.SubRouting;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.parsedForm.ut.TestStepHolder;
import org.flasck.flas.parsedForm.ut.UnitTestAssert;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.parsedForm.ut.UnitTestClose;
import org.flasck.flas.parsedForm.ut.UnitTestEvent;
import org.flasck.flas.parsedForm.ut.UnitTestExpect;
import org.flasck.flas.parsedForm.ut.UnitTestExpectCancel;
import org.flasck.flas.parsedForm.ut.UnitTestIdentical;
import org.flasck.flas.parsedForm.ut.UnitTestInput;
import org.flasck.flas.parsedForm.ut.UnitTestInvoke;
import org.flasck.flas.parsedForm.ut.UnitTestMatch;
import org.flasck.flas.parsedForm.ut.UnitTestNewDiv;
import org.flasck.flas.parsedForm.ut.UnitTestPackage;
import org.flasck.flas.parsedForm.ut.UnitTestRender;
import org.flasck.flas.parsedForm.ut.UnitTestSend;
import org.flasck.flas.parsedForm.ut.UnitTestShove;
import org.flasck.flas.parsedForm.ut.UnitTestStep;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.patterns.HSICtorTree;
import org.flasck.flas.patterns.HSIOptions;
import org.flasck.flas.patterns.HSITree;
import org.flasck.flas.repository.BackupPlan;
import org.flasck.flas.repository.DontConsiderAgain;
import org.flasck.flas.repository.FunctionGroup;
import org.flasck.flas.repository.FunctionGroups;
import org.flasck.flas.repository.FunctionHSICases;
import org.flasck.flas.repository.HSICases;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryVisitor;
import org.flasck.flas.repository.StackVisitor;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class Traverser
implements RepositoryVisitor {
    static final Logger logger = LoggerFactory.getLogger((String)"Traverser");
    static final Logger patternsLogger = LoggerFactory.getLogger((String)"TOPatterns");
    static final Logger tcLogger = LoggerFactory.getLogger((String)"TypeChecker");
    static final Logger hsiLogger = LoggerFactory.getLogger((String)"HSI");
    private final RepositoryVisitor visitor;
    private LogicHolder currentFunction;
    private FunctionGroups functionOrder;
    private boolean wantImplementedMethods = false;
    private boolean wantNestedPatterns;
    private boolean wantHSI;
    private boolean wantEventSources = false;
    private boolean wantMethodMembersWithObjects = false;
    private boolean visitMemberFields = false;
    private PackageName onlyPackage;
    private boolean isConverted;
    private boolean currFnHasState;
    private Comparator<NamedType> unionLastOrder = new Comparator<NamedType>(){

        @Override
        public int compare(NamedType o1, NamedType o2) {
            boolean o2isA;
            boolean o1isA = o1 == LoadBuiltins.any;
            boolean bl = o2isA = o2 == LoadBuiltins.any;
            if (o1isA && o2isA) {
                return 0;
            }
            if (o1isA) {
                return 1;
            }
            if (o2isA) {
                return -1;
            }
            boolean o1isU = o1 instanceof UnionTypeDefn;
            boolean o2isU = o2 instanceof UnionTypeDefn;
            if (!o1isU && o2isU) {
                return -1;
            }
            if (o1isU && !o2isU) {
                return 1;
            }
            return NamedType.nameComparator.compare(o1, o2);
        }
    };
    private Repository repository;
    private Iterable<TraverserModule> modules = null;

    public Traverser(RepositoryVisitor visitor) {
        this.visitor = visitor;
        this.modules = ServiceLoader.load(TraverserModule.class);
    }

    public Traverser withImplementedMethods() {
        this.wantImplementedMethods = true;
        return this;
    }

    public Traverser withObjectMethods() {
        this.wantMethodMembersWithObjects = true;
        return this;
    }

    public Traverser withNestedPatterns() {
        this.wantNestedPatterns = true;
        return this;
    }

    public Traverser withHSI() {
        this.wantHSI = true;
        return this;
    }

    public Traverser withFunctionsInDependencyGroups(FunctionGroups order) {
        this.functionOrder = order;
        return this;
    }

    public Traverser withMemberFields() {
        this.visitMemberFields = true;
        return this;
    }

    public Traverser withEventSources() {
        this.wantEventSources = true;
        return this;
    }

    public Traverser forPackage(PackageName pkg) {
        this.onlyPackage = pkg;
        return this;
    }

    public void doTraversal(Repository repository) {
        this.repository = repository;
        if (this.functionOrder != null) {
            Iterator<Object> todo = this.functionOrder.iterator();
            int cnt = this.functionOrder.size();
            while (todo.hasNext()) {
                ArrayList<FunctionGroup> arrayList = new ArrayList<FunctionGroup>();
                while (todo.hasNext()) {
                    FunctionGroup grp = (FunctionGroup)todo.next();
                    try {
                        this.visitFunctionGroup(grp);
                    }
                    catch (DeferMeException ex) {
                        patternsLogger.info("aborted processing " + ex.toString());
                        ((StackVisitor)this.visitor).reduceTo(1);
                        arrayList.add(grp);
                    }
                }
                if (arrayList.size() == cnt) {
                    throw new HaventConsideredThisException("There appears to be no order in which these functions can be processed: " + arrayList);
                }
                todo = arrayList.iterator();
                cnt = arrayList.size();
            }
        }
        TreeSet<? super RepositoryEntry> entriesInSomeOrder = new TreeSet<RepositoryEntry>(RepositoryEntry.preferredOrder);
        entriesInSomeOrder.addAll(repository.dict.values());
        logger.debug("about to visit " + entriesInSomeOrder);
        for (RepositoryEntry repositoryEntry : entriesInSomeOrder) {
            logger.debug("visiting " + repositoryEntry);
            this.visitEntry(repositoryEntry);
        }
        this.traversalDone();
    }

    @Override
    public void visitEntry(RepositoryEntry e) {
        if (e == null) {
            throw new NotImplementedException("traverser cannot handle null entries");
        }
        if (!this.isDesiredPackage(e)) {
            return;
        }
        if (e instanceof Primitive) {
            this.visitPrimitive((Primitive)e);
        } else if (e instanceof ContractDecl) {
            this.visitContractDecl((ContractDecl)e);
        } else if (e instanceof ObjectDefn) {
            this.visitObjectDefn((ObjectDefn)e);
        } else if (e instanceof AgentDefinition) {
            this.visitAgentDefn((AgentDefinition)e);
        } else if (e instanceof ServiceDefinition) {
            this.visitServiceDefn((ServiceDefinition)e);
        } else if (e instanceof CardDefinition) {
            this.visitCardDefn((CardDefinition)e);
        } else if (e instanceof FunctionDefinition) {
            if (this.functionOrder == null) {
                this.visitFunction((FunctionDefinition)e);
            }
        } else if (e instanceof TupleAssignment) {
            if (this.functionOrder == null) {
                this.visitTuple((TupleAssignment)e);
            }
        } else if (!(e instanceof TupleMember)) {
            if (e instanceof ObjectMethod) {
                if (this.functionOrder == null) {
                    this.visitObjectMethod((ObjectMethod)e);
                }
            } else if (e instanceof ObjectAccessor) {
                if (this.functionOrder == null) {
                    this.visitObjectAccessor((ObjectAccessor)e);
                }
            } else if (e instanceof ObjectCtor) {
                if (this.functionOrder == null) {
                    this.visitObjectCtor((ObjectCtor)e);
                }
            } else if (e instanceof StandaloneMethod) {
                if (this.functionOrder == null) {
                    this.visitStandaloneMethod((StandaloneMethod)e);
                }
            } else if (e instanceof HandlerImplements) {
                HandlerImplements hi = (HandlerImplements)e;
                this.visitHandlerImplements(hi);
            } else if (e instanceof StructDefn) {
                StructDefn s = (StructDefn)e;
                if (s.generate) {
                    this.visitStructDefn(s);
                }
            } else if (e instanceof UnionTypeDefn) {
                UnionTypeDefn u = (UnionTypeDefn)e;
                if (u.generate) {
                    this.visitUnionTypeDefn(u);
                }
            } else if (e instanceof UnitTestPackage) {
                this.visitUnitTestPackage((UnitTestPackage)e);
            } else if (e instanceof SystemTest) {
                this.visitSystemTest((SystemTest)e);
            } else if (!(e instanceof UnitDataDeclaration)) {
                if (e instanceof StructField) {
                    this.visitStructFieldAccessor((StructField)e);
                } else if (e instanceof ApplicationAssembly) {
                    this.visitAssembly((ApplicationAssembly)e);
                } else if (!(e instanceof LibraryAssembly || e instanceof ApplicationRouting || e instanceof VarPattern || e instanceof TypedPattern || e instanceof IntroduceVar || e instanceof HandlerLambda || e instanceof PolyType || e instanceof RequiresContract || e instanceof Provides || e instanceof ObjectContract || e instanceof ImplementsContract || e instanceof Template || e instanceof ContractMethodDecl)) {
                    if (this.modules != null) {
                        TraverserModule m;
                        boolean done = false;
                        Iterator<TraverserModule> iterator = this.modules.iterator();
                        while (iterator.hasNext() && !(done = (m = iterator.next()).visitEntry(this, this.visitor, e))) {
                        }
                        if (!done) {
                            throw new NotImplementedException("cannot handle " + e.getClass());
                        }
                    } else {
                        throw new NotImplementedException("traverser cannot handle " + e.getClass());
                    }
                }
            }
        }
    }

    private boolean isDesiredPackage(RepositoryEntry e) {
        if (this.onlyPackage == null) {
            return true;
        }
        if (this.onlyPackage.baseName() == null) {
            return e.name().packageName().baseName() == null;
        }
        return this.onlyPackage.baseName().equals(e.name().packageName().baseName());
    }

    @Override
    public void visitPrimitive(Primitive p) {
        this.visitor.visitPrimitive(p);
    }

    @Override
    public void visitStructDefn(StructDefn s) {
        this.visitor.visitStructDefn(s);
        for (StructField f : s.fields) {
            this.visitStructField(f);
        }
        this.leaveStructDefn(s);
    }

    @Override
    public void visitStructField(StructField sf) {
        this.visitor.visitStructField(sf);
        this.visitTypeReference(sf.type, true, -1);
        if (sf.init != null) {
            this.visitExpr(sf.init, 0);
        }
        this.leaveStructField(sf);
    }

    @Override
    public void leaveStructField(StructField sf) {
        this.visitor.leaveStructField(sf);
    }

    @Override
    public void leaveStructDefn(StructDefn s) {
        this.visitor.leaveStructDefn(s);
    }

    @Override
    public void visitStructFieldAccessor(StructField sf) {
        if (this.wantHSI && sf.accessor) {
            this.visitor.visitStructFieldAccessor(sf);
            this.leaveStructFieldAccessor(sf);
        }
    }

    @Override
    public void leaveStructFieldAccessor(StructField sf) {
        this.visitor.leaveStructFieldAccessor(sf);
    }

    @Override
    public void visitUnionTypeDefn(UnionTypeDefn ud) {
        this.visitor.visitUnionTypeDefn(ud);
        for (TypeReference c : ud.cases) {
            this.visitTypeReference(c, true, -1);
        }
        this.leaveUnionTypeDefn(ud);
    }

    @Override
    public void leaveUnionTypeDefn(UnionTypeDefn ud) {
        this.visitor.leaveUnionTypeDefn(ud);
    }

    @Override
    public void visitObjectDefn(ObjectDefn obj) {
        this.visitor.visitObjectDefn(obj);
        this.visitStateDefinition(obj.state());
        for (ObjectContract objectContract : obj.contracts) {
            this.visitObjectContract(objectContract);
        }
        for (Template template : obj.templates) {
            this.visitTemplate(template, false);
        }
        if (this.wantMethodMembersWithObjects) {
            for (ObjectCtor objectCtor : obj.ctors) {
                this.visitObjectCtor(objectCtor);
            }
            for (ObjectAccessor objectAccessor : obj.acors) {
                this.visitObjectAccessor(objectAccessor);
            }
            for (ObjectMethod objectMethod : obj.methods) {
                this.visitObjectMethod(objectMethod);
            }
        }
        this.leaveObjectDefn(obj);
    }

    @Override
    public void visitStateDefinition(StateDefinition state) {
        if (state != null) {
            this.visitor.visitStateDefinition(state);
            for (StructField f : state.fields) {
                this.visitStructField(f);
            }
            this.leaveStateDefinition(state);
        }
    }

    @Override
    public void leaveStateDefinition(StateDefinition state) {
        this.visitor.leaveStateDefinition(state);
    }

    @Override
    public void visitObjectContract(ObjectContract oc) {
        this.visitor.visitObjectContract(oc);
        this.visitTypeReference(oc.implementsType(), true, -1);
        this.leaveObjectContract(oc);
    }

    @Override
    public void leaveObjectContract(ObjectContract oc) {
        this.visitor.leaveObjectContract(oc);
    }

    @Override
    public void leaveObjectDefn(ObjectDefn obj) {
        this.visitor.leaveObjectDefn(obj);
    }

    @Override
    public void visitCardDefn(CardDefinition cd) {
        this.visitor.visitCardDefn(cd);
        this.visitStateDefinition(cd.state());
        for (RequiresContract rc : cd.requires) {
            this.visitRequires(rc);
        }
        for (Provides p : cd.services) {
            this.visitProvides(p);
        }
        for (ImplementsContract ic : cd.contracts) {
            this.visitImplements(ic);
        }
        boolean isFirst = true;
        for (Template t : cd.templates) {
            this.visitTemplate(t, isFirst);
            isFirst = false;
        }
        this.leaveCardDefn(cd);
    }

    @Override
    public void visitAgentDefn(AgentDefinition s) {
        this.visitor.visitAgentDefn(s);
        this.visitStateDefinition(s.state());
        for (RequiresContract rc : s.requires) {
            this.visitRequires(rc);
        }
        for (Provides p : s.services) {
            this.visitProvides(p);
        }
        for (ImplementsContract ic : s.contracts) {
            this.visitImplements(ic);
        }
        this.leaveAgentDefn(s);
    }

    @Override
    public void visitAssembly(ApplicationAssembly e) {
        this.visitor.visitAssembly(e);
        if (e.routing() != null) {
            this.visitApplicationRouting(e.routing());
        }
        this.leaveAssembly(e);
    }

    @Override
    public void leaveAssembly(ApplicationAssembly e) {
        this.visitor.leaveAssembly(e);
    }

    @Override
    public void visitApplicationRouting(ApplicationRouting e) {
        this.visitor.visitApplicationRouting(e);
        this.visitRoutingCommon(e);
        this.leaveApplicationRouting(e);
    }

    @Override
    public void leaveApplicationRouting(ApplicationRouting e) {
        this.visitor.leaveApplicationRouting(e);
    }

    @Override
    public void visitSubRouting(SubRouting r) {
        this.visitor.visitSubRouting(r);
        this.visitRoutingCommon(r);
        this.leaveSubRouting(r);
    }

    @Override
    public void leaveSubRouting(SubRouting r) {
        this.visitor.leaveSubRouting(r);
    }

    private void visitRoutingCommon(SubRouting r) {
        for (ApplicationRouting.CardBinding cb : r.assignments) {
            this.visitCardAssignment(cb);
        }
        this.visitActions(r.enter);
        this.visitActions(r.at);
        this.visitActions(r.exit);
        for (SubRouting sr : r.routes) {
            this.visitSubRouting(sr);
        }
    }

    @Override
    public void visitActions(RoutingActions actions) {
        if (actions == null) {
            return;
        }
        this.visitor.visitActions(actions);
        if (actions.actions != null) {
            for (RoutingAction a : actions.actions) {
                this.visitRoutingAction(a);
            }
        }
        this.leaveActions(actions);
    }

    @Override
    public void visitRoutingAction(RoutingAction a) {
        this.visitor.visitRoutingAction(a);
        this.visitTypeReference(a.contract, false, -1);
        this.visitExpr(a.card, 0);
        int pos = 0;
        for (Expr e : a.exprs) {
            this.visitRoutingExpr(a, pos++, e);
        }
        this.leaveRoutingAction(a);
    }

    @Override
    public void visitRoutingExpr(RoutingAction a, int pos, Expr e) {
        this.visitor.visitRoutingExpr(a, pos, e);
        this.visitExpr(e, 0);
        this.leaveRoutingExpr(a, pos, e);
    }

    @Override
    public void leaveRoutingExpr(RoutingAction a, int pos, Expr e) {
        this.visitor.leaveRoutingExpr(a, pos, e);
    }

    @Override
    public void leaveRoutingAction(RoutingAction a) {
        this.visitor.leaveRoutingAction(a);
    }

    @Override
    public void leaveActions(RoutingActions actions) {
        this.visitor.leaveActions(actions);
    }

    @Override
    public void visitCardAssignment(ApplicationRouting.CardBinding card) {
        this.visitor.visitCardAssignment(card);
        this.visitTypeReference(card.cardType, false, 0);
        this.leaveCardAssignment(card);
    }

    @Override
    public void leaveCardAssignment(ApplicationRouting.CardBinding card) {
        this.visitor.leaveCardAssignment(card);
    }

    @Override
    public void visitServiceDefn(ServiceDefinition s) {
        this.visitor.visitServiceDefn(s);
        for (RequiresContract rc : s.requires) {
            this.visitRequires(rc);
        }
        for (Provides p : s.provides) {
            this.visitProvides(p);
        }
        this.leaveServiceDefn(s);
    }

    @Override
    public void visitProvides(Provides p) {
        this.visitor.visitProvides(p);
        this.visitTypeReference(p.implementsType(), true, -1);
        if (this.wantImplementedMethods) {
            for (ObjectMethod om : p.implementationMethods) {
                this.visitObjectMethod(om);
            }
        }
        this.leaveProvides(p);
    }

    @Override
    public void leaveProvides(Provides p) {
        this.visitor.leaveProvides(p);
    }

    @Override
    public void visitRequires(RequiresContract rc) {
        this.visitor.visitRequires(rc);
        this.visitTypeReference(rc.implementsType(), true, -1);
    }

    @Override
    public void visitImplements(ImplementsContract ic) {
        this.visitor.visitImplements(ic);
        this.visitTypeReference(ic.implementsType(), true, -1);
        if (this.wantImplementedMethods) {
            for (ObjectMethod om : ic.implementationMethods) {
                this.visitObjectMethod(om);
            }
        }
        this.leaveImplements(ic);
    }

    @Override
    public void leaveImplements(ImplementsContract ic) {
        this.visitor.leaveImplements(ic);
    }

    @Override
    public void visitHandlerImplements(HandlerImplements hi) {
        this.visitor.visitHandlerImplements(hi);
        this.visitTypeReference(hi.implementsType(), true, -1);
        this.traverseHandlerLambdas(hi);
        if (this.wantImplementedMethods) {
            for (ObjectMethod om : hi.implementationMethods) {
                this.visitObjectMethod(om);
            }
        }
        this.leaveHandlerImplements(hi);
    }

    @Override
    public void leaveHandlerImplements(HandlerImplements hi) {
        this.visitor.leaveHandlerImplements(hi);
    }

    @Override
    public void visitTemplate(Template t, boolean isFirst) {
        this.visitor.visitTemplate(t, isFirst);
        if (t.nestingChain() != null) {
            for (TypeReference ty : t.nestingChain().types()) {
                this.visitTypeReference(ty, true, -1);
            }
        }
        this.afterTemplateChainTypes(t);
        NestingChain chain = t.nestingChain();
        if (chain != null) {
            for (TypeReference ty : chain.types()) {
                this.visitTypeReference(ty, true, -1);
            }
        }
        for (TemplateBinding b : t.bindings()) {
            this.visitTemplateBinding(b);
        }
        for (TemplateStylingOption tso : t.stylings()) {
            this.visitTemplateStyling(tso);
        }
        this.leaveTemplate(t);
    }

    @Override
    public void afterTemplateChainTypes(Template t) {
        this.visitor.afterTemplateChainTypes(t);
    }

    @Override
    public void leaveTemplate(Template t) {
        this.visitor.leaveTemplate(t);
    }

    @Override
    public void visitTemplateBinding(TemplateBinding b) {
        this.currFnHasState = true;
        this.visitor.visitTemplateBinding(b);
        for (TemplateBindingOption c : b.conditional()) {
            this.visitTemplateBindingOption(c);
        }
        if (b.defaultBinding != null) {
            this.visitTemplateBindingOption(b.defaultBinding);
        }
        this.visitTemplateCustomization(b);
        this.leaveTemplateBinding(b);
    }

    @Override
    public void visitTemplateBindingOption(TemplateBindingOption option) {
        this.visitor.visitTemplateBindingOption(option);
        if (option.cond != null) {
            this.visitTemplateBindingCondition(option.cond);
            this.visitExpr(option.cond, 0);
        }
        this.visitTemplateBindingExpr(option.expr);
        this.visitExpr(option.expr, 0);
        this.visitTemplateCustomization(option);
        this.leaveTemplateBindingOption(option);
    }

    @Override
    public void visitTemplateBindingExpr(Expr expr) {
        this.visitor.visitTemplateBindingExpr(expr);
    }

    @Override
    public void visitTemplateBindingCondition(Expr cond) {
        this.visitor.visitTemplateBindingCondition(cond);
    }

    @Override
    public void leaveTemplateBindingOption(TemplateBindingOption option) {
        this.visitor.leaveTemplateBindingOption(option);
    }

    @Override
    public void leaveTemplateBinding(TemplateBinding b) {
        this.visitor.leaveTemplateBinding(b);
    }

    @Override
    public void visitTemplateCustomization(TemplateCustomization tc) {
        this.visitor.visitTemplateCustomization(tc);
        for (TemplateStylingOption tso : tc.conditionalStylings) {
            this.visitTemplateStyling(tso);
        }
        for (TemplateEvent te : tc.events) {
            this.visitTemplateEvent(te);
        }
        this.leaveTemplateCustomization(tc);
    }

    @Override
    public void leaveTemplateCustomization(TemplateCustomization tc) {
        this.visitor.leaveTemplateCustomization(tc);
    }

    @Override
    public void visitTemplateStyling(TemplateStylingOption tso) {
        this.visitor.visitTemplateStyling(tso);
        if (tso.cond != null) {
            this.visitTemplateStyleCond(tso.cond);
            this.visitExpr(tso.cond, 0);
        }
        for (Expr e : tso.styles) {
            if (e instanceof StringLiteral) continue;
            this.visitTemplateStyleExpr(e);
        }
        if (tso.orelse != null) {
            this.visitTemplateStylesElse(tso);
            for (Expr e : tso.orelse) {
                if (e instanceof StringLiteral) continue;
                this.visitTemplateStyleExpr(e);
            }
        }
        for (TemplateStylingOption tsoi : tso.conditionalStylings) {
            this.visitTemplateStyling(tsoi);
        }
        for (TemplateEvent te : tso.events) {
            this.visitTemplateEvent(te);
        }
        this.leaveTemplateStyling(tso);
    }

    @Override
    public void visitTemplateStylesElse(TemplateStylingOption tso) {
        this.visitor.visitTemplateStylesElse(tso);
    }

    @Override
    public void visitTemplateStyleCond(Expr cond) {
        this.visitor.visitTemplateStyleCond(cond);
    }

    @Override
    public void visitTemplateStyleExpr(Expr e) {
        this.visitor.visitTemplateStyleExpr(e);
        this.visitExpr(e, 0);
    }

    @Override
    public void leaveTemplateStyling(TemplateStylingOption tso) {
        this.visitor.leaveTemplateStyling(tso);
    }

    @Override
    public void visitTemplateEvent(TemplateEvent te) {
        this.visitor.visitTemplateEvent(te);
    }

    @Override
    public void leaveCardDefn(CardDefinition s) {
        this.visitor.leaveCardDefn(s);
    }

    @Override
    public void leaveAgentDefn(AgentDefinition s) {
        this.visitor.leaveAgentDefn(s);
    }

    @Override
    public void leaveServiceDefn(ServiceDefinition s) {
        this.visitor.leaveServiceDefn(s);
    }

    @Override
    public void visitObjectAccessor(ObjectAccessor oa) {
        this.currFnHasState = true;
        this.visitor.visitObjectAccessor(oa);
        this.visitFunction(oa.function());
        this.leaveObjectAccessor(oa);
    }

    @Override
    public void leaveObjectAccessor(ObjectAccessor oa) {
        this.visitor.leaveObjectAccessor(oa);
    }

    @Override
    public void visitObjectCtor(ObjectCtor oc) {
        if (!oc.generate) {
            return;
        }
        this.currFnHasState = true;
        this.visitor.visitObjectCtor(oc);
        this.visitStateDefinition(oc.getObject().state());
        this.traverseFnOrMethod(oc);
        this.leaveObjectCtor(oc);
    }

    @Override
    public void leaveObjectCtor(ObjectCtor oc) {
        this.visitor.leaveObjectCtor(oc);
    }

    @Override
    public void visitFunctionGroup(FunctionGroup grp) {
        if (grp.size() == 1 && !grp.functions().iterator().next().generate()) {
            return;
        }
        tcLogger.info("Checking group " + grp.functions());
        this.visitor.visitFunctionGroup(grp);
        for (LogicHolder sd : grp.functions()) {
            ObjectMethod meth;
            tcLogger.info("  processing patterns for " + sd.name().uniqueName());
            if (sd instanceof FunctionDefinition) {
                this.visitor.visitFunction((FunctionDefinition)sd);
            } else if (sd instanceof ObjectCtor) {
                this.visitor.visitObjectCtor((ObjectCtor)sd);
            } else if (sd instanceof ObjectMethod) {
                meth = (ObjectMethod)sd;
                this.visitor.visitObjectMethod(meth);
                if (meth.args().isEmpty() && !meth.hasMessages()) {
                    this.visitor.leaveObjectMethod(meth);
                    continue;
                }
            } else if (sd instanceof StandaloneMethod) {
                this.visitor.visitStandaloneMethod((StandaloneMethod)sd);
                this.visitor.visitObjectMethod(((StandaloneMethod)sd).om);
            } else {
                if (sd instanceof TupleAssignment || sd instanceof TupleMember) continue;
                throw new NotImplementedException(sd.getClass().getName());
            }
            this.visitPatternsInTreeOrder(sd);
            if (sd instanceof FunctionDefinition) {
                this.visitor.leaveFunction((FunctionDefinition)sd);
                continue;
            }
            if (sd instanceof ObjectCtor) {
                this.visitor.leaveObjectCtor((ObjectCtor)sd);
                continue;
            }
            if (sd instanceof ObjectMethod) {
                meth = (ObjectMethod)sd;
                if (this.wantEventSources && meth.isEvent()) {
                    for (Template e : meth.eventSourceExprs()) {
                        this.visitEventSource(e);
                    }
                }
                if ((!meth.args().isEmpty() || meth.hasMessages()) && meth.hasImplements() && meth.getImplements() instanceof HandlerImplements) {
                    this.traverseHandlerLambdas((HandlerImplements)meth.getImplements());
                }
                this.visitor.leaveObjectMethod(meth);
                continue;
            }
            if (!(sd instanceof StandaloneMethod)) continue;
            this.visitor.leaveObjectMethod(((StandaloneMethod)sd).om);
            this.visitor.leaveStandaloneMethod((StandaloneMethod)sd);
        }
        for (LogicHolder sd : grp.functions()) {
            tcLogger.info("  processing logic for " + sd.name().uniqueName());
            if (sd instanceof FunctionDefinition) {
                this.visitFunction((FunctionDefinition)sd);
                continue;
            }
            if (sd instanceof StandaloneMethod) {
                this.visitStandaloneMethod((StandaloneMethod)sd);
                continue;
            }
            if (sd instanceof ObjectMethod) {
                this.visitObjectMethod((ObjectMethod)sd);
                continue;
            }
            if (sd instanceof ObjectCtor) {
                this.visitObjectCtor((ObjectCtor)sd);
                continue;
            }
            if (sd instanceof TupleAssignment) {
                this.visitTuple((TupleAssignment)sd);
                continue;
            }
            if (sd instanceof TupleMember) continue;
            throw new NotImplementedException("visit " + sd.getClass());
        }
        this.leaveFunctionGroup(grp);
    }

    @Override
    public void visitStandaloneMethod(StandaloneMethod meth) {
        this.currFnHasState = meth.hasState();
        this.rememberCaller(meth);
        this.visitor.visitStandaloneMethod(meth);
        this.visitObjectMethod(meth.om);
        this.leaveStandaloneMethod(meth);
        this.rememberCaller(null);
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        if (!meth.generate) {
            return;
        }
        this.currFnHasState = meth.hasState();
        this.visitor.visitObjectMethod(meth);
        if (this.functionOrder == null && meth.hasImplements() && meth.getImplements() instanceof HandlerImplements) {
            this.traverseHandlerLambdas((HandlerImplements)meth.getImplements());
        }
        this.traverseFnOrMethod(meth);
        this.leaveObjectMethod(meth);
    }

    @Override
    public void visitEventSource(Template t) {
        this.visitor.visitEventSource(t);
    }

    private void traverseHandlerLambdas(HandlerImplements hi) {
        for (HandlerLambda i : hi.boundVars) {
            this.visitHandlerLambda(i);
        }
    }

    @Override
    public void visitHandlerLambda(HandlerLambda i) {
        this.visitor.visitHandlerLambda(i);
        if (i.patt instanceof TypedPattern) {
            this.visitTypeReference(((TypedPattern)i.patt).type, true, -1);
        }
    }

    @Override
    public void leaveObjectMethod(ObjectMethod meth) {
        this.visitor.leaveObjectMethod(meth);
    }

    @Override
    public void leaveStandaloneMethod(StandaloneMethod meth) {
        this.visitor.leaveStandaloneMethod(meth);
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        if (fn.intros().isEmpty()) {
            return;
        }
        for (FunctionIntro i : fn.intros()) {
            if (!i.broken()) continue;
            return;
        }
        this.currFnHasState = fn.hasState();
        this.rememberCaller(fn);
        this.visitor.visitFunction(fn);
        this.traverseFnOrMethod(fn);
        this.leaveFunction(fn);
        this.rememberCaller(null);
    }

    @Override
    public void visitTuple(TupleAssignment e) {
        this.currFnHasState = e.hasState();
        this.visitor.visitTuple(e);
        this.visitExpr(e.expr, 0);
        this.tupleExprComplete(e);
        for (TupleMember mbr : e.members) {
            this.visitTupleMember(mbr);
        }
        this.leaveTuple(e);
    }

    @Override
    public void tupleExprComplete(TupleAssignment e) {
        this.visitor.tupleExprComplete(e);
    }

    @Override
    public void leaveTuple(TupleAssignment e) {
        this.visitor.leaveTuple(e);
    }

    @Override
    public void visitTupleMember(TupleMember sd) {
        this.visitor.visitTupleMember(sd);
        this.leaveTupleMember(sd);
    }

    @Override
    public void leaveTupleMember(TupleMember sd) {
        this.visitor.leaveTupleMember(sd);
    }

    private void traverseFnOrMethod(LogicHolder sd) {
        if (this.wantHSI) {
            this.visitHSI(sd);
        } else {
            this.visitLogic(sd);
        }
    }

    public void visitHSI(LogicHolder sd) {
        List<Slot> slots = sd.slots();
        ((HSIVisitor)this.visitor).hsiArgs(slots);
        hsiLogger.info("traversing HSI for " + sd.name().uniqueName());
        this.visitHSI(new VarMapping(), "", slots, sd.hsiCases(), null, new BackupPlan(), new DontConsiderAgain());
        hsiLogger.info("finished HSI for " + sd.name().uniqueName());
    }

    public void visitLogic(LogicHolder fn) {
        if (this.wantHSI) {
            throw new NotImplementedException("We should not call visitLogic from visitHSI");
        }
        if (fn instanceof FunctionDefinition) {
            for (FunctionIntro i : ((FunctionDefinition)fn).intros()) {
                if (this.functionOrder != null) {
                    patternsLogger.debug("processing intro " + i);
                }
                this.visitFunctionIntro(i);
            }
        } else if (fn instanceof ObjectActionHandler) {
            if (this.functionOrder == null) {
                this.visitPatterns((PatternsHolder)((Object)fn));
            }
            ObjectActionHandler oah = (ObjectActionHandler)fn;
            if (!oah.guards.isEmpty()) {
                this.visitObjectGuards(oah.guards);
            } else {
                this.visitObjectsMessages(oah.messages());
            }
        } else {
            throw new NotImplementedException();
        }
    }

    private void visitObjectGuards(List<GuardedMessages> guards) {
        for (GuardedMessages gm : guards) {
            this.visitGuardedMessage(gm);
        }
    }

    @Override
    public void visitGuardedMessage(GuardedMessages gm) {
        this.visitor.visitGuardedMessage(gm);
        this.visitExpr(gm.guard, 0);
        this.visitObjectsMessages(gm.messages());
        this.leaveGuardedMessage(gm);
    }

    @Override
    public void leaveGuardedMessage(GuardedMessages gm) {
        this.visitor.leaveGuardedMessage(gm);
    }

    private void visitObjectsMessages(List<ActionMessage> messages) {
        for (ActionMessage msg : messages) {
            this.visitMessage(msg);
        }
    }

    private void visitPatternsInTreeOrder(LogicHolder fn) {
        patternsLogger.info("visiting patterns for " + fn.name().uniqueName());
        TreeOrderVisitor tov = (TreeOrderVisitor)this.visitor;
        HSITree hsiTree = fn.hsiTree();
        for (int i = 0; i < hsiTree.width(); ++i) {
            HSIOptions tree = hsiTree.get(i);
            patternsLogger.info("  visiting pattern " + i + " with " + tree.introNames());
            ArgSlot as = new ArgSlot(i, tree);
            tov.argSlot(as);
            this.visitPatternTree("    " + i, tree);
            tov.endArg(as);
        }
        tov.patternsDone(fn);
        patternsLogger.info("finished patterns for " + fn.name().uniqueName());
    }

    private void visitPatternTree(String indent, HSIOptions hsiOptions) {
        TreeOrderVisitor tov = (TreeOrderVisitor)this.visitor;
        for (StructDefn structDefn : hsiOptions.ctors()) {
            HSICtorTree cm = (HSICtorTree)hsiOptions.getCM(structDefn);
            patternsLogger.info(indent + ": visiting ctor " + structDefn.signature() + " with intros " + cm.introNames());
            tov.matchConstructor(structDefn);
            for (int i = 0; i < cm.width(); ++i) {
                String fld = cm.getField(i);
                StructField tf = structDefn.findField(fld);
                tov.matchField(tf);
                this.visitPatternTree("  " + indent + "." + structDefn.signature() + "." + cm.slot(i), cm.get(i));
                tov.endField(tf);
            }
            tov.endConstructor(structDefn);
        }
        for (NamedType namedType : hsiOptions.types()) {
            patternsLogger.info(indent + ": visiting type " + namedType.signature() + " with intros " + this.introNames(hsiOptions.getIntrosForType(namedType)));
            for (HSIOptions.IntroTypeVar tv : hsiOptions.typedVars(namedType)) {
                if (tv.tp != null) {
                    tov.matchType(tv.tp.type.namedDefn(), tv.tp.var, tv.intro);
                    continue;
                }
                tov.matchType(namedType, null, tv.intro);
            }
        }
        for (HSIOptions.IntroVarName introVarName : hsiOptions.vars()) {
            String iname = "none";
            if (introVarName.intro != null) {
                iname = introVarName.intro.name().uniqueName();
            }
            patternsLogger.info(indent + ": visiting var " + introVarName.var.uniqueName() + " with intro " + iname);
            tov.varInIntro(introVarName.var, introVarName.vp, introVarName.intro);
        }
    }

    private List<String> introNames(List<FunctionIntro> intros) {
        ArrayList<String> ret = new ArrayList<String>();
        for (FunctionIntro i : intros) {
            if (i == null) {
                ret.add("null");
                continue;
            }
            ret.add(i.name().uniqueName());
        }
        return ret;
    }

    public void rememberCaller(LogicHolder fn) {
        this.currentFunction = fn;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitHSI(VarMapping vars, String indent, List<Slot> slots, HSICases intros, List<FunctionIntro> moreGeneral, BackupPlan planB, DontConsiderAgain notAgain) {
        indent = (String)indent + "  ";
        HSIVisitor hsi = (HSIVisitor)this.visitor;
        if (slots.isEmpty()) {
            if (intros.noRemainingCases()) {
                hsiLogger.info((String)indent + "no slots, no cases; moreGeneral = " + moreGeneral + "; backup = " + planB);
                if (moreGeneral != null && !moreGeneral.isEmpty()) {
                    this.visitHSI(vars, (String)indent + "  ", slots, new FunctionHSICases(moreGeneral), null, planB, notAgain);
                    return;
                }
                if (!planB.hasHope()) {
                    hsi.errorNoCase();
                    return;
                }
                planB.backup(this, notAgain);
                return;
            }
            if (intros.singleton()) {
                hsiLogger.info((String)indent + "no slots, one case ... " + intros.onlyIntro());
                this.inline(vars, hsi, intros.onlyIntro());
                return;
            }
            hsiLogger.error("multiple cases remain in HSI processing:");
            Iterator<String> iterator = intros.introNames().iterator();
            while (iterator.hasNext()) {
                String i = iterator.next();
                hsiLogger.error("  " + i);
            }
            throw new HaventConsideredThisException("We should either have 0 or 1 remaining cases at this point, but there might be ways to go wrong");
        }
        Slot s = Traverser.selectSlot(slots);
        ArrayList<Slot> remaining = new ArrayList<Slot>(slots);
        remaining.remove(s);
        hsiLogger.info((String)indent + "selected slot " + s + " remaining = " + remaining + " intros = " + intros);
        HSIOptions opts = s.getOptions();
        VarMapping updatedVars = vars.remember(s, opts, intros);
        if (moreGeneral != null) {
            updatedVars = updatedVars.remember(s, opts, new FunctionHSICases(moreGeneral));
        }
        hsiLogger.info((String)indent + "remembered vars " + updatedVars);
        boolean wantSwitch = opts.hasSwitches(intros);
        DontConsiderAgain forDef = notAgain;
        if (wantSwitch) {
            boolean needSwitch = true;
            for (StructDefn c : opts.ctors()) {
                DontConsiderAgain dca = forDef.considered(s, c);
                if (dca == null) continue;
                forDef = dca;
                HSICtorTree cm = (HSICtorTree)opts.getCM(c);
                HSICases retainedIntros = intros.retain(cm.intros());
                if (retainedIntros.noRemainingCases()) {
                    hsiLogger.info((String)indent + "slot " + s + ": ignoring ctor " + c.name().uniqueName() + " with no matchign intros");
                    continue;
                }
                hsiLogger.info((String)indent + "slot " + s + ": considering ctor " + c.name().uniqueName() + " intros = " + retainedIntros);
                if (needSwitch) {
                    hsi.switchOn(s);
                    needSwitch = false;
                }
                hsi.withConstructor(c.name);
                BackupPlan backupPlan = new BackupPlan(updatedVars, (String)indent, remaining);
                for (NamedType ty : opts.unionsIncluding(c)) {
                    backupPlan.allows(opts.getIntrosForType(ty));
                }
                backupPlan.allows(opts.getDefaultIntros(intros));
                List<FunctionIntro> bi = null;
                bi = opts.types().contains(c) ? opts.getIntrosForType(c) : s.lessSpecific();
                ArrayList<Slot> extended = new ArrayList<Slot>(remaining);
                for (int i = 0; i < cm.width(); ++i) {
                    String fld = cm.getField(i);
                    HSIOptions oi = cm.get(i);
                    CMSlot fieldSlot = new CMSlot(s.id() + "_" + fld, oi, bi);
                    hsi.constructorField(s, fld, fieldSlot);
                    extended.add(fieldSlot);
                }
                this.visitHSI(updatedVars, (String)indent, extended, retainedIntros, bi, backupPlan, forDef);
            }
            HashSet<NamedType> still = new HashSet<NamedType>(opts.types());
            TreeSet<NamedType> ordered = new TreeSet<NamedType>(this.unionLastOrder);
            ordered.addAll(opts.types());
            for (NamedType ty : ordered) {
                Set<String> strings;
                HSICases forConst;
                Set<Integer> numbers;
                still.remove(ty);
                DontConsiderAgain dca = forDef.considered(s, ty);
                if (dca == null) continue;
                forDef = dca;
                HSICases intersect = intros.retain(opts.getIntrosForType(ty));
                if (intersect.noRemainingCases()) {
                    hsiLogger.info((String)indent + "slot " + s + ": ignoring type " + ty.name().uniqueName() + " with no matchign intros");
                    continue;
                }
                hsiLogger.info((String)indent + "slot " + s + ": considering type " + ty.name().uniqueName() + " intros = " + intersect);
                NameOfThing name = ty.name();
                if (needSwitch) {
                    hsi.switchOn(s);
                    needSwitch = false;
                }
                hsi.withConstructor(name);
                BackupPlan backupPlan = new BackupPlan(updatedVars, (String)indent, remaining);
                for (NamedType t2 : still) {
                    backupPlan.allows(opts.getIntrosForType(t2));
                }
                backupPlan.allows(opts.getDefaultIntros(intros));
                if ("Number".equals(name.uniqueName()) && !(numbers = opts.numericConstants(intersect)).isEmpty()) {
                    Iterator<Object> iterator = numbers.iterator();
                    while (iterator.hasNext()) {
                        int k = iterator.next();
                        hsi.matchNumber(k);
                        forConst = intersect.retain(opts.getIntrosForNumber(k));
                        intersect.remove(forConst);
                        hsiLogger.info((String)indent + "slot " + s + ": considering number " + k + " intros = " + forConst);
                        this.visitHSI(updatedVars, (String)indent, remaining, forConst, moreGeneral, backupPlan, forDef);
                        intersect.remove(forConst);
                    }
                    hsi.matchDefault();
                }
                if ("String".equals(name.uniqueName()) && !(strings = opts.stringConstants(intersect)).isEmpty()) {
                    for (String k : strings) {
                        hsi.matchString(k);
                        forConst = intersect.retain(opts.getIntrosForString(k));
                        intersect.remove(forConst);
                        hsiLogger.info((String)indent + "slot " + s + ": considering string " + k + " intros = " + forConst);
                        this.visitHSI(updatedVars, (String)indent, remaining, forConst, moreGeneral, backupPlan, forDef);
                        intersect.remove(forConst);
                    }
                    hsi.matchDefault();
                }
                this.visitHSI(updatedVars, (String)indent, remaining, intersect, moreGeneral, backupPlan, forDef);
            }
            if (needSwitch) {
                wantSwitch = false;
            }
        }
        HSICases intersect = intros.retain(opts.getDefaultIntros(intros));
        if (wantSwitch) {
            hsi.defaultCase();
        }
        hsiLogger.info((String)indent + "slot " + s + ": for the default case, intros = " + intersect);
        this.visitHSI(updatedVars, (String)indent, remaining, intersect, moreGeneral, planB, forDef);
        if (!wantSwitch) return;
        hsi.endSwitch();
    }

    private void inline(VarMapping vars, HSIVisitor hsi, FunctionIntro intro) {
        vars.bindFor(hsi, intro);
        this.handleInline(intro);
    }

    public static Slot selectSlot(List<Slot> slots) {
        if (slots.size() == 1) {
            return slots.get(0);
        }
        int which = 0;
        int score = -1;
        int i = 0;
        for (Slot s : slots) {
            int ms = s.score();
            if (ms > score) {
                which = i;
                score = ms;
            }
            ++i;
        }
        return slots.get(which);
    }

    private void handleInline(FunctionIntro i) {
        if (i == null) {
            return;
        }
        this.startInline(i);
        this.visitFunctionCases(i);
        this.endInline(i);
    }

    @Override
    public void visitFunctionIntro(FunctionIntro i) {
        this.visitor.visitFunctionIntro(i);
        if (this.functionOrder == null) {
            this.visitPatterns(i);
        }
        this.visitFunctionCases(i);
        this.leaveFunctionIntro(i);
    }

    private void visitFunctionCases(FunctionIntro i) {
        for (FunctionCaseDefn c : i.cases()) {
            this.visitCase(c);
        }
    }

    public void visitPatterns(PatternsHolder fn) {
        VarPattern h;
        if (this.wantNestedPatterns) {
            Object nv = null;
            if (this.currentFunction != null) {
                NamedType sh = (NamedType)((Object)this.currentFunction.state());
                if (!this.currentFunction.isObjAccessor() && !(this.currentFunction instanceof ObjectCtor) && sh != null) {
                    TypeReference tr = new TypeReference(fn.location(), sh.name().baseName(), new TypeReference[0]);
                    tr.bind(sh);
                    this.visitPattern(new TypedPattern(fn.location(), tr, new VarName(fn.location(), fn.name(), "_this")), true);
                }
                nv = this.currentFunction.nestedVars();
            } else if (fn instanceof LogicHolder) {
                nv = ((LogicHolder)((Object)fn)).nestedVars();
            }
            if (nv != null) {
                for (Pattern p : nv.patterns()) {
                    this.visitPattern(p, true);
                }
            }
        }
        for (Pattern p : fn.args()) {
            this.visitPattern(p, false);
        }
        if (fn instanceof HandlerHolder && (h = ((HandlerHolder)((Object)fn)).handler()) != null) {
            this.visitPattern(h, false);
        }
    }

    @Override
    public void leaveFunctionIntro(FunctionIntro fi) {
        this.visitor.leaveFunctionIntro(fi);
    }

    @Override
    public void leaveFunction(FunctionDefinition fn) {
        this.visitor.leaveFunction(fn);
    }

    @Override
    public void visitMessages(Messages messages) {
        this.visitor.visitMessages(messages);
        for (Expr e : messages.exprs) {
            this.visitExpr(e, 0);
        }
        this.leaveMessages(messages);
    }

    @Override
    public void leaveMessages(Messages msgs) {
        this.visitor.leaveMessages(msgs);
    }

    @Override
    public void visitMessage(ActionMessage msg) {
        this.visitor.visitMessage(msg);
        if (msg instanceof AssignMessage) {
            this.visitAssignMessage((AssignMessage)msg);
        } else if (msg instanceof SendMessage) {
            this.visitSendMessage((SendMessage)msg);
        } else {
            throw new NotImplementedException();
        }
        this.leaveMessage(msg);
    }

    @Override
    public void visitAssignMessage(AssignMessage msg) {
        this.visitor.visitAssignMessage(msg);
        this.visitExpr(msg.expr, 0);
        this.visitAssignSlot(msg.slot);
        this.leaveAssignMessage(msg);
    }

    @Override
    public void visitAssignSlot(Expr slot) {
        this.visitor.visitAssignSlot(slot);
        this.visitExpr(slot, 0);
    }

    @Override
    public void leaveAssignMessage(AssignMessage msg) {
        this.visitor.leaveAssignMessage(msg);
    }

    @Override
    public void visitSendMessage(SendMessage msg) {
        this.visitor.visitSendMessage(msg);
        this.visitExpr(msg.expr, 0);
        if (msg.handlerExpr() != null) {
            this.visitSendHandler(msg.handlerExpr());
        }
        if (msg.subscriberName() != null) {
            this.visitSubscriberName(msg.subscriberName());
        }
        this.leaveSendMessage(msg);
    }

    @Override
    public void visitSendHandler(Expr handlerExpr) {
        this.visitor.visitSendHandler(handlerExpr);
        this.visitExpr(handlerExpr, 0);
        this.leaveSendHandler(handlerExpr);
    }

    @Override
    public void leaveSendHandler(Expr handlerExpr) {
        this.visitor.leaveSendHandler(handlerExpr);
    }

    @Override
    public void visitSubscriberName(Expr subscriberName) {
        this.visitor.visitSubscriberName(subscriberName);
        this.visitExpr(subscriberName, 0);
        this.leaveSubscriberName(subscriberName);
    }

    @Override
    public void leaveSubscriberName(Expr handlerName) {
        this.visitor.leaveSubscriberName(handlerName);
    }

    @Override
    public void leaveSendMessage(SendMessage msg) {
        this.visitor.leaveSendMessage(msg);
    }

    @Override
    public void leaveMessage(ActionMessage msg) {
        this.visitor.leaveMessage(msg);
    }

    @Override
    public void leaveFunctionGroup(FunctionGroup grp) {
        this.visitor.leaveFunctionGroup(grp);
    }

    @Override
    public void visitPattern(Pattern p, boolean isNested) {
        this.visitor.visitPattern(p, isNested);
        if (p instanceof VarPattern) {
            this.visitVarPattern((VarPattern)p, isNested);
        } else if (p instanceof TypedPattern) {
            this.visitTypedPattern((TypedPattern)p, isNested);
        } else if (p instanceof ConstructorMatch) {
            this.visitConstructorMatch((ConstructorMatch)p, isNested);
        } else if (p instanceof ConstPattern) {
            this.visitConstPattern((ConstPattern)p, isNested);
        } else {
            throw new NotImplementedException("Pattern not handled: " + p.getClass());
        }
        this.leavePattern(p, isNested);
    }

    @Override
    public void visitVarPattern(VarPattern p, boolean isNested) {
        this.visitor.visitVarPattern(p, isNested);
        this.visitPatternVar(p.location(), p.var);
    }

    @Override
    public void visitTypedPattern(TypedPattern p, boolean isNested) {
        this.visitor.visitTypedPattern(p, isNested);
        this.visitTypeReference(p.type, true, -1);
        this.visitPatternVar(p.var.loc, p.var.var);
    }

    @Override
    public void visitConstructorMatch(ConstructorMatch p, boolean isNested) {
        this.visitor.visitConstructorMatch(p, isNested);
        for (ConstructorMatch.Field f : p.args) {
            this.visitConstructorField(f.field, f.patt, isNested);
        }
        this.leaveConstructorMatch(p);
    }

    @Override
    public void visitConstructorField(String field, Pattern patt, boolean isNested) {
        this.visitor.visitConstructorField(field, patt, isNested);
        this.visitPattern(patt, isNested);
        this.leaveConstructorField(field, patt);
    }

    @Override
    public void leaveConstructorField(String field, Object patt) {
        this.visitor.leaveConstructorField(field, patt);
    }

    @Override
    public void leaveConstructorMatch(ConstructorMatch p) {
        this.visitor.leaveConstructorMatch(p);
    }

    @Override
    public void visitPatternVar(InputPosition varLoc, String var) {
        this.visitor.visitPatternVar(varLoc, var);
    }

    @Override
    public void visitConstPattern(ConstPattern p, boolean isNested) {
        this.visitor.visitConstPattern(p, isNested);
    }

    @Override
    public void leavePattern(Object patt, boolean isNested) {
        this.visitor.leavePattern(patt, isNested);
    }

    @Override
    public void visitCase(FunctionCaseDefn c) {
        this.visitor.visitCase(c);
        if (c.guard != null) {
            this.visitGuard(c);
            this.visitExpr(c.guard, 0);
            this.leaveGuard(c);
        }
        this.visitExpr(c.expr, 0);
        this.visitor.leaveCase(c);
    }

    @Override
    public void visitGuard(FunctionCaseDefn c) {
        this.visitor.visitGuard(c);
    }

    @Override
    public void leaveGuard(FunctionCaseDefn c) {
        this.visitor.leaveGuard(c);
    }

    @Override
    public void leaveCase(FunctionCaseDefn c) {
        this.visitor.leaveCase(c);
    }

    @Override
    public void startInline(FunctionIntro fi) {
        this.visitor.startInline(fi);
    }

    @Override
    public void endInline(FunctionIntro fi) {
        this.visitor.endInline(fi);
    }

    @Override
    public void visitExpr(Expr expr, int nargs) {
        if (expr instanceof ParenExpr) {
            this.visitExpr((Expr)((ParenExpr)expr).expr, nargs);
            return;
        }
        boolean ine = this.isNeedingEnhancement(expr, nargs);
        boolean cme = this.convertedMemberExpr(expr);
        if (!ine && !cme || this.isConverted) {
            this.visitor.visitExpr(expr, nargs);
        }
        if (expr == null) {
            return;
        }
        if (expr instanceof ApplyExpr) {
            this.visitApplyExpr((ApplyExpr)expr);
        } else if (expr instanceof StringLiteral) {
            this.visitStringLiteral((StringLiteral)expr);
        } else if (expr instanceof NumericLiteral) {
            this.visitNumericLiteral((NumericLiteral)expr);
        } else if (expr instanceof TypeReference) {
            this.visitTypeReference((TypeReference)expr, false, nargs);
        } else if (expr instanceof UnresolvedVar) {
            this.visitUnresolvedVar((UnresolvedVar)expr, nargs);
        } else if (expr instanceof AnonymousVar) {
            this.visitAnonymousVar((AnonymousVar)expr);
        } else if (expr instanceof IntroduceVar) {
            this.visitIntroduceVar((IntroduceVar)expr);
        } else if (expr instanceof UnresolvedOperator) {
            this.visitUnresolvedOperator((UnresolvedOperator)expr, nargs);
        } else if (expr instanceof MemberExpr) {
            this.visitMemberExpr((MemberExpr)expr, nargs);
        } else if (expr instanceof Messages) {
            this.visitMessages((Messages)expr);
        } else if (expr instanceof MakeSend) {
            this.visitMakeSend((MakeSend)expr);
        } else if (expr instanceof MakeAcor) {
            this.visitMakeAcor((MakeAcor)expr);
        } else if (expr instanceof CurrentContainer) {
            this.visitCurrentContainer((CurrentContainer)expr, false, false);
        } else if (expr instanceof CheckTypeExpr) {
            this.visitCheckTypeExpr((CheckTypeExpr)expr);
        } else if (expr instanceof TypeExpr) {
            this.visitTypeExpr((TypeExpr)expr);
        } else if (expr instanceof CastExpr) {
            this.visitCastExpr((CastExpr)expr);
        } else {
            throw new NotImplementedException("Not handled: " + expr.getClass());
        }
    }

    @Override
    public void visitCheckTypeExpr(CheckTypeExpr expr) {
        this.visitor.visitCheckTypeExpr(expr);
        this.visitTypeReference(expr.type, false, -1);
        this.visitExpr(expr.expr, 0);
        this.leaveCheckTypeExpr(expr);
    }

    @Override
    public void leaveCheckTypeExpr(CheckTypeExpr expr) {
        this.visitor.leaveCheckTypeExpr(expr);
    }

    @Override
    public void visitTypeExpr(TypeExpr expr) {
        this.visitor.visitTypeExpr(expr);
        this.visitExpr(expr.type, 0);
        this.leaveTypeExpr(expr);
    }

    @Override
    public void leaveTypeExpr(TypeExpr expr) {
        this.visitor.leaveTypeExpr(expr);
    }

    @Override
    public void visitCastExpr(CastExpr expr) {
        this.visitor.visitCastExpr(expr);
        this.visitTypeReference(expr.type, true, -1);
        this.visitExpr(expr.val, 0);
        this.leaveCastExpr(expr);
    }

    @Override
    public void leaveCastExpr(CastExpr expr) {
        this.visitor.leaveCastExpr(expr);
    }

    private boolean isNeedingEnhancement(Expr expr, int nargs) {
        Expr fn;
        if (!this.wantNestedPatterns) {
            return false;
        }
        if (expr instanceof ApplyExpr) {
            fn = (Expr)((ApplyExpr)expr).fn;
        } else if ((expr instanceof UnresolvedVar || expr instanceof TypeReference) && nargs == 0) {
            fn = expr;
        } else {
            return false;
        }
        return this.isFnNeedingNesting(fn) != null || this.containingMe(fn) != null;
    }

    private boolean convertedMemberExpr(Expr expr) {
        return this.wantHSI && expr instanceof MemberExpr;
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        ApplyExpr ae = expr;
        Expr fn = (Expr)expr.fn;
        if (this.wantNestedPatterns && !this.isConverted) {
            NestedVarReader nv;
            NamedType sh = this.containingMe(fn);
            ArrayList<Object> args = new ArrayList<Object>();
            if (!(sh == null || !this.currFnHasState || fn instanceof UnresolvedVar && ((UnresolvedVar)fn).defn() instanceof ObjectCtor)) {
                args.add(new CurrentContainer(fn.location(), sh));
            }
            if ((nv = this.isFnNeedingNesting(fn)) != null) {
                for (UnresolvedVar uv : nv.vars()) {
                    args.add(uv);
                }
            }
            if (!args.isEmpty()) {
                args.addAll(expr.args);
                ae = new ApplyExpr(expr.location, (Object)fn, args);
            }
            if (this.isNeedingEnhancement(expr, 0)) {
                this.visitor.visitExpr(ae, 0);
            }
        }
        this.visitor.visitApplyExpr(ae);
        this.visitExpr(fn, ae.args.size());
        for (Object x : ae.args) {
            this.visitExpr((Expr)x, 0);
        }
        this.leaveApplyExpr(ae);
    }

    private NestedVarReader isFnNeedingNesting(Expr fn) {
        Object defn;
        if (fn instanceof UnresolvedVar) {
            defn = ((UnresolvedVar)fn).defn();
        } else if (fn instanceof TypeReference) {
            defn = ((TypeReference)fn).namedDefn();
        } else {
            return null;
        }
        if (defn instanceof LogicHolder) {
            return ((LogicHolder)defn).nestedVars();
        }
        if (defn instanceof HandlerImplements) {
            return ((HandlerImplements)defn).nestedVars();
        }
        return null;
    }

    private NamedType containingMe(Expr fn) {
        Object defn;
        if (fn instanceof UnresolvedVar) {
            defn = ((UnresolvedVar)fn).defn();
        } else if (fn instanceof TypeReference) {
            defn = ((TypeReference)fn).namedDefn();
        } else {
            return null;
        }
        if (defn instanceof LogicHolder) {
            return this.containingMe(((LogicHolder)defn).name());
        }
        return null;
    }

    private NamedType containingMe(FunctionName n) {
        NameOfThing o = n.container();
        if (o == null || o instanceof PackageName) {
            return null;
        }
        if (o instanceof FunctionName) {
            return this.containingMe((FunctionName)o);
        }
        if (o instanceof CardName || o instanceof ObjectName) {
            return (NamedType)this.repository.get(o.uniqueName());
        }
        if (o instanceof CSName || o instanceof HandlerName) {
            Object ret = this.repository.get(o.uniqueName());
            if (ret == null) {
                throw new CantHappenException("there was no type for " + o.uniqueName());
            }
            if (ret instanceof NamedType) {
                return (NamedType)ret;
            }
            throw new NotImplementedException(ret + " for " + o + " was not a namedType");
        }
        throw new NotImplementedException("o is " + o.getClass() + ": " + o.uniqueName());
    }

    @Override
    public void leaveApplyExpr(ApplyExpr expr) {
        this.visitor.leaveApplyExpr(expr);
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (this.wantHSI) {
            if (!expr.isConverted()) {
                throw new NotImplementedException("You need to convert this expression: " + expr);
            }
            this.visitConvertedExpr(expr, nargs);
            return true;
        }
        boolean done = this.visitor.visitMemberExpr(expr, nargs);
        if (!done) {
            this.visitExpr(expr.from, 0);
            if (this.visitMemberFields) {
                this.visitExpr(expr.fld, 0);
            }
        }
        this.leaveMemberExpr(expr, done);
        return done;
    }

    @Override
    public void visitConvertedExpr(MemberExpr expr, int nargs) {
        this.visitor.visitConvertedExpr(expr, nargs);
        this.isConverted = true;
        this.visitExpr(expr.converted(), nargs);
        this.leaveConvertedExpr(expr);
    }

    @Override
    public void leaveConvertedExpr(MemberExpr expr) {
        this.isConverted = false;
        this.visitor.leaveConvertedExpr(expr);
    }

    @Override
    public void leaveMemberExpr(MemberExpr expr, boolean done) {
        this.visitor.leaveMemberExpr(expr, done);
    }

    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        if (nargs == 0 && this.wantNestedPatterns) {
            NestedVarReader nv;
            NamedType sh = this.containingMe(var);
            ArrayList<Object> args = new ArrayList<Object>();
            CurrentContainer cc = null;
            if (sh != null && this.currFnHasState && !(var.defn() instanceof ObjectCtor)) {
                cc = new CurrentContainer(var.location(), sh);
                args.add(cc);
            }
            if ((nv = this.isFnNeedingNesting(var)) != null && !nv.vars().isEmpty()) {
                args.addAll(nv.vars());
            }
            if (!args.isEmpty()) {
                ApplyExpr ae = new ApplyExpr(var.location, (Object)var, args);
                boolean wouldWantState = ae.fn instanceof UnresolvedVar && (((UnresolvedVar)ae.fn).defn() instanceof FunctionDefinition || ((UnresolvedVar)ae.fn).defn() instanceof StandaloneMethod);
                this.visitor.visitExpr(ae, 0);
                this.visitor.visitApplyExpr(ae);
                this.visitor.visitExpr(var, args.size());
                this.visitor.visitUnresolvedVar(var, args.size());
                for (Object e : args) {
                    this.visitor.visitExpr((Expr)e, 0);
                    if (e instanceof UnresolvedVar) {
                        this.visitor.visitUnresolvedVar((UnresolvedVar)e, 0);
                        continue;
                    }
                    if (e instanceof CurrentContainer) {
                        this.visitor.visitCurrentContainer((CurrentContainer)e, e == cc, wouldWantState);
                        continue;
                    }
                    throw new NotImplementedException();
                }
                this.visitor.leaveApplyExpr(ae);
                return;
            }
        }
        if (this.isNeedingEnhancement(var, nargs)) {
            this.visitor.visitExpr(var, nargs);
        }
        this.visitor.visitUnresolvedVar(var, nargs);
    }

    @Override
    public void visitUnresolvedOperator(UnresolvedOperator operator, int nargs) {
        this.visitor.visitUnresolvedOperator(operator, nargs);
    }

    @Override
    public void visitIntroduceVar(IntroduceVar var) {
        this.visitor.visitIntroduceVar(var);
    }

    @Override
    public void visitAnonymousVar(AnonymousVar var) {
        this.visitor.visitAnonymousVar(var);
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        this.visitor.visitTypeReference(var, expectPolys, exprNargs);
    }

    @Override
    public void visitStringLiteral(StringLiteral expr) {
        this.visitor.visitStringLiteral(expr);
    }

    @Override
    public void visitNumericLiteral(NumericLiteral expr) {
        this.visitor.visitNumericLiteral(expr);
    }

    @Override
    public void visitMakeSend(MakeSend expr) {
        this.visitor.visitMakeSend(expr);
        this.visitExpr(expr.obj, 0);
        if (expr.handler != null) {
            this.visitExpr(expr.handler, 0);
        }
        if (expr.handlerName != null) {
            this.visitExpr(expr.handlerName, 0);
        }
        this.leaveMakeSend(expr);
    }

    @Override
    public void leaveMakeSend(MakeSend expr) {
        this.visitor.leaveMakeSend(expr);
    }

    @Override
    public void visitMakeAcor(MakeAcor expr) {
        this.visitor.visitMakeAcor(expr);
        this.visitExpr(expr.obj, 0);
        this.leaveMakeAcor(expr);
    }

    @Override
    public void leaveMakeAcor(MakeAcor expr) {
        this.visitor.leaveMakeAcor(expr);
    }

    @Override
    public void visitCurrentContainer(CurrentContainer expr, boolean isObjState, boolean wouldWantState) {
        this.visitor.visitCurrentContainer(expr, isObjState, wouldWantState);
    }

    @Override
    public void visitUnitTestPackage(UnitTestPackage e) {
        this.currFnHasState = false;
        this.visitor.visitUnitTestPackage(e);
        for (UnitDataDeclaration udd : e.decls()) {
            this.visitUnitDataDeclaration(udd);
        }
        for (UnitTestCase c : e.tests()) {
            this.visitUnitTest(c);
        }
        this.leaveUnitTestPackage(e);
    }

    @Override
    public void visitUnitTest(UnitTestCase e) {
        this.visitor.visitUnitTest(e);
        for (UnitTestStep s : e.steps) {
            this.visitUnitTestStep(s);
        }
        this.leaveUnitTest(e);
    }

    @Override
    public void leaveUnitTest(TestStepHolder e) {
        this.visitor.leaveUnitTest(e);
    }

    @Override
    public void visitUnitTestStep(UnitTestStep s) {
        this.visitor.visitUnitTestStep(s);
        if (s instanceof UnitTestAssert) {
            this.visitUnitTestAssert((UnitTestAssert)s);
        } else if (s instanceof UnitTestIdentical) {
            this.visitUnitTestIdentical((UnitTestIdentical)s);
        } else if (s instanceof UnitTestClose) {
            this.visitUnitTestClose((UnitTestClose)s);
        } else if (s instanceof UnitTestShove) {
            this.visitUnitTestShove((UnitTestShove)s);
        } else if (s instanceof UnitTestInvoke) {
            this.visitUnitTestInvoke((UnitTestInvoke)s);
        } else if (s instanceof UnitDataDeclaration) {
            this.visitUnitDataDeclaration((UnitDataDeclaration)s);
        } else if (s instanceof UnitTestExpect) {
            this.visitUnitTestExpect((UnitTestExpect)s);
        } else if (s instanceof UnitTestExpectCancel) {
            this.visitUnitTestExpectCancel((UnitTestExpectCancel)s);
        } else if (s instanceof UnitTestSend) {
            this.visitUnitTestSend((UnitTestSend)s);
        } else if (s instanceof UnitTestRender) {
            this.visitUnitTestRender((UnitTestRender)s);
        } else if (s instanceof UnitTestEvent) {
            this.visitUnitTestEvent((UnitTestEvent)s);
        } else if (s instanceof UnitTestInput) {
            this.visitUnitTestInput((UnitTestInput)s);
        } else if (s instanceof UnitTestMatch) {
            this.visitUnitTestMatch((UnitTestMatch)s);
        } else if (s instanceof UnitTestNewDiv) {
            this.visitUnitTestNewDiv((UnitTestNewDiv)s);
        } else if (this.modules != null) {
            TraverserModule m;
            boolean done = false;
            Iterator<TraverserModule> iterator = this.modules.iterator();
            while (iterator.hasNext() && !(done = (m = iterator.next()).visitUnitTestStep(this, this.visitor, s))) {
            }
            if (!done) {
                throw new NotImplementedException("cannot handle " + s.getClass());
            }
        } else {
            throw new NotImplementedException("cannot handle " + s.getClass());
        }
        this.leaveUnitTestStep(s);
    }

    @Override
    public void leaveUnitTestStep(UnitTestStep s) {
        this.visitor.leaveUnitTestStep(s);
    }

    @Override
    public void visitUnitTestNewDiv(UnitTestNewDiv s) {
        this.visitor.visitUnitTestNewDiv(s);
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        this.visitor.visitUnitDataDeclaration(udd);
        this.visitTypeReference(udd.ofType, true, -1);
        if (udd.expr != null) {
            this.visitExpr(udd.expr, 0);
        }
        for (UnitDataDeclaration.Assignment f : udd.fields) {
            this.visitUnitDataField(f);
        }
        this.leaveUnitDataDeclaration(udd);
    }

    @Override
    public void visitUnitDataField(UnitDataDeclaration.Assignment assign) {
        this.visitor.visitUnitDataField(assign);
        this.visitExpr(assign.value, 0);
        this.leaveUnitDataField(assign);
    }

    @Override
    public void leaveUnitDataField(UnitDataDeclaration.Assignment assign) {
        this.visitor.leaveUnitDataField(assign);
    }

    @Override
    public void leaveUnitDataDeclaration(UnitDataDeclaration udd) {
        this.visitor.leaveUnitDataDeclaration(udd);
    }

    @Override
    public void visitUnitTestAssert(UnitTestAssert a) {
        this.visitor.visitUnitTestAssert(a);
        this.visitAssertExpr(true, a.value);
        this.visitAssertExpr(false, a.expr);
        this.postUnitTestAssert(a);
    }

    @Override
    public void visitUnitTestIdentical(UnitTestIdentical a) {
        this.visitor.visitUnitTestIdentical(a);
        this.visitAssertExpr(true, a.value);
        this.visitAssertExpr(false, a.expr);
        this.postUnitTestIdentical(a);
    }

    @Override
    public void visitAssertExpr(boolean isValue, Expr e) {
        this.visitor.visitAssertExpr(isValue, e);
        this.visitExpr(e, 0);
        this.leaveAssertExpr(isValue, e);
    }

    @Override
    public void leaveAssertExpr(boolean isValue, Expr e) {
        this.visitor.leaveAssertExpr(isValue, e);
    }

    @Override
    public void postUnitTestAssert(UnitTestAssert a) {
        this.visitor.postUnitTestAssert(a);
    }

    @Override
    public void postUnitTestIdentical(UnitTestIdentical a) {
        this.visitor.postUnitTestIdentical(a);
    }

    @Override
    public void visitUnitTestClose(UnitTestClose s) {
        this.visitor.visitUnitTestClose(s);
        this.visitExpr(s.card, 0);
        this.leaveUnitTestClose(s);
    }

    @Override
    public void leaveUnitTestClose(UnitTestClose s) {
        this.visitor.leaveUnitTestClose(s);
    }

    @Override
    public void visitUnitTestShove(UnitTestShove s) {
        this.visitor.visitUnitTestShove(s);
        for (UnresolvedVar v : s.slots) {
            this.visitShoveSlot(v);
        }
        this.visitShoveExpr(s.value);
        this.leaveUnitTestShove(s);
    }

    @Override
    public void visitShoveSlot(UnresolvedVar v) {
        this.visitor.visitShoveSlot(v);
    }

    @Override
    public void visitShoveExpr(Expr value) {
        this.visitor.visitShoveExpr(value);
        this.visitExpr(value, 0);
    }

    @Override
    public void leaveUnitTestShove(UnitTestShove s) {
        this.visitor.leaveUnitTestShove(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitUnitTestInvoke(UnitTestInvoke uti) {
        this.visitor.visitUnitTestInvoke(uti);
        if (this.wantHSI) {
            if (!uti.isConverted()) throw new NotImplementedException("You need to convert this UTI");
            this.visitExpr(uti.converted(), 0);
        } else {
            this.visitExpr(uti.expr, 0);
        }
        this.leaveUnitTestInvoke(uti);
    }

    @Override
    public void leaveUnitTestInvoke(UnitTestInvoke uti) {
        this.visitor.leaveUnitTestInvoke(uti);
    }

    @Override
    public void visitUnitTestExpect(UnitTestExpect ute) {
        this.visitor.visitUnitTestExpect(ute);
        this.visitUnresolvedVar(ute.ctr, 0);
        for (Expr e : ute.args) {
            this.visitExpr(e, 0);
        }
        this.expectHandlerNext();
        this.visitExpr(ute.handler, 0);
        this.leaveUnitTestExpect(ute);
    }

    @Override
    public void visitUnitTestExpectCancel(UnitTestExpectCancel utec) {
        this.visitor.visitUnitTestExpectCancel(utec);
        this.visitUnresolvedVar(utec.handlerName, 0);
        this.leaveUnitTestExpectCancel(utec);
    }

    @Override
    public void expectHandlerNext() {
        this.visitor.expectHandlerNext();
    }

    @Override
    public void leaveUnitTestExpect(UnitTestExpect ute) {
        this.visitor.leaveUnitTestExpect(ute);
    }

    @Override
    public void leaveUnitTestExpectCancel(UnitTestExpectCancel utec) {
        this.visitor.leaveUnitTestExpectCancel(utec);
    }

    @Override
    public void visitUnitTestSend(UnitTestSend s) {
        this.visitor.visitUnitTestSend(s);
        this.visitUnresolvedVar(s.card, 0);
        this.visitTypeReference(s.contract, true, -1);
        this.visitSendExpr(s.contract, s.expr, s.handler);
        this.leaveUnitTestSend(s);
    }

    private void visitSendExpr(TypeReference contract, Expr expr, UnresolvedVar handler) {
        if (contract.namedDefn() == null) {
            return;
        }
        if (expr instanceof UnresolvedVar) {
            this.visitor.visitSendMethod(contract.namedDefn(), (UnresolvedVar)expr);
        } else if (expr instanceof ApplyExpr) {
            ApplyExpr ae = (ApplyExpr)expr;
            this.visitSendMethod(contract.namedDefn(), (UnresolvedVar)ae.fn);
            for (Object e : ae.args) {
                this.visitExpr((Expr)e, 0);
            }
        } else {
            throw new CantHappenException("the expr in send is not a var or an apply");
        }
        if (handler != null) {
            this.visitExpr(handler, 0);
        }
    }

    @Override
    public void visitSendMethod(NamedType defn, UnresolvedVar expr) {
        this.visitor.visitSendMethod(defn, expr);
    }

    @Override
    public void leaveUnitTestSend(UnitTestSend s) {
        this.visitor.leaveUnitTestSend(s);
    }

    @Override
    public void visitUnitTestRender(UnitTestRender e) {
        this.visitor.visitUnitTestRender(e);
        this.visitExpr(e.card, 0);
        this.leaveUnitTestRender(e);
    }

    @Override
    public void leaveUnitTestRender(UnitTestRender e) {
        this.visitor.leaveUnitTestRender(e);
    }

    @Override
    public void visitUnitTestEvent(UnitTestEvent e) {
        this.visitor.visitUnitTestEvent(e);
        this.visitExpr(e.card, 0);
        this.visitExpr(e.expr, 0);
        this.leaveUnitTestEvent(e);
    }

    @Override
    public void leaveUnitTestEvent(UnitTestEvent e) {
        this.visitor.leaveUnitTestEvent(e);
    }

    @Override
    public void visitUnitTestInput(UnitTestInput e) {
        this.visitor.visitUnitTestInput(e);
        this.visitExpr(e.card, 0);
        this.visitExpr(e.expr, 0);
        this.leaveUnitTestInput(e);
    }

    @Override
    public void leaveUnitTestInput(UnitTestInput e) {
        this.visitor.leaveUnitTestInput(e);
    }

    @Override
    public void visitUnitTestMatch(UnitTestMatch m) {
        this.visitor.visitUnitTestMatch(m);
        this.visitExpr(m.card, 0);
        this.leaveUnitTestMatch(m);
    }

    @Override
    public void leaveUnitTestMatch(UnitTestMatch m) {
        this.visitor.leaveUnitTestMatch(m);
    }

    @Override
    public void leaveUnitTestPackage(UnitTestPackage e) {
        this.visitor.leaveUnitTestPackage(e);
    }

    @Override
    public void visitSystemTest(SystemTest st) {
        this.visitor.visitSystemTest(st);
        if (st.configure != null) {
            this.visitSystemTestStage(st.configure);
        }
        for (SystemTestStage s : st.stages) {
            this.visitSystemTestStage(s);
        }
        if (st.cleanup != null) {
            this.visitSystemTestStage(st.cleanup);
        }
        this.leaveSystemTest(st);
    }

    @Override
    public void visitSystemTestStage(SystemTestStage s) {
        this.visitor.visitSystemTestStage(s);
        for (UnitTestStep step : s.steps) {
            this.visitUnitTestStep(step);
        }
        this.leaveSystemTestStage(s);
    }

    @Override
    public void leaveSystemTestStage(SystemTestStage s) {
        this.visitor.leaveSystemTestStage(s);
    }

    @Override
    public void leaveSystemTest(SystemTest st) {
        this.visitor.leaveSystemTest(st);
    }

    @Override
    public void visitContractDecl(ContractDecl cd) {
        if (!cd.generate) {
            return;
        }
        this.visitor.visitContractDecl(cd);
        for (ContractMethodDecl m : cd.methods) {
            this.visitContractMethod(m);
        }
        this.leaveContractDecl(cd);
    }

    @Override
    public void visitContractMethod(ContractMethodDecl cmd) {
        this.visitor.visitContractMethod(cmd);
        for (TypedPattern a : cmd.args) {
            if (!(a instanceof TypedPattern)) continue;
            TypedPattern p = a;
            this.visitTypeReference(p.type, true, -1);
        }
        if (cmd.handler != null) {
            this.visitTypeReference(cmd.handler.type, true, -1);
        }
        this.leaveContractMethod(cmd);
    }

    @Override
    public void leaveContractMethod(ContractMethodDecl cmd) {
        this.visitor.leaveContractMethod(cmd);
    }

    @Override
    public void leaveContractDecl(ContractDecl cd) {
        this.visitor.leaveContractDecl(cd);
    }

    @Override
    public void traversalDone() {
        this.visitor.traversalDone();
    }

    public String toString() {
        return "Traverser{" + this.visitor + "}";
    }

    public static class VarMapping {
        private Map<FunctionIntro, List<SlotVar>> map = new HashMap<FunctionIntro, List<SlotVar>>();

        public VarMapping remember(Slot s, HSIOptions opts, HSICases intros) {
            VarMapping ret = new VarMapping();
            ret.map.putAll(this.map);
            block0: for (HSIOptions.IntroVarName v : opts.vars(intros)) {
                if (!ret.map.containsKey(v.intro)) {
                    ret.map.put(v.intro, new ArrayList());
                }
                List<SlotVar> vl = ret.map.get(v.intro);
                for (SlotVar sv : vl) {
                    if (sv.var != v.var) continue;
                    hsiLogger.info("rebound " + v.var);
                    continue block0;
                }
                vl.add(new SlotVar(s, v.var));
            }
            return ret;
        }

        public void bindFor(HSIVisitor hsi, FunctionIntro intro) {
            List<SlotVar> vars = this.map.get(intro);
            if (vars != null) {
                for (SlotVar sv : vars) {
                    hsi.bind(sv.s, sv.var.var);
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            String sep = "";
            for (Map.Entry<FunctionIntro, List<SlotVar>> e : this.map.entrySet()) {
                sb.append(sep);
                sep = ",";
                sb.append(e.getKey().name().name);
                sb.append("->");
                sb.append(e.getValue());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    private static class SlotVar {
        private final Slot s;
        private final VarName var;

        public SlotVar(Slot s, VarName var) {
            this.s = s;
            this.var = var;
        }

        public String toString() {
            return this.var.var + "<-" + this.s;
        }
    }
}

