/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.io.PrintWriter;
import java.util.Comparator;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.st.SystemTest;

public interface RepositoryEntry {
    public static final Comparator<? super RepositoryEntry> preferredOrder = new Comparator<RepositoryEntry>(){

        @Override
        public int compare(RepositoryEntry o1, RepositoryEntry o2) {
            int cat2;
            int cat1 = this.category(o1);
            if (cat1 < (cat2 = this.category(o2))) {
                return -1;
            }
            if (cat1 > cat2) {
                return 1;
            }
            return o1.name().uniqueName().compareTo(o2.name().uniqueName());
        }

        private int category(RepositoryEntry o1) {
            if (o1 instanceof ContractDecl) {
                return 1;
            }
            if (o1 instanceof SystemTest) {
                return 99;
            }
            return 50;
        }
    };

    public NameOfThing name();

    public InputPosition location();

    public void dumpTo(PrintWriter var1);

    default public ValidContexts validContexts() {
        return ValidContexts.ALL;
    }

    default public void clean() {
    }

    public static enum ValidContexts {
        ALL,
        TESTS;

    }
}

