/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.flasck.flas.Configuration;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.CSName;
import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.compiler.DuplicateNameException;
import org.flasck.flas.compiler.StateNameException;
import org.flasck.flas.compiler.jsgen.packaging.JSEnvironment;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.hsi.HSIVisitor;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.ImplementsContract;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.LocatedName;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.ServiceDefinition;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TupleAssignment;
import org.flasck.flas.parsedForm.TupleMember;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.assembly.Assembly;
import org.flasck.flas.parsedForm.st.SystemTest;
import org.flasck.flas.parsedForm.ut.UnitTestPackage;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.AssemblyTraverser;
import org.flasck.flas.repository.AssemblyVisitor;
import org.flasck.flas.repository.FunctionGroups;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.repository.RepositoryVisitor;
import org.flasck.flas.repository.Traverser;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;
import org.flasck.flas.tc3.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.NoMetaDataException;
import org.ziniki.splitter.SplitMetaData;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class Repository
implements TopLevelDefinitionConsumer,
RepositoryReader {
    private static final Logger logger = LoggerFactory.getLogger((String)"Repository");
    final Map<String, RepositoryEntry> dict = new TreeMap<String, RepositoryEntry>();
    private final List<SplitMetaData> webs = new ArrayList<SplitMetaData>();
    private final Map<URI, List<String>> uriDefines = new TreeMap<URI, List<String>>();
    private final Map<String, List<String>> flimDefines = new TreeMap<String, List<String>>();
    private List<String> currentDefines;

    public void parsing(URI uri) {
        List<String> curr = this.uriDefines.get(uri);
        if (curr == null) {
            this.currentDefines = new ArrayList<String>();
            this.uriDefines.put(uri, this.currentDefines);
        } else {
            while (!curr.isEmpty()) {
                this.dict.remove(curr.remove(0));
            }
            this.currentDefines = curr;
        }
        String fn = uri.getPath();
        File f = new File(fn);
        String pkg = f.getParentFile().getName();
        curr = this.flimDefines.get(pkg);
        if (curr != null) {
            while (!curr.isEmpty()) {
                this.dict.remove(curr.remove(0));
            }
            this.flimDefines.remove(pkg);
        }
    }

    public void readingFLIM(String pkg) {
        List<String> curr = this.flimDefines.get(pkg);
        if (curr == null) {
            this.currentDefines = new ArrayList<String>();
            this.flimDefines.put(pkg, this.currentDefines);
        } else {
            while (!curr.isEmpty()) {
                this.dict.remove(curr.remove(0));
            }
            this.currentDefines = curr;
        }
    }

    public void selectPackage(String pkg) {
        List<String> curr = this.flimDefines.get(pkg);
        if (curr == null) {
            this.currentDefines = new ArrayList<String>();
            this.flimDefines.put(pkg, this.currentDefines);
        } else {
            this.currentDefines = curr;
        }
    }

    public void done() {
        this.currentDefines = null;
    }

    @Override
    public void functionDefn(ErrorReporter errors, FunctionDefinition func) {
        this.addEntry(errors, func.name(), func);
    }

    @Override
    public void tupleDefn(ErrorReporter errors, List<LocatedName> vars, FunctionName exprFnName, FunctionName pkgName, Expr expr) {
        TupleAssignment ta = new TupleAssignment(vars, exprFnName, pkgName, expr);
        NameOfThing pkg = pkgName.inContext;
        int k = 0;
        for (LocatedName x : vars) {
            FunctionName tn = FunctionName.function(x.location, pkg, x.text);
            TupleMember tm = new TupleMember(x.location, ta, k++, tn);
            this.addEntry(errors, tn, tm);
            ta.addMember(tm);
        }
        try {
            this.addEntry(null, exprFnName, ta);
        }
        catch (DuplicateNameException | StateNameException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void argument(ErrorReporter errors, VarPattern parm) {
        this.addEntry(errors, parm.name(), parm);
    }

    @Override
    public void argument(ErrorReporter errors, TypedPattern parm) {
        this.addEntry(errors, parm.name(), parm);
    }

    @Override
    public void newHandler(ErrorReporter errors, HandlerImplements hi) {
        this.addEntry(errors, hi.handlerName, hi);
    }

    @Override
    public void newAgent(ErrorReporter errors, AgentDefinition decl) {
        this.addEntry(errors, decl.cardName(), decl);
    }

    @Override
    public void newCard(ErrorReporter errors, CardDefinition decl) {
        this.addEntry(errors, decl.cardName(), decl);
    }

    @Override
    public void newService(ErrorReporter errors, ServiceDefinition svc) {
        this.addEntry(errors, svc.cardName(), svc);
    }

    @Override
    public void newStandaloneMethod(ErrorReporter errors, StandaloneMethod meth) {
        this.addEntry(errors, meth.name(), meth);
    }

    @Override
    public void newObjectMethod(ErrorReporter errors, ObjectActionHandler om) {
        this.addEntry(errors, om.name(), om);
    }

    @Override
    public void newRequiredContract(ErrorReporter errors, RequiresContract rc) {
        this.addEntry(errors, rc.varName(), rc);
    }

    @Override
    public void newProvidesServiceWithName(ErrorReporter errors, Provides cs) {
        this.addEntry(errors, cs.varName(), cs);
    }

    @Override
    public void newContractImpl(ErrorReporter errors, ImplementsContract ci) {
        this.addEntry(errors, ci.name(), ci);
    }

    @Override
    public void newObjectContract(ErrorReporter errors, ObjectContract oc) {
        this.addEntry(errors, oc.varName(), oc);
    }

    @Override
    public void newStruct(ErrorReporter errors, StructDefn sd) {
        this.addEntry(errors, sd.name(), sd);
        for (PolyType p : sd.polys()) {
            this.addEntry(errors, p.name(), p);
        }
    }

    @Override
    public void newStructField(ErrorReporter errors, StructField sf) {
        this.addEntry(errors, sf.name(), sf);
    }

    @Override
    public void newUnion(ErrorReporter errors, UnionTypeDefn ud) {
        this.addEntry(errors, ud.name(), ud);
        for (PolyType p : ud.polys()) {
            this.addEntry(errors, p.name(), p);
        }
    }

    @Override
    public void newContract(ErrorReporter errors, ContractDecl decl) {
        this.addEntry(errors, decl.name(), decl);
    }

    @Override
    public void newContractMethod(ErrorReporter errors, ContractMethodDecl decl) {
        this.addEntry(errors, decl.name(), decl);
    }

    @Override
    public void newObject(ErrorReporter errors, ObjectDefn od) {
        this.addEntry(errors, od.name(), od);
        for (PolyType p : od.polys()) {
            this.addEntry(errors, p.name(), p);
        }
    }

    @Override
    public void newObjectAccessor(ErrorReporter errors, ObjectAccessor oa) {
        this.addEntry(errors, oa.name(), oa);
    }

    public void unitTestPackage(ErrorReporter errors, UnitTestPackage pkg) {
        this.addEntry(errors, pkg.name(), pkg);
    }

    public void systemTest(ErrorReporter errors, SystemTest st) {
        this.addEntry(errors, st.name(), st);
    }

    @Override
    public void newTestData(ErrorReporter errors, UnitDataDeclaration data) {
        this.addEntry(errors, data.name(), data);
    }

    @Override
    public void newIntroduction(ErrorReporter errors, IntroduceVar var) {
        this.addEntry(errors, var.name(), var);
    }

    @Override
    public void newTemplate(ErrorReporter errors, Template template) {
        this.addEntry(errors, template.name(), template);
    }

    @Override
    public void polytype(ErrorReporter errors, PolyType pt) {
        this.addEntry(errors, pt.name(), pt);
    }

    @Override
    public void addEntry(ErrorReporter errors, NameOfThing name, RepositoryEntry entry) {
        String un = name.uniqueName();
        logger.debug("trying to add " + un + " of type " + entry.getClass());
        if (!this.checkNoStateConflicts(errors, name, entry)) {
            return;
        }
        if (this.dict.containsKey(un)) {
            if (errors != null) {
                errors.message(entry.location(), un + " is defined multiple times: " + this.dict.get(un).location());
                return;
            }
            throw new DuplicateNameException(name);
        }
        this.dict.put(un, entry);
        if (this.currentDefines != null) {
            logger.debug("adding " + un + " to current defines: " + this.currentDefines.size());
            this.currentDefines.add(un);
        }
    }

    private boolean checkNoStateConflicts(ErrorReporter errors, NameOfThing name, RepositoryEntry entry) {
        if (entry instanceof StructField) {
            VarName vn = (VarName)name;
            String cname = vn.container().uniqueName() + ".";
            boolean conflicts = false;
            for (Map.Entry<String, RepositoryEntry> e : this.dict.entrySet()) {
                String base;
                RepositoryEntry val = e.getValue();
                if (!e.getKey().startsWith(cname)) continue;
                NameOfThing rn = e.getValue().name();
                if (rn instanceof FunctionName) {
                    base = ((FunctionName)rn).name;
                } else {
                    if (!(rn instanceof VarName)) continue;
                    base = ((VarName)rn).var;
                }
                if (!base.equals(vn.var)) continue;
                if (errors == null) {
                    throw new NotImplementedException("we should be passed errors in this case - figure it out");
                }
                InputPosition loc = val.location();
                if (val instanceof TypedPattern) {
                    loc = ((TypedPattern)val).var.loc;
                }
                errors.message(loc, "cannot use " + base + " here as it conflicts with state member at " + vn.loc);
                conflicts = true;
            }
            return !conflicts;
        }
        if (name instanceof FunctionName || name instanceof VarName) {
            String base;
            if (name instanceof FunctionName) {
                base = ((FunctionName)name).name;
                if (name.container() != null && name.container() instanceof CSName) {
                    return true;
                }
            } else if (name instanceof VarName) {
                base = ((VarName)name).var;
            } else {
                throw new NotImplementedException("cannot extract base from " + name);
            }
            for (NameOfThing n1 = name; n1 != null && !(n1 instanceof PackageName); n1 = n1.container()) {
                StateDefinition state;
                if (!(n1 instanceof SolidName) && !(n1 instanceof CardName)) continue;
                RepositoryEntry other = this.dict.get(n1.uniqueName());
                if (!(other instanceof StateHolder) || (state = ((StateHolder)((Object)other)).state()) == null || !state.hasMember(base)) break;
                if (errors == null) {
                    throw new StateNameException(state.findField(base).name());
                }
                errors.message(entry.location(), "cannot use " + base + " here as it conflicts with state member at " + state.findField((String)base).loc);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void replaceDefinition(HandlerLambda hl) {
        if (!this.dict.containsKey(hl.name().uniqueName())) {
            throw new NotImplementedException(hl.name().uniqueName() + " was not defined");
        }
        this.dict.put(hl.name().uniqueName(), hl);
    }

    public void webData(SplitMetaData md) {
        this.webs.add(md);
    }

    public void dumpTo(File dumpRepo) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(dumpRepo);
        this.dumpTo(pw);
        pw.close();
    }

    public void dumpTo(PrintWriter pw) {
        for (Map.Entry<String, RepositoryEntry> x : this.dict.entrySet()) {
            pw.print(x.getKey() + " = ");
            x.getValue().dumpTo(pw);
        }
        for (SplitMetaData smd : this.webs) {
            pw.println("have webdata " + smd);
        }
        pw.flush();
    }

    @Override
    public <T extends RepositoryEntry> T get(String string) {
        return (T)this.dict.get(string);
    }

    @Override
    public RepositoryEntry findNested(ErrorReporter errors, InputPosition loc, String scope, String tn) {
        RepositoryEntry have = null;
        for (Map.Entry<String, RepositoryEntry> e : this.dict.entrySet()) {
            String key = e.getKey();
            if (!key.startsWith(scope + ".") || !e.getValue().name().baseName().equals(tn)) continue;
            if (have == null) {
                have = e.getValue();
                continue;
            }
            errors.message(loc, "ambiguous reference to " + tn + " inside " + scope);
        }
        return have;
    }

    @Override
    public Type findUnionWith(ErrorReporter errors, InputPosition pos, Set<Type> ms, boolean needAll) {
        if (ms.isEmpty()) {
            throw new NotImplementedException();
        }
        HashSet<Type> collect = new HashSet<Type>();
        HashSet<PolyType> polys = new HashSet<PolyType>();
        for (Type type : ms) {
            if (type instanceof Primitive && ((Primitive)type).willAcceptAll(ms)) {
                if (ms.size() == 2 && !needAll) {
                    HashSet<Type> foo = new HashSet<Type>(ms);
                    foo.remove(type);
                    return foo.iterator().next();
                }
                return type;
            }
            if (type == LoadBuiltins.error) continue;
            if (type instanceof PolyType) {
                polys.add((PolyType)type);
                continue;
            }
            collect.add(type);
        }
        if (collect.isEmpty()) {
            if (polys.isEmpty()) {
                return LoadBuiltins.any;
            }
            if (polys.size() == 1) {
                return (Type)polys.iterator().next();
            }
            throw new CantHappenException("multiple distinct polys in union: " + polys);
        }
        if (collect.size() == 1) {
            return (Type)collect.iterator().next();
        }
        ArrayList<Object> matching = new ArrayList<Object>();
        for (RepositoryEntry k : this.dict.values()) {
            UnionTypeDefn utd;
            Object union;
            if (!(k instanceof UnionTypeDefn) || (union = (utd = (UnionTypeDefn)k).matches(errors, pos, this, collect, needAll)) == null) continue;
            matching.add(union);
        }
        if (matching.isEmpty()) {
            return null;
        }
        if (matching.size() == 1) {
            return (Type)matching.get(0);
        }
        int n = Integer.MAX_VALUE;
        Object ret = null;
        boolean ambig = false;
        for (Object t : matching) {
            int n2;
            int nc = this.ncases((Type)t);
            if (nc < n2) {
                n2 = nc;
                ret = t;
                continue;
            }
            if (nc != n2) continue;
            ambig = true;
        }
        if (!ambig) {
            return ret;
        }
        TreeSet<String> tyes = new TreeSet<String>();
        for (Type ty : ms) {
            tyes.add(ty.signature());
        }
        TreeSet<String> us = new TreeSet<String>();
        for (Type type : matching) {
            us.add(type.signature());
        }
        errors.message(pos, "multiple unions match " + tyes + ": " + us);
        return null;
    }

    private int ncases(Type t) {
        if (t instanceof PolyInstance) {
            t = ((PolyInstance)t).struct();
        }
        return ((UnionTypeDefn)t).cases.size();
    }

    @Override
    public List<UnionTypeDefn> unionsContaining(StructDefn sd) {
        ArrayList<UnionTypeDefn> ret = new ArrayList<UnionTypeDefn>();
        for (RepositoryEntry k : this.dict.values()) {
            UnionTypeDefn utd;
            if (!(k instanceof UnionTypeDefn) || !(utd = (UnionTypeDefn)k).hasCase(sd)) continue;
            ret.add(utd);
        }
        return ret;
    }

    @Override
    public void traverse(RepositoryVisitor visitor) {
        Traverser t = new Traverser(visitor);
        t.doTraversal(this);
    }

    public void traverseWithImplementedMethods(RepositoryVisitor visitor) {
        Traverser t = new Traverser(visitor);
        t.withImplementedMethods();
        t.doTraversal(this);
    }

    public void traverseLifted(RepositoryVisitor visitor) {
        Traverser t = new Traverser(visitor);
        t.withNestedPatterns();
        t.doTraversal(this);
    }

    @Override
    public void traverseInGroups(RepositoryVisitor visitor, FunctionGroups groups) {
        Traverser t = new Traverser(visitor);
        t.withNestedPatterns();
        t.withFunctionsInDependencyGroups(groups);
        t.withEventSources();
        t.doTraversal(this);
    }

    @Override
    public void traverseWithMemberFields(RepositoryVisitor visitor) {
        Traverser t = new Traverser(visitor);
        t.withMemberFields();
        t.doTraversal(this);
    }

    @Override
    public void traverseWithHSI(HSIVisitor v) {
        Traverser t = new Traverser(v).withHSI().withNestedPatterns();
        t.doTraversal(this);
    }

    public void traverseAssemblies(Configuration config, ErrorReporter errors, JSEnvironment jse, ByteCodeEnvironment bce, AssemblyVisitor v) {
        AssemblyTraverser t = new AssemblyTraverser(errors, jse, bce, v);
        t.doTraversal(this);
    }

    public void traverseAssembly(Configuration config, ErrorReporter errors, JSEnvironment jse, ByteCodeEnvironment bce, AssemblyVisitor v, Assembly asm) {
        AssemblyTraverser t = new AssemblyTraverser(errors, jse, bce, v);
        t.traverse(this, asm);
    }

    @Override
    public CardData findWeb(String baseName) {
        for (SplitMetaData web : this.webs) {
            try {
                return web.forCard(baseName);
            }
            catch (NoMetaDataException noMetaDataException) {
            }
        }
        return null;
    }

    @Override
    public Iterable<SplitMetaData> allWebs() {
        return this.webs;
    }

    public void clean() {
        for (RepositoryEntry e : this.dict.values()) {
            e.clean();
        }
    }

    @Override
    public void dump() {
        for (RepositoryEntry e : this.dict.values()) {
            System.out.println(e.name().uniqueName() + " => " + e);
        }
    }

    public List<NameOfThing> rootPackageNames() {
        ArrayList<NameOfThing> rpns = new ArrayList<NameOfThing>();
        for (RepositoryEntry e : this.dict.values()) {
            PackageName pn;
            NameOfThing name = e.name();
            if (!(name.container() instanceof PackageName) || (pn = (PackageName)name.container()).baseName() != null || pn.isBuiltin()) continue;
            rpns.add(name);
        }
        return rpns;
    }

    public List<Assembly> getAssemblies() {
        ArrayList<Assembly> ret = new ArrayList<Assembly>();
        for (RepositoryEntry d : this.dict.values()) {
            if (!(d instanceof Assembly)) continue;
            ret.add((Assembly)d);
        }
        return ret;
    }

    public Collection<String> flimPackages() {
        return this.flimDefines.keySet();
    }
}

