/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ServiceLoader;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.ObjectName;
import org.flasck.flas.commonBase.names.PackageName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.compiler.modules.ProvideBuiltins;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.CurrentContainer;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.repository.EntityIdAccessor;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.UTOnlyRestriction;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;

public class LoadBuiltins {
    public static final InputPosition pos = new InputPosition("BuiltIn", 1, 0, null, "<<builtin>>");
    public static final PackageName builtinPkg = new PackageName(true);
    public static final TypeReference stringTR = new TypeReference(pos, "String", new TypeReference[0]);
    public static final Primitive string = new Primitive(pos, "String");
    public static final StructDefn error;
    public static final Primitive any;
    public static final TypeReference anyTR;
    public static final Primitive entity;
    public static final TypeReference entityTR;
    public static final FieldAccessor idAccessor;
    public static final Primitive co;
    public static final TypeReference coTR;
    public static final TypeReference numberTR;
    public static final Primitive number;
    public static final TypeReference uriTR;
    public static final Primitive uri;
    public static final Primitive id;
    public static final TypeReference instantTR;
    public static final Primitive instant;
    public static final TypeReference intervalTR;
    public static final Primitive interval;
    public static final TypeReference dateTR;
    public static final Primitive date;
    public static final TypeReference contractTR;
    public static final Primitive contract;
    public static final Primitive idempotentHandler;
    public static final UnionTypeDefn bool;
    public static final TypeReference falseTR;
    public static final StructDefn falseT;
    public static final TypeReference trueTR;
    public static final StructDefn trueT;
    private static TypeReference listATR_A;
    public static final UnionTypeDefn list;
    private static PolyType listA_A;
    public static final StructDefn nil;
    public static final TypeReference nilTR;
    private static TypeReference consATR_A;
    public static final StructDefn cons;
    public static final TypeReference consATR;
    public static final TypeReference listATR;
    public static final PolyInstance listAny;
    public static final TypeReference listAnyTR;
    public static final StructDefn assignItem;
    public static final TypeReference hashTR;
    public static final StructDefn hash;
    public static final StructDefn hashPairType;
    public static final TypeReference messageTR;
    public static final UnionTypeDefn message;
    public static final TypeReference consMessagesTR;
    public static final NamedType consMessages;
    public static final TypeReference listMessagesTR;
    public static final NamedType listMessages;
    public static final TypeReference debugTR;
    public static final StructDefn debug;
    public static final TypeReference sendTR;
    public static final StructDefn send;
    public static final TypeReference assignTR;
    public static final StructDefn assign;
    public static final StructDefn assignCons;
    public static final TypeReference updateDisplayTR;
    public static final StructDefn updateDisplay;
    public static final TypeReference cardTR;
    public static final Primitive card;
    public static final UnionTypeDefn event;
    public static final TypeReference clickEventTR;
    public static final StructDefn clickEvent;
    public static final TypeReference scrollToTR;
    public static final StructDefn scrollTo;
    public static final TypeReference linkTR;
    public static final StructDefn link;
    public static final TypeReference hlmlTR;
    public static final StructDefn hlml;
    public static final TypeReference randomTR;
    public static final ObjectDefn random;
    private static ObjectCtor randomSeed;
    private static ObjectCtor randomUnseeded;
    private static ObjectAccessor randomNext;
    private static ObjectMethod randomUsed;
    public static final TypeReference imageTR;
    public static final ObjectDefn image;
    private static ObjectCtor imageFrom;
    private static ObjectCtor imageAsset;
    private static ObjectCtor imageUri;
    public static final TypeReference htmlTR;
    public static final ObjectDefn html;
    private static ObjectCtor htmlFrom;
    public static final ContractDecl crobagSlideWindow;
    public static final ContractDecl crobagWindowHandler;
    public static final TypeReference crobagTR;
    public static final ObjectDefn crobag;
    private static ObjectCtor crobagNew;
    private static ObjectMethod crobagInsert;
    private static ObjectMethod crobagPut;
    private static ObjectMethod crobagUpsert;
    private static ObjectMethod crobagWindow;
    private static ObjectAccessor crobagSize;
    public static final TypeReference calendarTR;
    public static final ObjectDefn calendar;
    private static ObjectCtor calendarGregorian;
    private static ObjectMethod calendarTimezone;
    private static ObjectAccessor calendarIsoDateTime;
    private static ObjectAccessor calendarParseIsoDate;
    private static ObjectAccessor calendarParseIsoDateTime;
    public static final FunctionDefinition getYear;
    public static final FunctionDefinition parseIsoDate;
    public static final FunctionDefinition isoDate;
    public static final FunctionDefinition dateIsAfter;
    public static final TypeReference typeTR;
    public static StructDefn type;
    public static final FunctionDefinition isNull;
    public static final FunctionDefinition isEqual;
    public static final FunctionDefinition isNotEqual;
    public static final FunctionDefinition isGE;
    public static final FunctionDefinition isGT;
    public static final FunctionDefinition isLE;
    public static final FunctionDefinition isLT;
    public static final FunctionDefinition plus;
    public static final FunctionDefinition unaryMinus;
    public static final FunctionDefinition minus;
    public static final FunctionDefinition mul;
    public static final FunctionDefinition div;
    public static final FunctionDefinition mod;
    public static final FunctionDefinition round;
    public static final FunctionDefinition not;
    public static final FunctionDefinition and;
    public static final FunctionDefinition or;
    public static final FunctionDefinition concat;
    public static final FunctionDefinition numberFromString;
    public static final FunctionDefinition makeTuple;
    public static final FunctionDefinition handleSend;
    public static final FunctionDefinition isType;
    public static final FunctionDefinition dispatch;
    public static final FunctionDefinition show;
    public static final FunctionDefinition formatShow;
    public static final FunctionDefinition expr;
    public static final FunctionDefinition length;
    public static final FunctionDefinition replace;
    public static final FunctionDefinition nth;
    public static final FunctionDefinition item;
    public static final FunctionDefinition take;
    public static final FunctionDefinition drop;
    public static final FunctionDefinition append;
    public static final FunctionDefinition reverse;
    public static final FunctionDefinition concatLists;
    public static final FunctionDefinition assoc;
    public static final FunctionDefinition hashPair;
    public static final FunctionDefinition strlen;
    public static final FunctionDefinition seconds;
    public static final FunctionDefinition milliseconds;
    public static final FunctionDefinition unixdate;
    public static final FunctionDefinition fromunixdate;
    public static final FunctionDefinition parseUri;
    public static final FunctionDefinition parseJson;
    public static final UnresolvedVar probeState;
    public static final UnresolvedVar getUnderlying;

    public static void applyTo(ErrorReporter errors, Repository repository) {
        repository.addEntry(errors, any.name(), any);
        repository.addEntry(errors, new SolidName(builtinPkg, "Entity"), entity);
        repository.addEntry(errors, contract.name(), contract);
        repository.newStruct(errors, error);
        repository.addEntry(errors, co.name(), co);
        repository.addEntry(errors, number.name(), number);
        repository.addEntry(errors, string.name(), string);
        repository.addEntry(errors, uri.name(), uri);
        repository.addEntry(errors, interval.name(), interval);
        repository.addEntry(errors, instant.name(), instant);
        repository.addEntry(errors, date.getName(), date);
        repository.newStruct(errors, type);
        repository.addEntry(errors, falseT.name(), falseT);
        repository.addEntry(errors, trueT.name(), trueT);
        repository.addEntry(errors, bool.name(), bool);
        repository.addEntry(errors, new SolidName(builtinPkg, "[]"), nil);
        repository.newStruct(errors, nil);
        repository.newStruct(errors, cons);
        repository.newUnion(errors, list);
        repository.newStruct(errors, hash);
        repository.addEntry(errors, new SolidName(builtinPkg, "{}"), hash);
        repository.addEntry(errors, id.name(), id);
        repository.newObject(errors, random);
        repository.newObjectMethod(errors, randomSeed);
        repository.newObjectMethod(errors, randomUnseeded);
        repository.newObjectAccessor(errors, randomNext);
        repository.newObjectMethod(errors, randomUsed);
        repository.newObject(errors, image);
        repository.newObjectMethod(errors, imageFrom);
        repository.newObjectMethod(errors, imageAsset);
        repository.newObjectMethod(errors, imageUri);
        repository.newObject(errors, html);
        repository.newObjectMethod(errors, htmlFrom);
        repository.newObject(errors, crobag);
        repository.newObjectMethod(errors, crobagNew);
        repository.newObjectMethod(errors, crobagInsert);
        repository.newObjectMethod(errors, crobagPut);
        repository.newObjectMethod(errors, crobagUpsert);
        repository.newObjectMethod(errors, crobagWindow);
        repository.newObjectAccessor(errors, crobagSize);
        repository.newObject(errors, calendar);
        repository.newObjectMethod(errors, calendarGregorian);
        repository.newObjectAccessor(errors, calendarIsoDateTime);
        repository.newObjectAccessor(errors, calendarParseIsoDate);
        repository.newObjectAccessor(errors, calendarParseIsoDateTime);
        repository.functionDefn(errors, getYear);
        repository.functionDefn(errors, dateIsAfter);
        repository.functionDefn(errors, parseIsoDate);
        repository.functionDefn(errors, isoDate);
        repository.newContract(errors, crobagWindowHandler);
        repository.newContract(errors, crobagSlideWindow);
        repository.newStruct(errors, debug);
        repository.newStruct(errors, send);
        repository.newStruct(errors, assign);
        repository.newStruct(errors, updateDisplay);
        repository.newUnion(errors, message);
        repository.addEntry(errors, card.name(), card);
        repository.newStruct(errors, clickEvent);
        repository.newStruct(errors, scrollTo);
        repository.newUnion(errors, event);
        repository.newStruct(errors, link);
        repository.functionDefn(errors, isNull);
        repository.functionDefn(errors, isEqual);
        repository.functionDefn(errors, isNotEqual);
        repository.functionDefn(errors, isGE);
        repository.functionDefn(errors, isGT);
        repository.functionDefn(errors, isLE);
        repository.functionDefn(errors, isLT);
        repository.functionDefn(errors, plus);
        repository.functionDefn(errors, minus);
        repository.functionDefn(errors, mul);
        repository.functionDefn(errors, div);
        repository.functionDefn(errors, mod);
        repository.functionDefn(errors, round);
        repository.functionDefn(errors, not);
        repository.functionDefn(errors, and);
        repository.functionDefn(errors, or);
        repository.functionDefn(errors, concat);
        repository.functionDefn(errors, numberFromString);
        repository.functionDefn(errors, makeTuple);
        repository.functionDefn(errors, handleSend);
        repository.functionDefn(errors, isType);
        repository.functionDefn(errors, dispatch);
        repository.functionDefn(errors, show);
        repository.functionDefn(errors, formatShow);
        repository.functionDefn(errors, expr);
        repository.functionDefn(errors, length);
        repository.functionDefn(errors, replace);
        repository.functionDefn(errors, nth);
        repository.functionDefn(errors, item);
        repository.functionDefn(errors, drop);
        repository.functionDefn(errors, take);
        repository.functionDefn(errors, append);
        repository.functionDefn(errors, reverse);
        repository.functionDefn(errors, concatLists);
        repository.functionDefn(errors, assoc);
        repository.functionDefn(errors, hashPair);
        repository.functionDefn(errors, strlen);
        repository.functionDefn(errors, seconds);
        repository.functionDefn(errors, milliseconds);
        repository.functionDefn(errors, unixdate);
        repository.functionDefn(errors, fromunixdate);
        repository.functionDefn(errors, parseUri);
        repository.functionDefn(errors, parseJson);
        ServiceLoader<ProvideBuiltins> modules = ServiceLoader.load(ProvideBuiltins.class);
        for (ProvideBuiltins pb : modules) {
            pb.applyTo(errors, repository);
        }
    }

    static {
        stringTR.bind(string);
        error = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Error"), false, new ArrayList<PolyType>());
        error.addField(new StructField(pos, error, true, true, stringTR, "message"));
        any = new Primitive(pos, "Any");
        anyTR = new TypeReference(pos, "Any", new TypeReference[0]);
        anyTR.bind(any);
        any.accept(ms -> true);
        entity = new Primitive(pos, "Entity");
        entityTR = new TypeReference(pos, "Entity", new TypeReference[0]);
        idAccessor = new EntityIdAccessor();
        entityTR.bind(entity);
        entity.accept(ms -> true);
        co = new Primitive(pos, "ContentObject");
        coTR = new TypeReference(pos, "ContentObject", new TypeReference[0]);
        coTR.bind(co);
        numberTR = new TypeReference(pos, "Number", new TypeReference[0]);
        number = new Primitive(pos, "Number");
        numberTR.bind(number);
        uriTR = new TypeReference(pos, "Uri", new TypeReference[0]);
        uri = new Primitive(pos, "Uri");
        uriTR.bind(uri);
        id = new Primitive(pos, "Id");
        instantTR = new TypeReference(pos, "Instant", new TypeReference[0]);
        instant = new Primitive(pos, "Instant");
        instantTR.bind(instant);
        intervalTR = new TypeReference(pos, "Interval", new TypeReference[0]);
        interval = new Primitive(pos, "Interval");
        intervalTR.bind(interval);
        dateTR = new TypeReference(pos, "Date", new TypeReference[0]);
        date = new Primitive(pos, "Date");
        dateTR.bind(date);
        contractTR = new TypeReference(pos, "Contract", new TypeReference[0]);
        idempotentHandler = contract = new Primitive(pos, "Contract");
        contractTR.bind(contract);
        bool = new UnionTypeDefn(pos, false, new SolidName(builtinPkg, "Boolean"), new PolyType[0]);
        falseTR = new TypeReference(pos, "False", new TypeReference[0]);
        falseT = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "False"), false, new ArrayList<PolyType>());
        falseTR.bind(falseT);
        bool.addCase(falseTR);
        trueTR = new TypeReference(pos, "True", new TypeReference[0]);
        trueT = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "True"), false, new ArrayList<PolyType>());
        trueTR.bind(trueT);
        bool.addCase(trueTR);
        listATR_A = new TypeReference(pos, "A", new TypeReference[0]);
        list = new UnionTypeDefn(pos, false, new SolidName(builtinPkg, "List"), new ArrayList<PolyType>());
        listA_A = new PolyType(pos, new SolidName(list.name(), "A"));
        listATR_A.bind(listA_A);
        list.polys().add(listA_A);
        nil = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Nil"), false, new ArrayList<PolyType>());
        nilTR = new TypeReference(pos, "Nil", new TypeReference[0]);
        nilTR.bind(nil);
        list.addCase(nilTR);
        consATR_A = new TypeReference(pos, "A", new TypeReference[0]);
        cons = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Cons"), false, new ArrayList<PolyType>());
        consATR = new TypeReference(pos, "Cons", consATR_A);
        consATR.bind(cons);
        PolyType cta = new PolyType(pos, new SolidName(cons.name(), "A"));
        cons.polys().add(cta);
        consATR_A.bind(cta);
        StructField head = new StructField(pos, cons, true, true, consATR_A, "head");
        head.fullName(new VarName(pos, cons.name(), "head"));
        cons.addField(head);
        PolyInstance pil = new PolyInstance(pos, list, Arrays.asList(cta));
        TypeReference piltr = new TypeReference(pos, "List", consATR_A);
        piltr.bind(pil);
        StructField tail = new StructField(pos, cons, true, true, piltr, "tail");
        tail.fullName(new VarName(pos, cons.name(), "tail"));
        cons.addField(tail);
        TypeReference lc = new TypeReference(pos, "Cons", listATR_A);
        lc.bind(new PolyInstance(pos, cons, Arrays.asList(listA_A)));
        list.addCase(lc);
        listATR = new TypeReference(pos, "List", listATR_A);
        listATR.bind(list);
        listAny = new PolyInstance(pos, list, Arrays.asList(any));
        listAnyTR = new TypeReference(pos, "List", anyTR);
        listAnyTR.bind(listAny);
        assignItem = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "AssignItem"), false, new ArrayList<PolyType>());
        TypeReference aitr = new TypeReference(pos, "A", new TypeReference[0]);
        PolyType aip = new PolyType(pos, new SolidName(assignItem.name(), "A"));
        aitr.bind(aip);
        assignItem.polys().add(aip);
        StructField aihead = new StructField(pos, assignItem, true, true, aitr, "head");
        aihead.fullName(new VarName(pos, assignItem.name(), "head"));
        assignItem.addField(aihead);
        hashTR = new TypeReference(pos, "Hash", new TypeReference[0]);
        hash = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Hash"), false, new ArrayList<PolyType>());
        hashTR.bind(hash);
        hashPairType = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "_HashPair"), false, new ArrayList<PolyType>());
        messageTR = new TypeReference(pos, "Message", new TypeReference[0]);
        message = new UnionTypeDefn(pos, false, new SolidName(builtinPkg, "Message"), new PolyType[0]);
        consMessagesTR = new TypeReference(pos, "Cons", messageTR);
        consMessages = new PolyInstance(pos, cons, Arrays.asList(message));
        listMessagesTR = new TypeReference(pos, "List", messageTR);
        listMessages = new PolyInstance(pos, list, Arrays.asList(message));
        messageTR.bind(message);
        consMessagesTR.bind(consMessages);
        listMessagesTR.bind(listMessages);
        message.addCase(nilTR);
        message.addCase(consMessagesTR);
        message.addCase(listMessagesTR);
        debugTR = new TypeReference(pos, "Debug", new TypeReference[0]);
        debug = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Debug"), false, new ArrayList<PolyType>());
        debugTR.bind(debug);
        debug.addField(new StructField(pos, debug, true, true, stringTR, "message"));
        message.addCase(debugTR);
        sendTR = new TypeReference(pos, "Send", new TypeReference[0]);
        send = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Send"), false, new ArrayList<PolyType>());
        sendTR.bind(send);
        send.addField(new StructField(pos, send, false, true, contractTR, "sendto"));
        send.addField(new StructField(pos, send, false, true, stringTR, "meth"));
        send.addField(new StructField(pos, send, false, true, listAnyTR, "args"));
        message.addCase(sendTR);
        assignTR = new TypeReference(pos, "Assign", new TypeReference[0]);
        assign = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Assign"), false, new ArrayList<PolyType>());
        assignTR.bind(assign);
        assign.addField(new StructField(pos, assign, false, true, anyTR, "on"));
        assign.addField(new StructField(pos, assign, false, true, stringTR, "fld"));
        assign.addField(new StructField(pos, assign, false, true, anyTR, "value"));
        message.addCase(assignTR);
        assignCons = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "AssignCons"), false, new ArrayList<PolyType>());
        assignCons.addField(new StructField(pos, assignCons, false, true, anyTR, "on"));
        assignCons.addField(new StructField(pos, assignCons, false, true, anyTR, "value"));
        updateDisplayTR = new TypeReference(pos, "UpdateDisplay", new TypeReference[0]);
        updateDisplay = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "UpdateDisplay"), false, new ArrayList<PolyType>());
        updateDisplayTR.bind(updateDisplay);
        message.addCase(updateDisplayTR);
        cardTR = new TypeReference(pos, "Card", new TypeReference[0]);
        card = new Primitive(pos, "Card");
        cardTR.bind(card);
        event = new UnionTypeDefn(pos, false, new SolidName(builtinPkg, "Event"), new PolyType[0]);
        clickEventTR = new TypeReference(pos, "ClickEvent", new TypeReference[0]);
        clickEvent = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "ClickEvent"), false, new ArrayList<PolyType>());
        clickEventTR.bind(clickEvent);
        StructField source = new StructField(pos, pos, clickEvent, true, true, anyTR, "source", new CurrentContainer(pos, clickEvent));
        clickEvent.addField(source);
        source.fullName(new VarName(pos, clickEvent.name(), "source"));
        event.addCase(clickEventTR);
        scrollToTR = new TypeReference(pos, "ScrollTo", new TypeReference[0]);
        scrollTo = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "ScrollTo"), false, new ArrayList<PolyType>());
        scrollToTR.bind(scrollTo);
        StructField whereTo = new StructField(pos, pos, scrollTo, true, true, anyTR, "to", null);
        scrollTo.addField(whereTo);
        whereTo.fullName(new VarName(pos, scrollTo.name(), "to"));
        source = new StructField(pos, pos, scrollTo, true, true, anyTR, "source", new CurrentContainer(pos, scrollTo));
        scrollTo.addField(source);
        source.fullName(new VarName(pos, scrollTo.name(), "source"));
        event.addCase(scrollToTR);
        linkTR = new TypeReference(pos, "Link", new TypeReference[0]);
        link = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Link"), false, new ArrayList<PolyType>());
        linkTR.bind(link);
        StructField uri = new StructField(pos, pos, link, true, true, uriTR, "uri", null);
        link.addField(uri);
        uri.fullName(new VarName(pos, link.name(), "uri"));
        StructField label = new StructField(pos, pos, link, true, true, stringTR, "label", null);
        link.addField(label);
        label.fullName(new VarName(pos, link.name(), "label"));
        hlmlTR = new TypeReference(pos, "hlml", new TypeReference[0]);
        hlml = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "hlml"), false, new ArrayList<PolyType>());
        hlmlTR.bind(hlml);
        uri = new StructField(pos, pos, hlml, true, true, uriTR, "uri", null);
        hlml.addField(uri);
        uri.fullName(new VarName(pos, hlml.name(), "uri"));
        label = new StructField(pos, pos, hlml, true, true, stringTR, "label", null);
        hlml.addField(label);
        label.fullName(new VarName(pos, hlml.name(), "label"));
        randomTR = new TypeReference(pos, "Random", new TypeReference[0]);
        random = new ObjectDefn(pos, pos, new ObjectName(builtinPkg, "Random"), false, new ArrayList<PolyType>());
        randomTR.bind(random);
        FunctionName ctorSeed = FunctionName.objectCtor(pos, random.name(), "seed");
        randomSeed = new ObjectCtor(pos, random, ctorSeed, Arrays.asList(new TypedPattern(pos, numberTR, new VarName(pos, ctorSeed, "seed"))));
        randomSeed.dontGenerate();
        randomSeed.bindType(new Apply(number, random));
        random.addConstructor(randomSeed);
        FunctionName ctorUnseeded = FunctionName.objectCtor(pos, random.name(), "unseeded");
        randomUnseeded = new ObjectCtor(pos, random, ctorUnseeded, new ArrayList<Pattern>());
        randomUnseeded.dontGenerate();
        randomUnseeded.bindType(random);
        random.addConstructor(randomUnseeded);
        FunctionName afn = FunctionName.function(pos, random.name(), "next");
        FunctionDefinition acor = new FunctionDefinition(afn, 1, random);
        acor.bindType(new Apply(number, new PolyInstance(pos, list, Arrays.asList(number))));
        randomNext = new ObjectAccessor(random, acor);
        randomNext.dontGenerate();
        random.addAccessor(randomNext);
        FunctionName used = FunctionName.objectMethod(pos, random.name(), "used");
        randomUsed = new ObjectMethod(pos, used, Arrays.asList(new TypedPattern(pos, numberTR, new VarName(pos, used, "quant"))), null, random);
        randomUsed.dontGenerate();
        randomUsed.bindType(new Apply(number, listMessages));
        random.addMethod(randomUsed);
        imageTR = new TypeReference(pos, "Image", new TypeReference[0]);
        image = new ObjectDefn(pos, pos, new ObjectName(builtinPkg, "Image"), false, new ArrayList<PolyType>());
        imageTR.bind(image);
        FunctionName ctorFrom = FunctionName.objectCtor(pos, image.name(), "from");
        imageFrom = new ObjectCtor(pos, image, ctorFrom, Arrays.asList(new TypedPattern(pos, coTR, new VarName(pos, ctorFrom, "co"))));
        imageFrom.dontGenerate();
        imageFrom.bindType(new Apply(co, image));
        image.addConstructor(imageFrom);
        FunctionName ctorAsset = FunctionName.objectCtor(pos, image.name(), "asset");
        imageAsset = new ObjectCtor(pos, image, ctorAsset, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, ctorAsset, "asset"))));
        imageAsset.dontGenerate();
        imageAsset.bindType(new Apply(string, image));
        image.addConstructor(imageAsset);
        FunctionName ctorUri = FunctionName.objectCtor(pos, image.name(), "uri");
        imageUri = new ObjectCtor(pos, image, ctorUri, Arrays.asList(new TypedPattern(pos, uriTR, new VarName(pos, ctorUri, "uri"))));
        imageUri.dontGenerate();
        imageUri.bindType(new Apply(LoadBuiltins.uri, image));
        image.addConstructor(imageUri);
        htmlTR = new TypeReference(pos, "Html", new TypeReference[0]);
        html = new ObjectDefn(pos, pos, new ObjectName(builtinPkg, "Html"), false, new ArrayList<PolyType>());
        htmlTR.bind(html);
        ctorFrom = FunctionName.objectCtor(pos, html.name(), "from");
        htmlFrom = new ObjectCtor(pos, html, ctorFrom, Arrays.asList(new TypedPattern(pos, new TypeReference(pos, "AjaxMessage", new TypeReference[0]).bindDynamically(), new VarName(pos, ctorFrom, "msg"))));
        htmlFrom.dontGenerate();
        htmlFrom.dynamicallyType();
        html.addConstructor(htmlFrom);
        crobagSlideWindow = new ContractDecl(pos, pos, ContractDecl.ContractType.HANDLER, new SolidName(builtinPkg, "SlideWindow"), false);
        crobagWindowHandler = new ContractDecl(pos, pos, ContractDecl.ContractType.HANDLER, new SolidName(builtinPkg, "CrobagWindow"), false);
        FunctionName next = FunctionName.contractMethod(pos, crobagWindowHandler.name(), "next");
        ContractMethodDecl nextcmd = new ContractMethodDecl(pos, pos, pos, false, next, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, next, "from")), new TypedPattern(pos, numberTR, new VarName(pos, next, "size"))), null);
        crobagWindowHandler.addMethod(nextcmd);
        FunctionName done = FunctionName.contractMethod(pos, crobagWindowHandler.name(), "done");
        ContractMethodDecl donecmd = new ContractMethodDecl(pos, pos, pos, false, done, new ArrayList<TypedPattern>(), new TypedPattern(pos, new TypeReference(pos, "SlideWindow", new TypeReference[0]), new VarName(pos, done, "slide")));
        crobagWindowHandler.addMethod(donecmd);
        crobagTR = new TypeReference(pos, "Crobag", new TypeReference[0]);
        crobag = new ObjectDefn(pos, pos, new ObjectName(builtinPkg, "Crobag"), false, new ArrayList<PolyType>());
        PolyType cp = new PolyType(pos, new SolidName(crobag.name(), "A"));
        crobagTR.bind(crobag);
        crobag.polys().add(cp);
        FunctionName ctorNew = FunctionName.objectCtor(pos, crobag.name(), "new");
        crobagNew = new ObjectCtor(pos, crobag, ctorNew, new ArrayList<Pattern>());
        crobagNew.dontGenerate();
        crobagNew.bindType(crobag);
        crobag.addConstructor(crobagNew);
        FunctionName insert = FunctionName.objectMethod(pos, crobag.name(), "insert");
        crobagInsert = new ObjectMethod(pos, insert, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, insert, "key")), new TypedPattern(pos, entityTR, new VarName(pos, insert, "value"))), null, crobag);
        crobagInsert.dontGenerate();
        crobagInsert.bindType(new Apply(string, entity, listMessages));
        crobag.addMethod(crobagInsert);
        FunctionName put = FunctionName.objectMethod(pos, crobag.name(), "put");
        crobagPut = new ObjectMethod(pos, put, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, put, "key")), new TypedPattern(pos, entityTR, new VarName(pos, put, "value"))), null, crobag);
        crobagPut.dontGenerate();
        crobagPut.bindType(new Apply(string, entity, listMessages));
        crobag.addMethod(crobagPut);
        FunctionName upsert = FunctionName.objectMethod(pos, crobag.name(), "upsert");
        crobagUpsert = new ObjectMethod(pos, upsert, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, upsert, "key")), new TypedPattern(pos, entityTR, new VarName(pos, upsert, "value"))), null, crobag);
        crobagUpsert.dontGenerate();
        crobagUpsert.bindType(new Apply(string, entity, listMessages));
        crobag.addMethod(crobagUpsert);
        FunctionName window = FunctionName.objectMethod(pos, crobag.name(), "window");
        crobagWindow = new ObjectMethod(pos, window, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, window, "from")), new TypedPattern(pos, numberTR, new VarName(pos, window, "size"))), new VarPattern(pos, new VarName(pos, window, "handler")), crobag);
        crobagWindow.dontGenerate();
        crobagWindow.bindType(new Apply(string, number, crobagWindowHandler, listMessages));
        crobag.addMethod(crobagWindow);
        FunctionName size = FunctionName.objectMethod(pos, crobag.name(), "size");
        FunctionDefinition sizeFn = new FunctionDefinition(size, 0, crobag);
        crobagSize = new ObjectAccessor(crobag, sizeFn);
        crobagSize.dontGenerate();
        crobagSize.validContexts(RepositoryEntry.ValidContexts.TESTS);
        sizeFn.bindType(number);
        crobag.addAccessor(crobagSize);
        calendarTR = new TypeReference(pos, "Calendar", new TypeReference[0]);
        calendar = new ObjectDefn(pos, pos, new ObjectName(builtinPkg, "Calendar"), false, new ArrayList<PolyType>());
        calendarTR.bind(calendar);
        FunctionName gregorian = FunctionName.objectCtor(pos, calendar.name(), "gregorian");
        calendarGregorian = new ObjectCtor(pos, calendar, gregorian, new ArrayList<Pattern>());
        calendarGregorian.dontGenerate();
        calendarGregorian.bindType(calendar);
        calendar.addConstructor(calendarGregorian);
        FunctionName timezone = FunctionName.objectMethod(pos, calendar.name(), "timezone");
        calendarTimezone = new ObjectMethod(pos, timezone, Arrays.asList(new TypedPattern(pos, stringTR, new VarName(pos, timezone, "tz"))), null, calendar);
        calendarTimezone.dontGenerate();
        calendarTimezone.bindType(new Apply(string, listMessages));
        calendar.addMethod(calendarTimezone);
        FunctionName idt = FunctionName.objectMethod(pos, calendar.name(), "isoDateTime");
        FunctionDefinition isodatetime = new FunctionDefinition(idt, 1, calendar);
        calendarIsoDateTime = new ObjectAccessor(calendar, isodatetime);
        calendarIsoDateTime.dontGenerate();
        isodatetime.bindType(new Apply(instant, string));
        calendar.addAccessor(calendarIsoDateTime);
        FunctionName pidt = FunctionName.objectMethod(pos, calendar.name(), "parseIsoDate");
        FunctionDefinition pidtFn = new FunctionDefinition(pidt, 1, null);
        calendarParseIsoDate = new ObjectAccessor(calendar, pidtFn);
        calendarParseIsoDate.dontGenerate();
        pidtFn.bindType(new Apply(string, date));
        calendar.addAccessor(calendarParseIsoDate);
        pidt = FunctionName.objectMethod(pos, calendar.name(), "parseIsoDateTime");
        pidtFn = new FunctionDefinition(pidt, 1, null);
        calendarParseIsoDateTime = new ObjectAccessor(calendar, pidtFn);
        calendarParseIsoDateTime.dontGenerate();
        pidtFn.bindType(new Apply(string, instant));
        calendar.addAccessor(calendarParseIsoDateTime);
        getYear = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "getYear"), 1, null).dontGenerate();
        parseIsoDate = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "parseIsoDate"), 1, null).dontGenerate();
        isoDate = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "isoDate"), 1, null).dontGenerate();
        dateIsAfter = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "dateIsAfter"), 2, null).dontGenerate();
        getYear.bindType(new Apply(date, number));
        dateIsAfter.bindType(new Apply(date, date, bool));
        parseIsoDate.bindType(new Apply(string, date));
        isoDate.bindType(new Apply(date, string));
        typeTR = new TypeReference(pos, "Type", new TypeReference[0]);
        type = new StructDefn(pos, pos, FieldsDefn.FieldsType.STRUCT, new SolidName(builtinPkg, "Type"), false, new ArrayList<PolyType>());
        typeTR.bind(type);
        type.addField(new StructField(pos, type, false, true, stringTR, "type"));
        isNull = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "isNull"), 1, null).dontGenerate();
        isEqual = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "=="), 2, null).dontGenerate();
        isNotEqual = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "<>"), 2, null).dontGenerate();
        isGE = new FunctionDefinition(FunctionName.function(pos, builtinPkg, ">="), 2, null).dontGenerate();
        isGT = new FunctionDefinition(FunctionName.function(pos, builtinPkg, ">"), 2, null).dontGenerate();
        isLE = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "<="), 2, null).dontGenerate();
        isLT = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "<"), 2, null).dontGenerate();
        isNull.bindType(new Apply(any, bool));
        PolyType pa = new PolyType(pos, new SolidName(isEqual.name(), "A"));
        isEqual.bindType(new Apply(pa, pa, bool));
        isNotEqual.bindType(new Apply(number, number, bool));
        isGE.bindType(new Apply(number, number, bool));
        isGT.bindType(new Apply(number, number, bool));
        isLE.bindType(new Apply(number, number, bool));
        isLT.bindType(new Apply(number, number, bool));
        plus = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "+"), 2, null).dontGenerate();
        unaryMinus = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "-"), 1, null).dontGenerate();
        minus = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "-"), 2, null).dontGenerate();
        mul = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "*"), 2, null).dontGenerate();
        div = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "/"), 2, null).dontGenerate();
        mod = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "%"), 2, null).dontGenerate();
        round = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "round"), 1, null).dontGenerate();
        plus.bindType(new Apply(number, number, number));
        unaryMinus.bindType(new Apply(number, number));
        minus.bindType(new Apply(number, number, number));
        mul.bindType(new Apply(number, number, number));
        div.bindType(new Apply(number, number, number));
        mod.bindType(new Apply(number, number, number));
        round.bindType(new Apply(number, number));
        not = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "!"), 1, null).dontGenerate();
        and = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "&&"), 2, null).dontGenerate();
        or = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "||"), 2, null).dontGenerate();
        not.bindType(new Apply(bool, bool));
        and.bindType(new Apply(bool, bool, bool));
        or.bindType(new Apply(bool, bool, bool));
        concat = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "++"), 2, null).dontGenerate();
        concat.bindType(new Apply(string, string, string));
        numberFromString = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "numberFromString"), 1, null).dontGenerate();
        numberFromString.bindType(new Apply(string, number));
        makeTuple = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "()"), -1, null).dontGenerate();
        handleSend = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "->"), 2, null).dontGenerate();
        handleSend.bindType(new Apply(new Apply(contract, send), contract, send));
        isType = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "istype"), 2, null).dontGenerate();
        dispatch = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "dispatch"), 1, null).dontGenerate();
        show = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "show"), 1, null).dontGenerate();
        formatShow = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "formatShow"), 2, null).dontGenerate();
        expr = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "expr"), 1, null).dontGenerate();
        isType.bindType(new Apply(type, any, bool));
        dispatch.bindType(new Apply(listMessages, listMessages));
        dispatch.restrict(new UTOnlyRestriction("dispatch"));
        show.bindType(new Apply(any, string));
        formatShow.bindType(new Apply(string, number, string));
        expr.bindType(new Apply(any, string));
        length = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "length"), 1, null).dontGenerate();
        replace = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "replace"), 3, null).dontGenerate();
        nth = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "nth"), 2, null).dontGenerate();
        item = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "item"), 2, null).dontGenerate();
        take = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "take"), 2, null).dontGenerate();
        drop = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "drop"), 2, null).dontGenerate();
        append = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "append"), 2, null).dontGenerate();
        reverse = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "reverse"), 1, null).dontGenerate();
        concatLists = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "concatLists"), 1, null).dontGenerate();
        length.bindType(new Apply(list, number));
        replace.bindType(new Apply(list, number, listA_A, list));
        nth.bindType(new Apply(number, list, listA_A));
        item.bindType(new Apply(number, list, assignItem));
        take.bindType(new Apply(number, list, list));
        drop.bindType(new Apply(number, list, list));
        append.bindType(new Apply(list, listA_A, list));
        reverse.bindType(new Apply(list, list));
        concatLists.bindType(new Apply(new PolyInstance(pos, list, Arrays.asList(new PolyInstance(pos, list, Arrays.asList(listA_A)))), new PolyInstance(pos, list, Arrays.asList(listA_A))));
        assoc = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "assoc"), 2, null).dontGenerate();
        hashPair = new FunctionDefinition(FunctionName.function(pos, builtinPkg, ":"), 2, null).dontGenerate();
        assoc.bindType(new Apply(hash, string, any));
        hashPair.bindType(new Apply(string, any, hashPairType));
        strlen = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "strlen"), 1, null).dontGenerate();
        strlen.bindType(new Apply(string, number));
        seconds = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "seconds"), 1, null).dontGenerate();
        milliseconds = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "milliseconds"), 1, null).dontGenerate();
        unixdate = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "unixdate"), 1, null).dontGenerate();
        fromunixdate = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "fromunixdate"), 1, null).dontGenerate();
        seconds.bindType(new Apply(number, interval));
        milliseconds.bindType(new Apply(number, interval));
        unixdate.bindType(new Apply(instant, number));
        fromunixdate.bindType(new Apply(number, instant));
        parseUri = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "parseUri"), 1, null).dontGenerate();
        parseJson = new FunctionDefinition(FunctionName.function(pos, builtinPkg, "parseJson"), 1, null).dontGenerate();
        parseUri.bindType(new Apply(string, LoadBuiltins.uri));
        parseJson.bindType(new Apply(string, hash));
        probeState = new UnresolvedVar(pos, "_probe_state");
        getUnderlying = new UnresolvedVar(pos, "_underlying");
        probeState.bind(new FunctionDefinition(FunctionName.function(pos, builtinPkg, "_probe_state"), 2, null));
        getUnderlying.bind(new FunctionDefinition(FunctionName.function(pos, builtinPkg, "_underlying"), 1, null));
    }
}

