/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.repository.HSICases;

public class FunctionHSICases
implements HSICases {
    public List<FunctionIntro> intros;

    public FunctionHSICases(List<FunctionIntro> intros) {
        this.intros = intros;
    }

    @Override
    public List<String> introNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (FunctionIntro i : this.intros) {
            ret.add(i.name().uniqueName());
        }
        return ret;
    }

    @Override
    public boolean noRemainingCases() {
        return this.intros.isEmpty();
    }

    @Override
    public boolean singleton() {
        return this.intros.size() == 1;
    }

    @Override
    public FunctionIntro onlyIntro() {
        if (!this.singleton()) {
            throw new RuntimeException("Can only get intro for singleton");
        }
        return this.intros.get(0);
    }

    @Override
    public boolean contains(FunctionIntro fi) {
        if (fi == null) {
            return true;
        }
        if (this.intros.size() == 1 && this.intros.get(0) == null) {
            return true;
        }
        return this.intros.contains(fi);
    }

    @Override
    public HSICases retain(List<FunctionIntro> intros) {
        ArrayList<FunctionIntro> intersect = new ArrayList<FunctionIntro>(this.intros);
        if (intros.size() != 1 || intros.get(0) != null) {
            intersect.retainAll(intros);
        }
        return new FunctionHSICases(intersect);
    }

    @Override
    public HSICases alsoConsider(List<FunctionIntro> bi) {
        if (bi == null || bi.isEmpty()) {
            return this;
        }
        ArrayList<FunctionIntro> all = new ArrayList<FunctionIntro>(this.intros);
        for (FunctionIntro fi : bi) {
            if (all.contains(fi)) continue;
            all.add(fi);
        }
        return new FunctionHSICases(all);
    }

    @Override
    public void remove(HSICases unwanted) {
        List<FunctionIntro> other = ((FunctionHSICases)unwanted).intros;
        this.intros.removeAll(other);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FunctionIntro i : this.intros) {
            sb.append(i.name().name + " ");
        }
        return sb.toString().trim();
    }
}

