/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.repository.DontConsiderAgain;
import org.flasck.flas.repository.FunctionHSICases;
import org.flasck.flas.repository.Traverser;
import org.zinutils.exceptions.InvalidUsageException;

public class BackupPlan {
    private final Traverser.VarMapping vars;
    private final String indent;
    private final List<Slot> slots;
    private final List<FunctionIntro> intros = new ArrayList<FunctionIntro>();

    public BackupPlan() {
        this.vars = null;
        this.indent = null;
        this.slots = null;
    }

    public BackupPlan(Traverser.VarMapping vars, String indent, List<Slot> slots) {
        this.vars = vars;
        this.indent = indent;
        this.slots = slots;
    }

    public boolean hasNone() {
        return this.intros.isEmpty();
    }

    public int size() {
        return this.intros.size();
    }

    public boolean hasHope() {
        return !this.intros.isEmpty();
    }

    public FunctionIntro singleton() {
        if (this.intros.size() != 1) {
            throw new InvalidUsageException("only call singleton when you have one intro and no more slots");
        }
        return this.intros.get(0);
    }

    public void backup(Traverser traverser, DontConsiderAgain dca) {
        Traverser.hsiLogger.info(this.indent + "invoking backup plan with " + this.slots + " " + dca + " " + this.vars);
        traverser.visitHSI(this.vars, this.indent, this.slots, new FunctionHSICases(this.intros), null, new BackupPlan(), dca);
    }

    public String toString() {
        return "Slots" + (this.slots == null ? "[]" : this.slots.toString()) + " " + this.intros.size();
    }

    public void allows(List<FunctionIntro> addMore) {
        for (FunctionIntro fi : addMore) {
            if (this.intros.contains(fi)) continue;
            this.intros.add(fi);
        }
    }
}

