/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.repository;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.compiler.jsgen.packaging.JSEnvironment;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.assembly.Assembly;
import org.flasck.flas.repository.AssemblyVisitor;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.splitter.SplitMetaData;
import org.zinutils.bytecode.ByteCodeEnvironment;
import org.zinutils.exceptions.NotImplementedException;

public class AssemblyTraverser
implements AssemblyVisitor {
    public static final Logger logger = LoggerFactory.getLogger((String)"assembler");
    private final ErrorReporter errors;
    private final JSEnvironment jse;
    private final ByteCodeEnvironment bce;
    private final AssemblyVisitor v;

    public AssemblyTraverser(ErrorReporter errors, JSEnvironment jse, ByteCodeEnvironment bce, AssemblyVisitor v) {
        this.errors = errors;
        this.jse = jse;
        this.bce = bce;
        this.v = v;
    }

    public void doTraversal(Repository repository) {
        for (RepositoryEntry e : repository.dict.values()) {
            this.visitEntry(repository, e);
        }
        try {
            this.traversalDone();
        }
        catch (Exception ex) {
            logger.error("Error uploading", (Throwable)ex);
            this.errors.message((InputPosition)null, "error uploading assembly: " + ex);
        }
    }

    public void traverse(Repository repository, Assembly asm) {
        this.visitEntry(repository, asm);
        try {
            this.traversalDone();
        }
        catch (Exception ex) {
            logger.error("Error uploading", (Throwable)ex);
            this.errors.message((InputPosition)null, "error uploading assembly: " + ex);
        }
    }

    private void visitWebInfo(SplitMetaData w) {
        try (ZipInputStream zis = w.processedZip();){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                long length;
                String name = ze.getName();
                if (name.startsWith("cards/")) {
                    if (name.endsWith(".html")) {
                        length = w.getLength(name);
                        this.visitCardTemplate(name.replace(".html", ""), zis, length);
                        continue;
                    }
                    if (name.endsWith(".json")) continue;
                    throw new NotImplementedException("cannot handle " + name);
                }
                if (name.startsWith("items/")) {
                    if (name.endsWith(".html")) {
                        length = w.getLength(name);
                        this.visitCardTemplate(name.replace(".html", ""), zis, length);
                        continue;
                    }
                    if (name.endsWith(".json")) continue;
                    throw new NotImplementedException("cannot handle " + name);
                }
                if (name.endsWith(".css")) {
                    this.visitCSS(name, zis, ze.getSize());
                    continue;
                }
                this.visitResource(name, zis);
            }
        }
        catch (Exception ex) {
            logger.error("Error uploading", (Throwable)ex);
            this.errors.message((InputPosition)null, "error uploading web elements: " + ex);
        }
    }

    private void visitEntry(Repository repository, RepositoryEntry e) {
        if (e instanceof Assembly) {
            this.traverseAssemblyWithWebs(repository, (Assembly)e);
        }
    }

    public void traverseAssemblyWithWebs(Repository repository, Assembly a) {
        try {
            this.visitAssembly(a);
            for (ContentObject co : this.jse.jsIncludes("live")) {
                this.includePackageFile(co);
            }
            for (String s : this.jse.packageStrings()) {
                if (s.contains("_ut_") || s.contains("_st_") || s.endsWith("_ut") || s.endsWith("_st")) continue;
                logger.info("have package " + s);
                this.visitPackage(s);
                this.uploadJar(this.bce, s);
            }
            Iterable<SplitMetaData> allWebs = repository.allWebs();
            for (SplitMetaData w : allWebs) {
                this.visitWebInfo(w);
            }
            this.leaveAssembly(a);
        }
        catch (Exception ex) {
            logger.error("Error uploading", (Throwable)ex);
            this.errors.message((InputPosition)null, "error uploading assembly: " + ex);
        }
    }

    @Override
    public void uploadJar(ByteCodeEnvironment bce, String s) {
        this.v.uploadJar(bce, s);
    }

    @Override
    public void visitAssembly(Assembly a) {
        this.v.visitAssembly(a);
    }

    @Override
    public void includePackageFile(ContentObject co) {
        this.v.includePackageFile(co);
    }

    @Override
    public void visitPackage(String pkg) {
        this.v.visitPackage(pkg);
    }

    @Override
    public void visitCardTemplate(String replace, InputStream zis, long length) throws IOException {
        this.v.visitCardTemplate(replace, zis, length);
    }

    @Override
    public void visitCSS(String name, ZipInputStream zis, long length) throws IOException {
        this.v.visitCSS(name, zis, length);
    }

    @Override
    public void visitResource(String name, ZipInputStream zis) throws IOException {
        this.v.visitResource(name, zis);
    }

    @Override
    public void leaveAssembly(Assembly a) throws IOException {
        this.v.leaveAssembly(a);
    }

    @Override
    public void traversalDone() throws Exception {
        this.v.traversalDone();
    }
}

