/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.patterns;

import org.flasck.flas.commonBase.ConstPattern;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ConstructorMatch;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.patterns.HSIArgsTree;
import org.flasck.flas.patterns.HSICtorTree;
import org.flasck.flas.patterns.HSIOptions;
import org.flasck.flas.patterns.HSITree;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.Primitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;

public class PatternAnalyzer
extends LeafAdapter {
    public static final Logger logger = LoggerFactory.getLogger((String)"Patterns");
    private HSITree hsiTree;
    private final NestedVisitor sv;
    private int nslot;
    private HSIOptions slot;
    private FunctionIntro current;
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private String ind;

    public PatternAnalyzer(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.ind = "";
        sv.push(this);
    }

    public PatternAnalyzer(ErrorReporter errors, RepositoryReader repository, NestedVisitor sv, HSITree tree, FunctionIntro current, String ind) {
        this.errors = errors;
        this.repository = repository;
        this.sv = sv;
        this.hsiTree = tree;
        this.current = current;
        this.ind = ind;
        sv.push(this);
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        logger.info(this.ind + "analyzing " + fn.name().uniqueName() + " with " + fn.argCount() + " total patterns");
        this.hsiTree = new HSIArgsTree(fn.argCount());
    }

    @Override
    public void visitObjectMethod(ObjectMethod meth) {
        int quant = meth.argCount() + (meth.handler != null ? 1 : 0);
        logger.info(this.ind + "analyzing " + meth.name().uniqueName() + " with " + quant + " total patterns");
        this.hsiTree = new HSIArgsTree(quant);
        this.nslot = 0;
        this.current = null;
        this.hsiTree.consider(null);
    }

    @Override
    public void visitObjectCtor(ObjectCtor meth) {
        logger.info(this.ind + "analyzing " + meth.name().uniqueName() + " with " + meth.argCount() + " total patterns");
        this.hsiTree = new HSIArgsTree(meth.argCount());
        this.nslot = 0;
        this.current = null;
        this.hsiTree.consider(null);
    }

    @Override
    public void visitFunctionIntro(FunctionIntro fi) {
        this.nslot = 0;
        this.current = fi;
        this.hsiTree.consider(fi);
        logger.info(this.ind + "considering intro " + fi.name().uniqueName());
        this.ind = this.ind + "  ";
    }

    @Override
    public void visitPattern(Pattern patt, boolean isNested) {
        this.slot = this.hsiTree.get(this.nslot++);
    }

    @Override
    public void visitVarPattern(VarPattern p, boolean isNested) {
        logger.info(this.ind + "var " + p.var);
        this.slot.addVar(p, this.current);
        this.slot.includes(this.current);
    }

    @Override
    public void visitTypedPattern(TypedPattern p, boolean isNested) {
        logger.info(this.ind + (isNested ? "nested " : "") + "typed var " + p.type + " " + p.var.uniqueName());
        if (!isNested) {
            this.slot.addTyped(p, this.current);
        } else {
            this.slot.addVarWithType(p.type, p.var, this.current);
        }
        this.slot.includes(this.current);
    }

    @Override
    public void visitConstructorMatch(ConstructorMatch p, boolean isNested) {
        logger.info(this.ind + "nesting constructor match for " + p.actual());
        HSICtorTree nested = this.slot.requireCM(p.actual());
        nested.consider(this.current);
        new PatternAnalyzer(this.errors, this.repository, this.sv, nested, this.current, this.ind + "  ");
    }

    @Override
    public void visitConstructorField(String field, Pattern patt, boolean isNested) {
        this.slot = ((HSICtorTree)this.hsiTree).field(field);
        this.slot.includes(this.current);
    }

    @Override
    public void leaveConstructorMatch(ConstructorMatch p) {
        logger.info(this.ind.substring(2) + "done matching constructor " + p.actual());
        this.sv.result(this.hsiTree);
    }

    @Override
    public void visitConstPattern(ConstPattern p, boolean isNested) {
        this.slot.addConstant(switch (p.type) {
            case 1 -> (Primitive)this.repository.get("Number");
            case 3 -> (Primitive)this.repository.get("String");
            default -> throw new NotImplementedException("Cannot handle " + p.type);
        }, p.value, this.current);
        this.slot.includes(this.current);
    }

    @Override
    public void leaveFunctionIntro(FunctionIntro fi) {
        fi.bindTree(this.hsiTree);
        this.ind = this.ind.substring(2);
    }

    @Override
    public void leaveFunction(FunctionDefinition fn) {
        logger.info(this.ind + "analyzed " + fn.name().uniqueName());
        fn.bindHsi(this.hsiTree);
    }

    @Override
    public void leaveObjectMethod(ObjectMethod meth) {
        logger.info(this.ind + "analyzed " + meth.name().uniqueName());
        meth.bindHsi(this.hsiTree);
    }

    @Override
    public void leaveObjectCtor(ObjectCtor meth) {
        logger.info(this.ind + "analyzed " + meth.name().uniqueName());
        meth.bindHsi(this.hsiTree);
    }
}

