/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.patterns;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.patterns.HSICtorTree;
import org.flasck.flas.patterns.HSIOptions;
import org.flasck.flas.patterns.HSITree;
import org.flasck.flas.repository.FunctionHSICases;
import org.flasck.flas.repository.HSICases;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.utils.IntegerComparator;
import org.zinutils.utils.StringComparator;

public class HSIPatternOptions
implements HSIOptions {
    private List<FunctionIntro> all = new ArrayList<FunctionIntro>();
    private List<TV> vars = new ArrayList<TV>();
    private Map<NamedType, TV> types = new TreeMap<NamedType, TV>(NamedType.nameComparator);
    private Map<StructDefn, HSICtorTree> ctors = new TreeMap<NamedType, HSICtorTree>(NamedType.nameComparator);
    private ListMap<Integer, FunctionIntro> numericConstants = new ListMap((Comparator)new IntegerComparator());
    private ListMap<String, FunctionIntro> stringConstants = new ListMap((Comparator)new StringComparator());
    private boolean container;

    @Override
    public List<String> introNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (FunctionIntro i : this.all) {
            if (i == null) {
                ret.add("null");
                continue;
            }
            ret.add(i.name().uniqueName());
        }
        return ret;
    }

    @Override
    public boolean isContainer() {
        return this.container;
    }

    @Override
    public NamedType containerType() {
        return this.vars.get((int)0).type;
    }

    @Override
    public void includes(FunctionIntro fi) {
        if (!this.all.contains(fi)) {
            this.all.add(fi);
        }
    }

    @Override
    public HSICtorTree requireCM(StructDefn ctor) {
        if (!this.ctors.containsKey(ctor)) {
            this.ctors.put(ctor, new HSICtorTree());
        }
        return this.ctors.get(ctor);
    }

    @Override
    public void addTyped(TypedPattern tp, FunctionIntro fi) {
        NamedType td = tp.type.namedDefn();
        if (td == null) {
            throw new RuntimeException("No definition in " + tp.type);
        }
        if (td instanceof PolyInstance) {
            td = ((PolyInstance)td).struct();
        }
        if (!this.types.containsKey(td)) {
            this.types.put(td, new TV(tp));
        }
        this.types.get((Object)td).intros.add(fi);
    }

    @Override
    public void addVar(VarPattern vp, FunctionIntro fi) {
        TV tv = new TV(null, vp);
        tv.intros.add(fi);
        this.vars.add(tv);
    }

    @Override
    public void addVarWithType(TypeReference tr, VarName varName, FunctionIntro fi) {
        TV tv = new TV(tr.namedDefn(), varName);
        tv.intros.add(fi);
        this.vars.add(tv);
        if (varName.baseName().equals("_this")) {
            this.container = true;
        }
    }

    @Override
    public void addConstant(Primitive type, String value, FunctionIntro fi) {
        if (!this.types.containsKey(type)) {
            this.types.put(type, new TV((NamedType)type, (VarName)null));
        }
        this.types.get((Object)type).intros.add(fi);
        if (type.name().uniqueName().equals("Number")) {
            this.numericConstants.add((Object)Integer.parseInt(value), (Object)fi);
        } else if (type.name().uniqueName().equals("String")) {
            this.stringConstants.add((Object)value, (Object)fi);
        } else {
            throw new NotImplementedException("Cannot handle const of type " + type);
        }
    }

    @Override
    public HSITree getCM(StructDefn constructor) {
        return this.ctors.get(constructor);
    }

    @Override
    public List<FunctionIntro> getIntrosForType(NamedType ty) {
        while (ty instanceof PolyInstance) {
            ty = ((PolyInstance)ty).struct();
        }
        return this.types.get((Object)ty).intros;
    }

    @Override
    public List<FunctionIntro> getIntrosForString(String s) {
        return this.stringConstants.get((Object)s);
    }

    @Override
    public List<FunctionIntro> getIntrosForNumber(int n) {
        return this.numericConstants.get((Object)n);
    }

    @Override
    public List<NamedType> unionsIncluding(StructDefn c) {
        ArrayList<NamedType> ret = new ArrayList<NamedType>();
        for (NamedType t : this.types.keySet()) {
            if (t instanceof PolyInstance) {
                throw new CantHappenException("I don't think PolyInstances should be in the key");
            }
            if (!(t instanceof UnionTypeDefn) || ((UnionTypeDefn)t).findCase(c.name().uniqueName()) == null) continue;
            ret.add(t);
        }
        return ret;
    }

    @Override
    public List<FunctionIntro> getDefaultIntros(HSICases cases) {
        ArrayList<FunctionIntro> ret = new ArrayList<FunctionIntro>(this.all);
        for (HSICtorTree ct : this.ctors.values()) {
            ret.removeAll(ct.intros());
        }
        for (TV tv : this.types.values()) {
            ret.removeAll(tv.intros);
        }
        return ret;
    }

    @Override
    public Set<StructDefn> ctors() {
        return this.ctors.keySet();
    }

    @Override
    public List<HSIOptions.IntroTypeVar> typedVars(NamedType ty) {
        TV tv = this.types.get(ty);
        ArrayList<HSIOptions.IntroTypeVar> ret = new ArrayList<HSIOptions.IntroTypeVar>();
        for (FunctionIntro intro : tv.intros) {
            HSIOptions.IntroTypeVar itv = tv.tp != null ? new HSIOptions.IntroTypeVar(intro, tv.tp) : new HSIOptions.IntroTypeVar(intro, tv.type);
            ret.add(itv);
        }
        return ret;
    }

    @Override
    public List<HSIOptions.IntroVarName> vars() {
        ArrayList<HSIOptions.IntroVarName> ret = new ArrayList<HSIOptions.IntroVarName>();
        for (TV v : this.vars) {
            if (v.intros.size() != 1) {
                throw new CantHappenException("There should only be one intro left");
            }
            HSIOptions.IntroVarName iv = v.vp != null ? new HSIOptions.IntroVarName(v.intros.get(0), v.vp) : new HSIOptions.IntroVarName(v.intros.get(0), v.var);
            ret.add(iv);
        }
        return ret;
    }

    @Override
    public List<HSIOptions.IntroVarName> vars(HSICases intros) {
        ArrayList<HSIOptions.IntroVarName> ret = new ArrayList<HSIOptions.IntroVarName>();
        this.addVars(ret, intros, this.vars);
        this.addVars(ret, intros, this.types.values());
        return ret;
    }

    private void addVars(List<HSIOptions.IntroVarName> ret, HSICases intros, Collection<TV> list) {
        for (TV v : list) {
            for (FunctionIntro i : ((FunctionHSICases)intros).intros) {
                if (!v.isCompatibleIntro(i) || v.var == null) continue;
                ret.add(new HSIOptions.IntroVarName(i, v.var));
            }
        }
    }

    @Override
    public Set<Integer> numericConstants(HSICases intersect) {
        return this.numericConstants.keySet();
    }

    @Override
    public Set<String> stringConstants(HSICases intersect) {
        return this.stringConstants.keySet();
    }

    @Override
    public Set<NamedType> types() {
        return this.types.keySet();
    }

    @Override
    public boolean hasSwitches(HSICases intros) {
        for (HSITree hSITree : this.ctors.values()) {
            if (!hSITree.containsAny(intros)) continue;
            return true;
        }
        for (TV tV : this.types.values()) {
            if (!tV.containsAny(intros)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int score() {
        int score = this.types.size() + this.ctors.size() * 3;
        if (this.types.containsKey(LoadBuiltins.any)) {
            --score;
        }
        return score;
    }

    @Override
    public void dump(String indent) {
        boolean spoken = false;
        for (Map.Entry<StructDefn, HSICtorTree> entry : this.ctors.entrySet()) {
            System.out.println(indent + "ctor " + entry.getKey().signature() + ":");
            entry.getValue().dump(indent + "  ");
            spoken = true;
        }
        for (Map.Entry<NamedType, Object> entry : this.types.entrySet()) {
            System.out.println(indent + "type " + entry.getKey().signature() + ":" + ((TV)entry.getValue()).intros);
            spoken = true;
        }
        if (!spoken) {
            System.out.println(indent + "all: " + this.all);
        }
    }

    class TV {
        NamedType type;
        TypedPattern tp;
        VarPattern vp;
        VarName var;
        List<FunctionIntro> intros = new ArrayList<FunctionIntro>();

        public TV(TypedPattern tp) {
            this.type = tp.type.namedDefn();
            this.tp = tp;
            this.var = tp.var;
        }

        public TV(NamedType type, VarPattern vp) {
            this.type = type;
            this.vp = vp;
            this.var = vp.name();
        }

        public TV(NamedType type, VarName var) {
            this.type = type;
            this.var = var;
        }

        public boolean containsAny(HSICases curr) {
            for (FunctionIntro fi : this.intros) {
                if (!curr.contains(fi)) continue;
                return true;
            }
            return false;
        }

        public boolean isCompatibleIntro(FunctionIntro i) {
            if (this.intros.size() == 1 && this.intros.get(0) == null) {
                return true;
            }
            return this.intros.contains(i);
        }
    }
}

