/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.patterns;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.patterns.HSIOptions;
import org.flasck.flas.patterns.HSIPatternOptions;
import org.flasck.flas.patterns.HSIPatternTree;
import org.flasck.flas.patterns.HSITree;
import org.zinutils.collections.CollectionUtils;

public class HSICtorTree
extends HSIPatternTree {
    protected Map<String, HSIOptions> slots = new TreeMap<String, HSIOptions>();

    @Override
    public int width() {
        return this.slots.size();
    }

    public String slot(int i) {
        return (String)CollectionUtils.nth(this.slots.keySet(), (int)i);
    }

    @Override
    public HSITree consider(FunctionIntro fi) {
        super.consider(fi);
        for (HSIOptions o : this.slots.values()) {
            o.includes(fi);
        }
        return this;
    }

    public HSIOptions field(String field) {
        if (!this.slots.containsKey(field)) {
            HSIPatternOptions hpo = new HSIPatternOptions();
            for (FunctionIntro fi : this.intros) {
                hpo.includes(fi);
            }
            this.slots.put(field, hpo);
        }
        return this.slots.get(field);
    }

    public String getField(int i) {
        String ret;
        Iterator<String> it = this.slots.keySet().iterator();
        do {
            ret = it.next();
        } while (i-- != 0);
        return ret;
    }

    @Override
    public HSIOptions get(int i) {
        HSIOptions ret;
        Iterator<HSIOptions> it = this.slots.values().iterator();
        do {
            ret = it.next();
        } while (i-- != 0);
        return ret;
    }

    @Override
    public void dump(String indent) {
        boolean spoken = false;
        for (Map.Entry<String, HSIOptions> i : this.slots.entrySet()) {
            System.out.println(indent + i.getKey() + ":");
            i.getValue().dump(indent + "  ");
            spoken = true;
        }
        if (!spoken) {
            System.out.println(indent + "<default>: " + this.intros);
        }
    }
}

