/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.ut;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.TargetZone;
import org.flasck.flas.parsedForm.TemplateReference;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.ut.MatchedItem;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.ParenExprConsumer;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.ut.FreeTextParser;
import org.flasck.flas.parser.ut.SingleExpressionParser;
import org.flasck.flas.parser.ut.TDAUnitTestDataParser;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.parser.ut.UnitDataNamer;
import org.flasck.flas.parser.ut.UnitTestDefinitionConsumer;
import org.flasck.flas.parser.ut.UnitTestStepConsumer;
import org.flasck.flas.stories.TDAMultiParser;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tokenizers.EventZoneToken;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.FreeTextToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PuncToken;
import org.flasck.flas.tokenizers.TemplateNameToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.collections.TriConsumer;

public class TestStepParser
extends BlockLocationTracker
implements TDAParsing {
    protected final UnitTestStepConsumer builder;
    protected final UnitDataNamer namer;
    private final UnitTestDefinitionConsumer topLevel;

    public TestStepParser(ErrorReporter errors, UnitDataNamer namer, UnitTestStepConsumer builder, UnitTestDefinitionConsumer topLevel, LocationTracker locTracker) {
        super(errors, locTracker);
        this.namer = namer;
        this.builder = builder;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        int mark = toks.at();
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.updateLoc(kw.location);
        switch (kw.text) {
            case "assert": {
                return this.handleAssert(kw, toks);
            }
            case "identical": {
                return this.handleIdentical(kw, toks);
            }
            case "shove": {
                return this.handleShove(kw, toks);
            }
            case "close": {
                return this.closeCard(kw, toks);
            }
            case "contract": {
                return this.handleSendToContract(kw, toks);
            }
            case "data": {
                return this.handleDataDecl(kw, toks);
            }
            case "newdiv": {
                return this.handleNewdiv(kw, toks);
            }
            case "render": {
                return this.handleRender(kw, toks);
            }
            case "event": {
                return this.handleEvent(kw, toks);
            }
            case "input": {
                return this.handleInput(kw, toks);
            }
            case "invoke": {
                return this.handleInvoke(kw, toks);
            }
            case "expect": {
                return this.handleExpect(kw, toks);
            }
            case "match": {
                return this.handleMatch(kw, toks);
            }
        }
        toks.reset(mark);
        this.errors.message(toks, "unrecognized test step " + kw.text);
        return new IgnoreNestedParser(this.errors);
    }

    protected TDAParsing handleAssert(KeywordToken kw, Tokenizable toks) {
        ArrayList test = new ArrayList();
        ParenExprConsumer pec = new ParenExprConsumer(x -> test.add(x));
        TDAExpressionParser expr = new TDAExpressionParser(this.errors, pec);
        expr.tryParsing(toks);
        if (this.errors.hasErrors()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (test.isEmpty()) {
            this.errors.message(toks, "assert requires expression to evaluate");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("ut-assert-expr", kw.location, pec.location());
        Consumer<Expr> exprConsumer = ex -> {
            this.builder.assertion((Expr)test.get(0), (Expr)ex);
            this.updateLoc(ex.location());
            this.errors.logReduction("ut-assert-expected-value", (Locatable)ex, (Locatable)ex);
            this.reduce(kw.location, "unit-test-assert");
        };
        return new SingleExpressionParser(this.errors, "assert", exprConsumer, this);
    }

    protected TDAParsing handleIdentical(KeywordToken kw, Tokenizable toks) {
        ArrayList test = new ArrayList();
        TDAExpressionParser expr = new TDAExpressionParser(this.errors, x -> test.add(x));
        expr.tryParsing(toks);
        if (this.errors.hasErrors()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (test.isEmpty()) {
            this.errors.message(toks, "identical requires expression to evaluate");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("ut-identical-expr", kw.location, ((Expr)test.get(0)).location());
        Consumer<Expr> exprConsumer = ex -> {
            this.builder.identical((Expr)test.get(0), (Expr)ex);
            this.updateLoc(ex.location());
            this.errors.logReduction("ut-identical-expected-value", (Locatable)ex, (Locatable)ex);
            this.reduce(kw.location, "unit-test-identical");
        };
        return new SingleExpressionParser(this.errors, "identical", exprConsumer, this);
    }

    protected TDAParsing handleShove(KeywordToken kw, Tokenizable toks) {
        UnresolvedVar firstMPV;
        ArrayList<UnresolvedVar> slots;
        block8: {
            slots = new ArrayList<UnresolvedVar>();
            PuncToken haveDot = null;
            firstMPV = null;
            while (true) {
                PuncToken dot;
                ExprToken tok;
                if ((tok = ExprToken.from(this.errors, toks)) == null || tok.type != 1) {
                    this.errors.message(toks, "field path expected");
                    return new IgnoreNestedParser(this.errors);
                }
                UnresolvedVar v = new UnresolvedVar(tok.location, tok.text);
                slots.add(v);
                if (haveDot != null) {
                    if (firstMPV == null) {
                        firstMPV = v;
                    } else {
                        this.errors.logReduction("member-path-apply", haveDot, v);
                    }
                }
                if ((dot = PuncToken.from(this.errors, toks)) == null) {
                    if (haveDot == null) {
                        this.errors.message(toks, ". expected");
                        return new IgnoreNestedParser(this.errors);
                    }
                    break block8;
                }
                if (!".".equals(dot.text)) break;
                haveDot = dot;
            }
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        UnresolvedVar last = (UnresolvedVar)slots.get(slots.size() - 1);
        this.errors.logReduction("member-path", firstMPV, last);
        this.errors.logReduction("test-step-shove", kw, last);
        Consumer<Expr> exprConsumer = expr -> {
            this.builder.shove((List<UnresolvedVar>)slots, (Expr)expr);
            this.updateLoc(expr.location());
            this.errors.logReduction("ut-shove-expected-expr", expr.location(), expr.location());
            this.reduce(kw.location, "unit-test-shove");
        };
        return new SingleExpressionParser(this.errors, "shove", exprConsumer, this);
    }

    protected TDAParsing handleSendToContract(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "contract requires a card variable to send the event to");
            return new IgnoreNestedParser(this.errors);
        }
        TypeNameToken evname = TypeNameToken.qualified(this.errors, toks);
        if (evname == null) {
            this.errors.message(toks, "contract requires a Contract name");
            return new IgnoreNestedParser(this.errors);
        }
        Tokenizable ec = toks.copyTo("->");
        ArrayList eventObj = new ArrayList();
        TDAExpressionParser expr = new TDAExpressionParser(this.errors, x -> eventObj.add(x));
        expr.tryParsing(ec);
        if (this.errors.hasErrors()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (eventObj.isEmpty()) {
            this.errors.message(toks, "missing method call");
            return new IgnoreNestedParser(this.errors);
        }
        if (ec == toks && toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        if (ec != toks) {
            toks.reset(ec.at());
            ExprToken arrow = ExprToken.from(this.errors, toks);
            if (arrow == null) {
                this.errors.message(toks, "expected ->");
                return new NoNestingParser(this.errors);
            }
            ExprToken name = ExprToken.from(this.errors, toks);
            if (name == null) {
                this.errors.message(toks, "expected var to store in");
                return new NoNestingParser(this.errors);
            }
            if (name.type != 1) {
                this.errors.message(name.location, "expected var");
                return new NoNestingParser(this.errors);
            }
            UnresolvedVar handler = new UnresolvedVar(name.location, name.text);
            this.errors.logReduction("unit-contract-handle-expr", arrow, handler);
            this.errors.logReduction("unit-contract-action-with-handle", kw, arrow);
            this.builder.sendOnContract(new UnresolvedVar(tok.location, tok.text), new TypeReference(evname.location, evname.text, new TypeReference[0]), (Expr)eventObj.get(0), handler);
        } else {
            this.errors.logReduction("unit-contract-action", kw, (Locatable)eventObj.get(0));
            this.builder.sendOnContract(new UnresolvedVar(tok.location, tok.text), new TypeReference(evname.location, evname.text, new TypeReference[0]), (Expr)eventObj.get(0), null);
        }
        this.tellParent(kw.location);
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing closeCard(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "close requires a card variable to close");
            return new IgnoreNestedParser(this.errors);
        }
        this.builder.closeCard(new UnresolvedVar(tok.location, tok.text));
        this.errors.logReduction("unit-test-close-card", kw.location, tok.location);
        this.tellParent(kw.location);
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing handleDataDecl(KeywordToken kw, Tokenizable toks) {
        Consumer<UnitDataDeclaration> consumer = dd -> {
            this.builder.data(this.errors, (UnitDataDeclaration)dd);
            this.topLevel.nestedData((UnitDataDeclaration)dd);
            this.tellParent(kw.location());
        };
        return new TDAUnitTestDataParser(this.errors, false, kw, this.namer, consumer, this.topLevel, this).tryParsing(toks);
    }

    protected TDAParsing handleNewdiv(KeywordToken kw, Tokenizable toks) {
        Integer cnt = null;
        InputPosition cntLoc = null;
        if (toks.hasMoreContent(this.errors)) {
            ExprToken tok = ExprToken.from(this.errors, toks);
            if (tok.type != 2) {
                this.errors.message(toks, "integer required");
                return new IgnoreNestedParser(this.errors);
            }
            cntLoc = tok.location;
            try {
                cnt = Integer.parseInt(tok.text);
            }
            catch (NumberFormatException ex) {
                this.errors.message(toks, "integer required");
                return new IgnoreNestedParser(this.errors);
            }
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.builder.newdiv(cnt);
        if (cntLoc != null) {
            this.errors.logReduction("test-newdiv-cnt", kw.location, cntLoc);
        } else {
            this.errors.logReduction("test-newdiv", kw.location, kw.location);
        }
        this.tellParent(kw.location);
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing handleRender(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "must specify a card to be rendered");
            return new IgnoreNestedParser(this.errors);
        }
        ExprToken arrow = ExprToken.from(this.errors, toks);
        if (arrow == null || !"=>".equals(arrow.text)) {
            this.errors.message(toks, "=> expected");
            return new IgnoreNestedParser(this.errors);
        }
        TemplateNameToken template = TemplateNameToken.from(this.errors, toks);
        if (template == null) {
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("test-render", kw.location, template.location);
        this.builder.render(new UnresolvedVar(tok.location, tok.text), new TemplateReference(template.location, this.namer.template(template.location, template.text)));
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing handleEvent(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "must specify a card to receive event");
            return new IgnoreNestedParser(this.errors);
        }
        TargetZone targetZone = this.parseTargetZone(toks);
        if (targetZone == null) {
            return new IgnoreNestedParser(this.errors);
        }
        ErrorMark em = this.errors.mark();
        ArrayList eventObj = new ArrayList();
        TDAExpressionParser expr = new TDAExpressionParser(this.errors, x -> eventObj.add(x));
        expr.tryParsing(toks);
        if (em.hasMoreNow()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (eventObj.isEmpty()) {
            this.errors.message(toks, "must provide an event object");
            return new IgnoreNestedParser(this.errors);
        }
        if (eventObj.size() > 1) {
            this.errors.message(toks, "only one event object is allowed");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.builder.event(new UnresolvedVar(tok.location, tok.text), targetZone, (Expr)eventObj.get(0));
        this.errors.logReduction("unit-event-action", kw.location, ((Expr)eventObj.get(0)).location());
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing handleInput(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken tok = VarNameToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "must specify a card to receive event");
            return new IgnoreNestedParser(this.errors);
        }
        TargetZone targetZone = this.parseTargetZone(toks);
        if (targetZone == null) {
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("ut-input-line", kw.location, targetZone.location);
        this.updateLoc(kw.location);
        Consumer<Expr> exprConsumer = text -> {
            this.builder.input(new UnresolvedVar(tok.location, tok.text), targetZone, (Expr)text);
            this.updateLoc(text.location());
            this.errors.logReduction("ut-input-entry-value", (Locatable)text, (Locatable)text);
            this.reduce(kw.location, "unit-test-input");
        };
        return new SingleExpressionParser(this.errors, "input", exprConsumer, this);
    }

    protected TDAParsing handleInvoke(KeywordToken kw, Tokenizable toks) {
        ArrayList eventObj = new ArrayList();
        TDAExpressionParser expr = new TDAExpressionParser(this.errors, x -> eventObj.add(x));
        expr.tryParsing(toks);
        if (this.errors.hasErrors()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (eventObj.isEmpty()) {
            this.errors.message(toks, "missing expression");
            return new IgnoreNestedParser(this.errors);
        }
        InputPosition lastLoc = ((Expr)eventObj.get(eventObj.size() - 1)).location();
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("unit-invoke-action", kw.location, lastLoc);
        this.tellParent(kw.location);
        this.builder.invokeObjectMethod((Expr)eventObj.get(0));
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing handleExpect(KeywordToken kw, Tokenizable toks) {
        Expr handler;
        ValidIdentifierToken svc = VarNameToken.from(this.errors, toks);
        if (svc == null) {
            ExprToken tok = ExprToken.from(this.errors, toks);
            if (tok != null && tok.type == 4) {
                if (tok.text.equals("<~")) {
                    return this.handleExpectCancel(kw, toks);
                }
                this.errors.message(toks, "invalid expect operator " + tok.text);
                return new IgnoreNestedParser(this.errors);
            }
            this.errors.message(toks, "missing contract");
            return new IgnoreNestedParser(this.errors);
        }
        String ih = "";
        ValidIdentifierToken meth = VarNameToken.from(this.errors, toks);
        if (meth == null) {
            this.errors.message(toks, "missing method");
            return new IgnoreNestedParser(this.errors);
        }
        InputPosition lastLoc = meth.location;
        Tokenizable ec = toks.copyTo("->");
        ArrayList args = new ArrayList();
        TDAExpressionParser expr = new TDAExpressionParser(this.errors, this.namer, x -> args.add(x), false, this.topLevel);
        expr.tryParsing(ec);
        if (this.errors.hasErrors()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (!args.isEmpty()) {
            lastLoc = ((Expr)args.get(args.size() - 1)).location();
        }
        if (ec != toks) {
            toks.reset(ec.at());
            ExprToken arrow = ExprToken.from(this.errors, toks);
            if (arrow == null) {
                this.errors.message(toks, "expected ->");
                return new IgnoreNestedParser(this.errors);
            }
            ExprToken name = ExprToken.from(this.errors, toks);
            if (name == null) {
                this.errors.message(toks, "expected var to store in");
                return new IgnoreNestedParser(this.errors);
            }
            if (name.type != 1) {
                this.errors.message(name.location, "expected var");
                return new IgnoreNestedParser(this.errors);
            }
            if (!name.text.startsWith("_")) {
                this.errors.message(name.location, "introduce vars must start with _");
                return new IgnoreNestedParser(this.errors);
            }
            lastLoc = name.location;
            IntroduceVar iv = new IntroduceVar(name.location, this.namer, name.text.substring(1));
            this.topLevel.newIntroduction(this.errors, iv);
            handler = iv;
            this.errors.logReduction("unit-expect-introduce-handler", arrow, name);
            ih = "-introduce-handler";
        } else {
            handler = new AnonymousVar(meth.location);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("test-step-expect" + ih, kw.location, lastLoc);
        this.tellParent(kw.location);
        this.builder.expect(new UnresolvedVar(svc.location, svc.text), new UnresolvedVar(meth.location, meth.text), args.toArray(new Expr[args.size()]), handler);
        return new TDAParsingWithAction(new TDAMultiParser(this.errors, new TDAParserConstructor[0]), this.reduction(kw.location, "unit-test-expect"));
    }

    private TDAParsing handleExpectCancel(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken handler = VarNameToken.from(this.errors, toks);
        if (handler == null) {
            this.errors.message(toks, "handler name required");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("unit-test-cancel", kw.location, handler.location);
        this.builder.expectCancel(new UnresolvedVar(handler.location, handler.text));
        return new NoNestingParser(this.errors);
    }

    protected TDAParsing handleMatch(KeywordToken kw, Tokenizable toks) {
        ValidIdentifierToken card = VarNameToken.from(this.errors, toks);
        if (card == null) {
            this.errors.message(toks, "missing card");
            return new IgnoreNestedParser(this.errors);
        }
        KeywordToken whattok = KeywordToken.from(this.errors, toks);
        if (whattok == null) {
            this.errors.message(toks, "missing category");
            return new IgnoreNestedParser(this.errors);
        }
        MatchedItem what = new MatchedItem(whattok.text);
        this.tellParent(kw.location);
        TargetZone targetZoneTmp = new TargetZone(toks.realinfo(), new ArrayList<Object>());
        boolean containsTmp = false;
        boolean failsTmp = false;
        String withZone = "";
        String withType = "";
        InputPosition lastLoc = whattok.location;
        if (toks.hasMoreContent(this.errors)) {
            targetZoneTmp = this.parseTargetZone(toks);
            if (targetZoneTmp == null) {
                return new IgnoreNestedParser(this.errors);
            }
            lastLoc = targetZoneTmp.location;
            withZone = "-with-zone";
            KeywordToken option = KeywordToken.from(this.errors, toks);
            if (option != null) {
                lastLoc = option.location;
                withType = "-with-location-type";
                if ("contains".equals(option.text)) {
                    containsTmp = true;
                } else if ("fails".equals(option.text)) {
                    failsTmp = true;
                } else {
                    this.errors.message(option.location, "invalid match type specification");
                    return new IgnoreNestedParser(this.errors);
                }
            }
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "unexpected characters at end of match");
            return new IgnoreNestedParser(this.errors);
        }
        TargetZone targetZone = targetZoneTmp;
        boolean contains = containsTmp;
        boolean fails = failsTmp;
        this.errors.logReduction("unittest-match-command" + withZone + withType, kw.location, lastLoc);
        return new FreeTextParser(kw, this.errors, this, (lastPos, text) -> {
            this.reduce(kw.location, "unit-test-match");
            this.builder.match(new UnresolvedVar(card.location, card.text), what, targetZone, contains, fails, (FreeTextToken)text);
        });
    }

    public TargetZone parseTargetZone(Tokenizable toks) {
        InputPosition last;
        InputPosition first;
        int start;
        ArrayList<Object> tz;
        block24: {
            int mark;
            EventZoneToken tok;
            tz = new ArrayList<Object>();
            start = toks.at();
            first = null;
            last = null;
            InputPosition prevdot = null;
            boolean lastWasNumber = false;
            TriConsumer reduce = (s, f, t) -> {};
            while (true) {
                if ((tok = EventZoneToken.from(this.errors, toks)) == null) {
                    this.errors.message(toks, "valid target zone expected");
                    return null;
                }
                if (tok.type == 5) {
                    if (tz.isEmpty()) {
                        this.errors.logReduction("unit-test-target-zone", tok.location, tok.location().locAtEnd());
                        return new TargetZone(tok.location, new ArrayList<Object>());
                    }
                    this.errors.message(tok.location, "valid target zone expected");
                    return null;
                }
                if (tok.type == 1) {
                    if (prevdot != null) {
                        reduce = (opt, from, to) -> this.errors.logReduction("uttz-field" + opt, (InputPosition)from, (InputPosition)to);
                    }
                    tz.add(tok.text);
                    lastWasNumber = false;
                } else if (tok.type == 2) {
                    if (tz.isEmpty()) {
                        this.errors.message(tok.location, "first entry in target cannot be list index");
                        return null;
                    }
                    if (lastWasNumber) {
                        this.errors.message(tok.location, "cannot have consecutive list indices");
                        return null;
                    }
                    if (prevdot != null) {
                        reduce = (opt, from, to) -> this.errors.logReduction("uttz-index" + opt, (InputPosition)from, (InputPosition)to);
                    }
                    tz.add(Integer.parseInt(tok.text));
                    lastWasNumber = true;
                } else {
                    this.errors.message(tok.location, "valid target zone expected");
                    return null;
                }
                if (first == null) {
                    first = tok.location;
                }
                last = tok.location;
                if (!toks.hasMoreContent(this.errors)) {
                    reduce.accept((Object)"", prevdot, (Object)tok.location);
                } else {
                    mark = toks.at();
                    EventZoneToken dot = EventZoneToken.from(this.errors, toks);
                    if (dot == null) {
                        reduce.accept((Object)"", prevdot, (Object)tok.location);
                    } else {
                        if (dot.type == 3) {
                            reduce.accept((Object)"", prevdot, (Object)tok.location);
                            prevdot = dot.location;
                            continue;
                        }
                        if (dot.type != 4) break;
                        EventZoneToken qualifyingTemplate = EventZoneToken.from(this.errors, toks);
                        if (qualifyingTemplate == null) {
                            this.errors.message(dot.location, "target zone qualifier missing");
                            return null;
                        }
                        if (qualifyingTemplate.type != 1) {
                            this.errors.message(dot.location, "target zone qualifier must be a name");
                            return null;
                        }
                        this.errors.logReduction("uttz-qualifier", dot.location, qualifyingTemplate.location);
                        reduce.accept((Object)"-with-qualifier", (Object)prevdot, (Object)dot.location);
                        last = dot.location;
                        dot = EventZoneToken.from(this.errors, toks);
                        if (dot != null) {
                            if (dot.type != 3) {
                                this.errors.message(dot.location, "target zone qualifier must be last item or followed by field");
                                return null;
                            }
                            prevdot = dot.location;
                            tz.add(new TargetZone.Qualifier(qualifyingTemplate.location, qualifyingTemplate.text));
                            continue;
                        }
                    }
                }
                break block24;
                break;
            }
            reduce.accept((Object)"", (Object)prevdot, (Object)tok.location);
            toks.reset(mark);
        }
        if (tz.isEmpty()) {
            this.errors.message(toks, "valid target zone expected");
            return null;
        }
        if (tz.size() == 1 && "contains".equals(tz.get(0))) {
            toks.reset(start);
            return new TargetZone(first, new ArrayList<Object>());
        }
        this.errors.logReduction("unit-test-target-zone", first, last);
        return new TargetZone(first, tz);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

