/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.ut;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ut.UnitTestCase;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.ut.TDAUnitTestDataParser;
import org.flasck.flas.parser.ut.TestStepNamer;
import org.flasck.flas.parser.ut.TestStepParser;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.parser.ut.UnitTestDefinitionConsumer;
import org.flasck.flas.parser.ut.UnitTestNamer;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.TestDescriptionToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDAUnitTestParser
extends BlockLocationTracker
implements TDAParsing {
    public static final Logger logger = LoggerFactory.getLogger((String)"UTParser");
    private final UnitTestNamer namer;
    private final UnitTestDefinitionConsumer builder;
    private final FunctionScopeUnitConsumer topLevel;

    public TDAUnitTestParser(ErrorReporter errors, UnitTestNamer namer, UnitTestDefinitionConsumer builder, FunctionScopeUnitConsumer topLevel) {
        super(errors, null);
        this.namer = namer;
        this.builder = builder;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        int mark = toks.at();
        KeywordToken tok = KeywordToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        switch (tok.text) {
            case "data": {
                return new TDAUnitTestDataParser(this.errors, false, tok, this.namer, dd -> this.builder.data((UnitDataDeclaration)dd), this.topLevel, this).tryParsing(toks);
            }
            case "test": {
                toks.skipWS(this.errors);
                InputPosition pos = toks.realinfo();
                String desc = toks.remainder().trim();
                TestDescriptionToken tdt = new TestDescriptionToken(pos, desc);
                this.errors.logParsingToken(tdt);
                if (desc.length() == 0) {
                    this.errors.message(toks, "test case must have a description");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logReduction("ut-test-intro", tok, tdt);
                this.updateLoc(tok.location);
                UnitTestCase utc = new UnitTestCase(this.namer.unitTest(), desc);
                this.builder.testCase(utc);
                return new TDAParsingWithAction(new TestStepParser(this.errors, new TestStepNamer(utc.name), utc, this.builder, this), this.reduction(tok.location, "unit-test-declaration"));
            }
            case "ignore": {
                toks.skipWS(this.errors);
                InputPosition pos = toks.realinfo();
                String desc = toks.remainder().trim();
                TestDescriptionToken tdt = new TestDescriptionToken(pos, desc);
                this.errors.logParsingToken(tdt);
                this.errors.logReduction("ut-ignore-test-intro", tok, tdt);
                this.updateLoc(tok.location);
                return new TDAParsingWithAction(new IgnoreNestedParser(this.errors, this), this.reduction(tok.location, "unit-test-ignore"));
            }
        }
        toks.reset(mark);
        this.errors.message(toks, "syntax error");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

