/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.ut;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATypeReferenceParser;
import org.flasck.flas.parser.ut.TDAUTDataProcessFieldsParser;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.parser.ut.UnitDataNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAUnitTestDataParser
extends BlockLocationTracker
implements TDAParsing {
    private final boolean atTopLevel;
    private final KeywordToken kw;
    private final UnitDataNamer namer;
    private final Consumer<UnitDataDeclaration> builder;
    private final FunctionScopeUnitConsumer topLevel;

    public TDAUnitTestDataParser(ErrorReporter errors, boolean atTopLevel, KeywordToken kw, UnitDataNamer namer, Consumer<UnitDataDeclaration> builder, FunctionScopeUnitConsumer topLevel, LocationTracker locTracker) {
        super(errors, locTracker);
        this.atTopLevel = atTopLevel;
        this.kw = kw;
        this.namer = namer;
        this.builder = builder;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        InputPosition pos = toks.realinfo();
        ArrayList tr = new ArrayList();
        TDATypeReferenceParser parser = new TDATypeReferenceParser(this.errors, this.namer, true, x -> tr.add(x), this.topLevel);
        if (parser.tryParsing(toks) == null) {
            return new IgnoreNestedParser(this.errors);
        }
        ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
        if (var == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        FunctionName fnName = this.namer.dataName(var.location, var.text);
        if (!toks.hasMoreContent(this.errors)) {
            this.errors.logReduction("test-data-declaration-no-init", this.kw, var);
            super.tellParent(this.kw.location);
            UnitDataDeclaration data = new UnitDataDeclaration(pos, this.atTopLevel, (TypeReference)tr.get(0), fnName, null);
            this.builder.accept(data);
            return new TDAParsingWithAction(new TDAUTDataProcessFieldsParser(this.errors, data), this.reduction(this.kw.location, "unit-fields-data-declaration"));
        }
        ExprToken send = ExprToken.from(this.errors, toks);
        if (send == null || !send.text.equals("<-")) {
            this.errors.message(toks, "expected <-");
            return new IgnoreNestedParser(this.errors);
        }
        ArrayList exprs = new ArrayList();
        new TDAExpressionParser(this.errors, x -> exprs.add(x)).tryParsing(toks);
        if (exprs.isEmpty()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        super.updateLoc(((Expr)exprs.get(0)).location());
        this.reduce(this.kw.location, "unit-expr-data-declaration");
        UnitDataDeclaration data = new UnitDataDeclaration(pos, this.atTopLevel, (TypeReference)tr.get(0), fnName, (Expr)exprs.get(0));
        this.builder.accept(data);
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

