/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.ut;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.ut.UnitDataFieldConsumer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAUTDataProcessFieldsParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final UnitDataFieldConsumer data;

    public TDAUTDataProcessFieldsParser(ErrorReporter errors, UnitDataFieldConsumer data) {
        this.errors = errors;
        this.data = data;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
        if (var == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        ExprToken send = ExprToken.from(this.errors, toks);
        if (send == null) {
            this.errors.message(toks, "expected <-");
            return new IgnoreNestedParser(this.errors);
        }
        if (!send.text.equals("<-")) {
            this.errors.message(send.location, "expected <-");
            return new IgnoreNestedParser(this.errors);
        }
        ArrayList exprs = new ArrayList();
        new TDAExpressionParser(this.errors, x -> exprs.add(x)).tryParsing(toks);
        if (exprs.isEmpty()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.data.field(new UnresolvedVar(var.location, var.text), (Expr)exprs.get(0));
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

