/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.ut;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.LocatableConsumer;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.FreeTextToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class FreeTextParser
implements TDAParsing {
    private final KeywordToken kw;
    private final ErrorReporter errors;
    private final LocatableConsumer<FreeTextToken> handler;
    private final FreeTextParser parent;
    private final List<FreeTextToken> buffers;
    private final LocationTracker locTracker;
    private InputPosition firstLoc;
    private InputPosition lastLoc;

    public FreeTextParser(KeywordToken kw, ErrorReporter errors, LocationTracker locTracker, LocatableConsumer<FreeTextToken> freeTextHandler) {
        this.kw = kw;
        this.errors = errors;
        this.handler = freeTextHandler;
        this.locTracker = locTracker;
        this.parent = null;
        this.buffers = new ArrayList<FreeTextToken>();
        this.lastLoc = kw.location();
    }

    public FreeTextParser(KeywordToken kw, FreeTextParser parent, LocationTracker locTracker) {
        this.kw = kw;
        this.errors = parent.errors;
        this.handler = null;
        this.parent = parent;
        this.locTracker = locTracker;
        this.buffers = parent.buffers;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        InputPosition pos = toks.realinfo();
        if (this.firstLoc == null) {
            this.firstLoc = pos;
        }
        this.lastLoc = pos;
        String tok = toks.remainder();
        FreeTextToken ret = new FreeTextToken(pos, tok);
        ret.location().endAt(tok.length());
        this.errors.logParsingToken(ret);
        this.errors.logReduction("unit-match-free-text", ret.location(), ret.location().locAtEnd());
        this.locTracker.updateLoc(ret.location());
        this.buffers.add(ret);
        return new FreeTextParser(this.kw, this, this.locTracker);
    }

    private void seenTextAt(InputPosition later) {
        if (later != null) {
            this.lastLoc = later;
        }
    }

    @Override
    public void scopeComplete(InputPosition location) {
        if (this.handler != null) {
            this.handler.accept(this.lastLoc, FreeTextToken.merge(this.buffers));
        } else if (this.parent != null) {
            this.parent.seenTextAt(this.lastLoc);
        }
    }
}

