/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.st;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.names.SystemTestName;
import org.flasck.flas.compiler.ParsingPhase;
import org.flasck.flas.compiler.modules.ParserModule;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.st.SystemTestCleanup;
import org.flasck.flas.parsedForm.st.SystemTestConfiguration;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.parser.st.SystemTestDefinitionConsumer;
import org.flasck.flas.parser.st.SystemTestNamer;
import org.flasck.flas.parser.ut.TestStepNamer;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.TestDescriptionToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDASystemTestParser
extends BlockLocationTracker
implements TDAParsing {
    private final SystemTestNamer namer;
    private final SystemTestDefinitionConsumer builder;
    private final TopLevelDefinitionConsumer topLevel;
    private final Iterable<ParserModule> modules;
    private final OptionsRecorder options;

    public TDASystemTestParser(ErrorReporter errors, SystemTestNamer namer, SystemTestDefinitionConsumer builder, TopLevelDefinitionConsumer topLevel, Iterable<ParserModule> modules, LocationTracker locTracker, OptionsRecorder options) {
        super(errors, locTracker);
        this.namer = namer;
        this.builder = builder;
        this.topLevel = topLevel;
        this.modules = modules;
        this.options = options;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        int mark = toks.at();
        KeywordToken tok = KeywordToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.updateLoc(tok.location);
        switch (tok.text) {
            case "configure": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "configure does not have a description");
                    return new IgnoreNestedParser(this.errors);
                }
                this.options.haveConfigure(tok);
                SystemTestName stn = this.namer.special("configure");
                SystemTestConfiguration stg = new SystemTestConfiguration(stn, this.topLevel);
                this.builder.configure(stg);
                this.errors.logReduction("system-test-stage-configure", tok.location, tok.location.locAtEnd());
                return new TDAParsingWithAction(ParsingPhase.systemTestStep(this.errors, new TestStepNamer(stn.container()), stg, this.topLevel, this.modules, this), this.reduction(tok.location, "system-test-configure"));
            }
            case "test": {
                toks.skipWS(this.errors);
                InputPosition pos = toks.realinfo();
                String desc = toks.remainder().trim();
                this.errors.logParsingToken(new TestDescriptionToken(pos, desc));
                if (desc.length() == 0) {
                    this.errors.message(toks, "each test step must have a description");
                    return new IgnoreNestedParser(this.errors);
                }
                this.options.haveTest(tok);
                SystemTestName stn = this.namer.nextStep();
                SystemTestStage stage = new SystemTestStage(stn, desc, this.topLevel);
                this.builder.test(stage);
                this.errors.logReduction("system-test-stage-test", tok.location, pos);
                return new TDAParsingWithAction(ParsingPhase.systemTestStep(this.errors, new TestStepNamer(stn), stage, this.topLevel, this.modules, this), this.reduction(tok.location, "system-test-unit"));
            }
            case "finally": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "finally does not have a description");
                    return new IgnoreNestedParser(this.errors);
                }
                this.options.haveFinally(tok);
                SystemTestName stn = this.namer.special("finally");
                SystemTestCleanup stg = new SystemTestCleanup(stn, this.topLevel);
                this.builder.cleanup(stg);
                this.errors.logReduction("system-test-stage-finally", tok.location, tok.location.locAtEnd());
                return new TDAParsingWithAction(ParsingPhase.systemTestStep(this.errors, new TestStepNamer(stn), stg, this.topLevel, this.modules, this), this.reduction(tok.location, "system-test-finally"));
            }
        }
        toks.reset(mark);
        this.errors.message(toks, "syntax error");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    public static class OptionsRecorder {
        private boolean configure;
        private boolean finallyBlock;
        private Locatable first;

        public void haveConfigure(Locatable kw) {
            this.configure = true;
            this.from(kw);
        }

        public void haveTest(Locatable kw) {
            this.from(kw);
        }

        public void haveFinally(Locatable kw) {
            this.finallyBlock = true;
            this.from(kw);
        }

        private void from(Locatable kw) {
            if (this.first == null) {
                this.first = kw;
            }
        }

        public Locatable firstLoc() {
            return this.first;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("system-test");
            if (this.configure) {
                sb.append("-configure");
            }
            if (this.finallyBlock) {
                sb.append("-finally");
            }
            return sb.toString();
        }
    }
}

