/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.assembly;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.assembly.RoutingActions;
import org.flasck.flas.parsedForm.assembly.SubRouting;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.assembly.MainRoutingGroupConsumer;
import org.flasck.flas.parser.assembly.RoutingGroupConsumer;
import org.flasck.flas.parser.assembly.TDAEnterExitParser;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.StringToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDARoutingParser
extends BlockLocationTracker
implements TDAParsing {
    private final RoutingGroupConsumer consumer;

    public TDARoutingParser(ErrorReporter errors, RoutingGroupConsumer consumer, LocationTracker parentTracker) {
        super(errors, parentTracker);
        this.consumer = consumer;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken kw = VarNameToken.from(this.errors, toks);
        if (kw == null) {
            this.errors.message(toks, "expected routing keyword or card var");
            return new IgnoreNestedParser(this.errors);
        }
        toks.skipWS(this.errors);
        switch (kw.text) {
            case "enter": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                RoutingActions enter = new RoutingActions(kw.location);
                this.consumer.enter(enter);
                this.errors.logReduction("fa-route-enter", kw.location, kw.location);
                super.tellParent(kw.location);
                return new TDAParsingWithAction(new TDAEnterExitParser(this.errors, enter, this), this.reduction(kw.location, "assembly-route-enter"));
            }
            case "at": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                RoutingActions at = new RoutingActions(kw.location);
                this.consumer.at(at);
                this.errors.logReduction("fa-route-at", kw.location, kw.location);
                super.tellParent(kw.location);
                return new TDAParsingWithAction(new TDAEnterExitParser(this.errors, at, this), this.reduction(kw.location, "assembly-route-at"));
            }
            case "exit": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                RoutingActions exit = new RoutingActions(kw.location);
                this.consumer.exit(exit);
                this.errors.logReduction("fa-route-exit", kw.location, kw.location);
                super.tellParent(kw.location);
                return new TDAParsingWithAction(new TDAEnterExitParser(this.errors, exit, this), this.reduction(kw.location, "assembly-route-exit"));
            }
            case "secure": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.consumer.isSecure();
                this.errors.logReduction("assembly-route-secure", kw.location, kw.location);
                super.tellParent(kw.location);
                return new NoNestingParser(this.errors);
            }
            case "route": {
                int mark = toks.at();
                InputPosition pos = toks.realinfo();
                String s = StringToken.from(this.errors, toks);
                if (s == null) {
                    this.errors.message(toks, "must specify a route path");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logParsingToken(new ExprToken(pos, 5, s).original(toks.fromMark(mark)));
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                SubRouting group = new SubRouting(this.errors, pos, s, this.consumer);
                this.consumer.route(group);
                this.errors.logReduction("fa-route-nested", kw.location, pos);
                super.tellParent(kw.location);
                return new TDAParsingWithAction(new TDARoutingParser(this.errors, group, this), this.reduction(kw.location, "assembly-route-nested"));
            }
            case "title": {
                int mark = toks.at();
                InputPosition pos = toks.realinfo();
                String s = StringToken.from(this.errors, toks);
                if (s == null) {
                    this.errors.message(toks, "must specify a title");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logParsingToken(new ExprToken(pos, 5, s).original(toks.fromMark(mark)));
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.consumer.title(pos, s);
                this.errors.logReduction("assembly-title", kw.location, pos);
                super.tellParent(kw.location);
                return new NoNestingParser(this.errors);
            }
        }
        ExprToken op = ExprToken.from(this.errors, toks);
        if (op == null || !"<-".equals(op.text)) {
            this.errors.message(toks, "expected 'enter', 'at', 'exit', 'secure', 'route', 'query', 'title' or card assignment");
            return new IgnoreNestedParser(this.errors);
        }
        if (kw.text.equals("main") && !(this.consumer instanceof MainRoutingGroupConsumer)) {
            this.errors.message(kw.location, "main cannot be set here");
            return new IgnoreNestedParser(this.errors);
        }
        TypeNameToken card = TypeNameToken.qualified(this.errors, toks);
        if (card == null) {
            this.errors.message(toks, "card name required");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "junk at end of line");
            return new IgnoreNestedParser(this.errors);
        }
        TypeReference tr = new TypeReference(card.location, card.text, new TypeReference[0]);
        this.consumer.assignCard(new UnresolvedVar(kw.location, kw.text), tr);
        if (kw.text.equals("main")) {
            ((MainRoutingGroupConsumer)this.consumer).provideMainCard(tr);
        }
        this.errors.logReduction("fa-route-action", kw.location, card.location);
        super.tellParent(kw.location);
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

