/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.assembly;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.assembly.RoutingActionConsumer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class TDAEnterExitParser
extends BlockLocationTracker
implements TDAParsing {
    private final RoutingActionConsumer consumer;

    public TDAEnterExitParser(ErrorReporter errors, RoutingActionConsumer consumer, LocationTracker parentTracker) {
        super(errors, parentTracker);
        this.consumer = consumer;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken cardToken = VarNameToken.from(this.errors, toks);
        if (cardToken == null) {
            this.errors.message(toks, "expected card reference");
            return new NoNestingParser(this.errors);
        }
        UnresolvedVar card = new UnresolvedVar(cardToken.location, cardToken.text);
        ExprToken tok = ExprToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "expected . or <-");
            return new NoNestingParser(this.errors);
        }
        String opt = "";
        switch (tok.text) {
            case ".": {
                UnresolvedVar uv;
                TypeReference ctr;
                ExprToken apply = tok;
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn != null) {
                    tok = ExprToken.from(this.errors, toks);
                    if (tok == null || !".".equals(tok.text)) {
                        this.errors.message(toks, "expected .");
                        return new NoNestingParser(this.errors);
                    }
                    ctr = new TypeReference(tn.location, tn.text, new ArrayList<TypeReference>());
                    opt = "-with-contract";
                    this.errors.logReduction("assembly-route-with-contract", apply, ctr);
                } else {
                    ctr = new TypeReference(card.location(), "Lifecycle", new ArrayList<TypeReference>());
                }
                ArrayList<Expr> exprs = new ArrayList<Expr>();
                new TDAExpressionParser(this.errors, e -> exprs.add((Expr)e)).tryParsing(toks);
                if (exprs.isEmpty()) {
                    this.errors.message(toks, "expected method");
                    return new NoNestingParser(this.errors);
                }
                Expr have = (Expr)exprs.remove(0);
                if (have instanceof UnresolvedVar) {
                    uv = (UnresolvedVar)have;
                } else if (have instanceof ApplyExpr) {
                    uv = (UnresolvedVar)((ApplyExpr)have).fn;
                    for (Object o : ((ApplyExpr)have).args) {
                        exprs.add((Expr)o);
                    }
                } else {
                    throw new NotImplementedException();
                }
                this.consumer.method(card, ctr, uv.var, exprs);
                this.errors.logReduction("fa-invoke" + opt, card.location, have.location());
                super.tellParent(card.location);
                break;
            }
            default: {
                this.errors.message(toks, "expected . or <-");
                return new NoNestingParser(this.errors);
            }
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
        }
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

