/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.assembly;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.assembly.ApplicationAssembly;
import org.flasck.flas.parsedForm.assembly.LibraryAssembly;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TopLevelNamer;
import org.flasck.flas.parser.assembly.ApplicationElementParser;
import org.flasck.flas.parser.assembly.AssemblyDefinitionConsumer;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.zinutils.exceptions.NotImplementedException;

public class TDAAssemblyUnitParser
extends BlockLocationTracker
implements TDAParsing {
    private final TopLevelNamer namer;
    private final AssemblyDefinitionConsumer adc;

    public TDAAssemblyUnitParser(ErrorReporter errors, TopLevelNamer namer, AssemblyDefinitionConsumer adc, LocationTracker parentTracker) {
        super(errors, parentTracker);
        this.namer = namer;
        this.adc = adc;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null) {
            this.errors.message(toks, "expected 'application', 'card' or 'library'");
            return new IgnoreNestedParser(this.errors);
        }
        switch (kw.text) {
            case "application": {
                ApplicationAssembly consumer = new ApplicationAssembly(kw.location, this.namer.assemblyName(null), this.adc);
                this.adc.assembly(consumer);
                this.errors.logReduction("fa-application-intro", kw.location, kw.location);
                super.tellParent(kw.location);
                return new TDAParsingWithAction(new ApplicationElementParser(this.errors, kw.location, this.namer, consumer, this), this.reduction(kw.location, "assembly-application"));
            }
            case "card": {
                throw new NotImplementedException();
            }
            case "library": {
                LibraryAssembly consumer = new LibraryAssembly(kw.location, this.namer.assemblyName(null));
                this.adc.assembly(consumer);
                this.errors.logReduction("fa-library", kw.location, kw.location);
                super.tellParent(kw.location);
                return new NoNestingParser(this.errors);
            }
        }
        this.errors.message(toks, "expected 'application', 'card' or 'library'");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

