/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser.assembly;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TopLevelNamer;
import org.flasck.flas.parser.assembly.ApplicationElementConsumer;
import org.flasck.flas.parser.assembly.TDARoutingParser;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.StringToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class ApplicationElementParser
extends BlockLocationTracker
implements TDAParsing {
    private final InputPosition startPos;
    private final TopLevelNamer namer;
    private final ApplicationElementConsumer consumer;
    private ApplicationRouting routing;

    public ApplicationElementParser(ErrorReporter errors, InputPosition startPos, TopLevelNamer namer, ApplicationElementConsumer consumer, LocationTracker parentTracker) {
        super(errors, parentTracker);
        this.startPos = startPos;
        this.namer = namer;
        this.consumer = consumer;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null) {
            this.errors.message(toks, "expected assembly keyword");
            return new IgnoreNestedParser(this.errors);
        }
        toks.skipWS(this.errors);
        switch (kw.text) {
            case "title": {
                int mark = toks.at();
                InputPosition pos = toks.realinfo();
                String s = StringToken.from(this.errors, toks);
                this.errors.logParsingToken(new ExprToken(pos, 5, s).original(toks.fromMark(mark)));
                this.consumer.title(s);
                this.errors.logReduction("assembly-title", kw.location, pos);
                super.tellParent(kw.location);
                return new NoNestingParser(this.errors);
            }
            case "baseuri": {
                int mark = toks.at();
                InputPosition pos = toks.realinfo();
                String s = StringToken.from(this.errors, toks);
                this.errors.logParsingToken(new ExprToken(pos, 5, s).original(toks.fromMark(mark)));
                this.consumer.baseuri(s);
                this.errors.logReduction("fa-appl-baseuri", kw.location, pos);
                super.tellParent(kw.location);
                return new NoNestingParser(this.errors);
            }
            case "routes": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                if (this.routing != null) {
                    this.errors.message(kw.location, "cannot specify routing table twice");
                    return new IgnoreNestedParser(this.errors);
                }
                this.routing = new ApplicationRouting(this.errors, kw.location, this.namer.assemblyName(null), this.namer.assemblyName("Routing"));
                this.consumer.routes(this.routing);
                this.errors.logReduction("fa-appl-routes", kw.location, kw.location);
                super.tellParent(kw.location);
                return new TDAParsingWithAction(new TDARoutingParser(this.errors, this.routing, this), this.reduction(kw.location, "assembly-routes"));
            }
        }
        this.errors.message(toks, "expected 'title', 'baseuri' or 'routes'");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
        if (this.routing == null) {
            this.errors.message(this.startPos, "assembly must declare routing");
        } else if (!this.routing.sawMainCard) {
            this.errors.message(this.startPos, "assembly must identify a main card");
        }
    }
}

