/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FunctionTypeReference;
import org.flasck.flas.parsedForm.TupleTypeReference;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.TDAProvideType;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeExprToken;
import org.zinutils.exceptions.NotImplementedException;

public class TypeExprParser {
    private ErrorReporter errors;

    public TypeExprParser(ErrorReporter errors) {
        this.errors = errors;
    }

    public void tryParsing(Tokenizable line, TDAProvideType pt) {
        boolean reduced;
        TypeExprToken tt = TypeExprToken.from(this.errors, line);
        if (tt == null) {
            return;
        }
        TypeReference curr = null;
        if (tt.type == 1) {
            curr = new TypeReference(tt.location, tt.text, new TypeReference[0]);
            reduced = false;
        } else if (tt.type == 10) {
            ArrayList trs = new ArrayList();
            this.parseInsideRB(tt.location, line, x -> trs.add(x));
            if (trs.isEmpty()) {
                return;
            }
            curr = (TypeReference)trs.get(0);
            reduced = true;
        } else {
            this.errors.message(tt.location, "invalid type reference");
            return;
        }
        int mark = line.at();
        TypeExprToken nt = TypeExprToken.from(this.errors, line);
        if (nt == null) {
            if (!reduced) {
                this.errors.logReduction("simple-type-name", tt, tt);
            }
            pt.provide(curr);
            return;
        }
        if (nt.type == 13 || nt.type == 11 || nt.type == 14) {
            if (!reduced) {
                this.errors.logReduction("simple-type-name", tt, tt);
            }
            line.reset(mark);
            pt.provide(curr);
            return;
        }
        if (nt.type == 12) {
            TypeExprToken osb = nt;
            ArrayList<TypeReference> trs = new ArrayList<TypeReference>();
            int cnt = 0;
            TypeExprToken comma = null;
            TypeExprToken csb = null;
            while (true) {
                this.tryParsing(line, x -> trs.add(x));
                if (++cnt != trs.size()) {
                    return;
                }
                if (comma != null) {
                    this.errors.logReduction("comma-type-reference", comma, (Locatable)trs.get(trs.size() - 1));
                }
                nt = TypeExprToken.from(this.errors, line);
                if (nt.type != 14) break;
                comma = nt;
            }
            if (nt.type != 13) {
                throw new NotImplementedException();
            }
            csb = nt;
            curr = new TypeReference(curr.location(), curr.name(), trs);
            this.errors.logReduction("poly-type-list", osb, csb);
            this.errors.logReduction("simple-type-name-with-polys", tt, csb);
            mark = line.at();
        }
        if (nt.type == 15) {
            ArrayList<Object> args;
            if (!reduced) {
                this.errors.logReduction("simple-type-name", tt, tt);
            }
            ArrayList trs = new ArrayList();
            this.tryParsing(line, x -> trs.add(x));
            if (trs.isEmpty()) {
                return;
            }
            TypeReference restr = (TypeReference)trs.get(0);
            if (restr instanceof FunctionTypeReference) {
                FunctionTypeReference resf = (FunctionTypeReference)restr;
                args = new ArrayList<TypeReference>(resf.args);
            } else {
                args = new ArrayList<TypeReference>();
                args.add(restr);
            }
            args.add(0, curr);
            curr = new FunctionTypeReference(curr.location(), args);
            this.errors.logReduction("function-type-reference", tt, restr);
        } else {
            line.reset(mark);
        }
        pt.provide(curr);
    }

    private void parseInsideRB(InputPosition orbLoc, Tokenizable line, TDAProvideType pt) {
        ArrayList<TypeReference> trs = new ArrayList<TypeReference>();
        TypeExprToken comma = null;
        while (true) {
            this.tryParsing(line, x -> trs.add(x));
            if (trs.isEmpty()) {
                return;
            }
            TypeExprToken tt = TypeExprToken.from(this.errors, line);
            if (tt.type == 11) {
                if (comma != null) {
                    this.errors.logReduction("comma-type-reference", comma, (Locatable)trs.get(trs.size() - 1));
                }
                if (trs.size() == 1) {
                    pt.provide((TypeReference)trs.get(0));
                    this.errors.logReduction("paren-type-reference", orbLoc, tt.location);
                } else {
                    pt.provide(new TupleTypeReference(orbLoc, trs));
                    this.errors.logReduction("tuple-type-reference", orbLoc, tt.location);
                }
                return;
            }
            if (tt.type != 14) break;
            if (comma != null) {
                this.errors.logReduction("comma-type-reference", comma, (Locatable)trs.get(trs.size() - 1));
            }
            comma = tt;
        }
        throw new NotImplementedException();
    }
}

