/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAProvideType;
import org.flasck.flas.parser.TypeExprParser;
import org.flasck.flas.parser.UnionFieldConsumer;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAUnionFieldParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final UnionFieldConsumer consumer;
    private final InputPosition kwloc;

    public TDAUnionFieldParser(ErrorReporter errors, InputPosition kwloc, UnionFieldConsumer consumer) {
        this.errors = errors;
        this.kwloc = kwloc;
        this.consumer = consumer;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        TypeExprParser parser = new TypeExprParser(this.errors);
        ArrayList types = new ArrayList();
        TDAProvideType pt = ty -> types.add(ty);
        parser.tryParsing(toks, pt);
        if (types.isEmpty()) {
            this.errors.message(toks, "field must have a valid type definition");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "tokens beyond end of line");
            return new IgnoreNestedParser(this.errors);
        }
        TypeReference ty2 = (TypeReference)types.get(0);
        this.consumer.addCase(ty2);
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.errors.logReduction("union-declaration", this.kwloc, location);
    }
}

