/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.VarNamer;
import org.flasck.flas.tokenizers.PattToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class TDATypeReferenceParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final VarNamer namer;
    private final boolean reduceSimple;
    private final Consumer<TypeReference> consumer;
    private final FunctionScopeUnitConsumer topLevel;

    public TDATypeReferenceParser(ErrorReporter errors, VarNamer namer, boolean reduceSimple, Consumer<TypeReference> consumer, FunctionScopeUnitConsumer topLevel) {
        this.errors = errors;
        this.namer = namer;
        this.reduceSimple = reduceSimple;
        this.consumer = consumer;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        TypeNameToken qn = TypeNameToken.qualified(this.errors, toks);
        if (qn == null) {
            this.errors.message(toks, "typename expected");
            return null;
        }
        int mark = toks.at();
        ArrayList<TypeReference> andTypeParameters = new ArrayList<TypeReference>();
        if (toks.hasMore() && !Character.isWhitespace(toks.nextChar())) {
            PattToken tok = PattToken.from(this.errors, toks);
            if (tok != null) {
                if (tok.type == 12) {
                    PattToken osb = tok;
                    TDATypeReferenceParser inner = new TDATypeReferenceParser(this.errors, this.namer, this.reduceSimple, x -> andTypeParameters.add((TypeReference)x), this.topLevel);
                    PattToken comma = null;
                    PattToken csb = null;
                    while (true) {
                        if (inner.tryParsing(toks) == null) {
                            return null;
                        }
                        if (comma != null) {
                            this.errors.logReduction("comma-type-reference", comma, (Locatable)andTypeParameters.get(andTypeParameters.size() - 1));
                        }
                        tok = PattToken.from(this.errors, toks);
                        if (tok.type != 17) break;
                        comma = tok;
                    }
                    if (tok.type != 13) {
                        this.errors.message(toks, "invalid pattern");
                        return null;
                    }
                    csb = tok;
                    this.errors.logReduction("poly-type-list", osb, csb);
                    this.errors.logReduction("simple-type-name-with-polys", qn, csb);
                } else {
                    toks.reset(mark);
                    if (this.reduceSimple) {
                        this.errors.logReduction("simple-type-name", qn, qn);
                    }
                }
            }
        } else if (this.reduceSimple) {
            this.errors.logReduction("simple-type-name", qn, qn);
        }
        this.consumer.accept(new TypeReference(qn.location, qn.text, andTypeParameters));
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
        throw new NotImplementedException();
    }
}

