/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.compiler.ParsingPhase;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.LocatedName;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parser.FunctionAssembler;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.InnerPackageNamer;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.PattToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDATupleDeclarationParser
implements TDAParsing,
LocationTracker {
    private final ErrorReporter errors;
    private final FunctionNameProvider functionNamer;
    private final FunctionScopeUnitConsumer consumer;
    private final StateHolder holder;
    private final LocationTracker locTracker;
    private InputPosition lastInner;

    public TDATupleDeclarationParser(ErrorReporter errors, FunctionNameProvider functionNamer, FunctionScopeUnitConsumer consumer, StateHolder holder, LocationTracker locTracker) {
        this.errors = errors;
        this.functionNamer = functionNamer;
        this.consumer = consumer;
        this.holder = holder;
        this.locTracker = locTracker;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable line) {
        PattToken orb = PattToken.from(this.errors, line);
        if (orb == null || orb.type != 10) {
            return null;
        }
        ArrayList<LocatedName> vars = new ArrayList<LocatedName>();
        InputPosition last = null;
        InputPosition comma = null;
        while (line.hasMoreContent(this.errors)) {
            PattToken cm;
            PattToken nx = PattToken.from(this.errors, line);
            if (nx.type == 11) {
                if (vars.isEmpty()) {
                    this.errors.message(line, "missing var in tuple declaration");
                } else {
                    this.errors.message(line, "syntax error");
                }
                return null;
            }
            if (nx.type != 1) {
                this.errors.message(line, "syntax error");
                return null;
            }
            vars.add(new LocatedName(nx.location, nx.text));
            if (comma != null) {
                this.errors.logReduction("comma-var-name", comma, nx.location);
            }
            if ((cm = PattToken.from(this.errors, line)) == null) {
                this.errors.message(line, "syntax error");
                return null;
            }
            if (cm.type == 11) {
                last = cm.location;
                break;
            }
            if (cm.type != 17) {
                this.errors.message(line, "syntax error");
                return null;
            }
            comma = cm.location;
        }
        if (last == null) {
            this.errors.message(line, "syntax error");
            return null;
        }
        if (vars.size() < 2) {
            this.errors.message(line, "insufficient vars to make tuple declaration");
            return null;
        }
        if (!line.hasMoreContent(this.errors)) {
            this.errors.message(line, "syntax error");
            return null;
        }
        ExprToken tok = ExprToken.from(this.errors, line);
        if (!tok.text.equals("=")) {
            this.errors.message(line, "syntax error");
            return null;
        }
        if (!line.hasMoreContent(this.errors)) {
            this.errors.message(line, "tuple assignment requires expression");
            return null;
        }
        FunctionName leadName = this.functionNamer.functionName(((LocatedName)vars.get((int)0)).location, "_tuple_" + ((LocatedName)vars.get((int)0)).text);
        FunctionName pkgName = this.functionNamer.functionName(((LocatedName)vars.get((int)0)).location, ((LocatedName)vars.get((int)0)).text);
        new TDAExpressionParser(this.errors, e -> {
            this.consumer.tupleDefn(this.errors, (List<LocatedName>)vars, leadName, pkgName, (Expr)e);
            this.errors.logReduction("tuple-declaration", orb.location, e.location());
        }).tryParsing(line);
        this.lastInner = last;
        FunctionAssembler assembler = new FunctionAssembler(this.errors, this.consumer, this.holder, this);
        return new TDAParsingWithAction(ParsingPhase.functionScopeUnit(this.errors, new InnerPackageNamer(pkgName), assembler, this.consumer, this.holder, this), () -> {
            this.errors.logReduction("tuple-definition", orb.location, this.lastInner);
            this.locTracker.updateLoc(orb.location);
        });
    }

    @Override
    public void updateLoc(InputPosition location) {
        this.lastInner = location;
    }

    @Override
    public InputPosition lastInner() {
        return this.lastInner;
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    public static TDAParserConstructor constructor(final FunctionNameProvider namer, final FunctionScopeUnitConsumer topLevel, final StateHolder holder, final LocationTracker locTracker) {
        return new TDAParserConstructor(){

            @Override
            public TDAParsing construct(ErrorReporter errors) {
                return new TDATupleDeclarationParser(errors, namer, topLevel, holder, locTracker);
            }
        };
    }
}

