/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateCustomization;
import org.flasck.flas.parsedForm.TemplateEvent;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAParseTemplateElements;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDATemplateStylingParser
extends BlockLocationTracker
implements TDAParsing {
    private final Template source;
    private final TemplateNamer namer;
    private final TemplateCustomization customizer;

    public TDATemplateStylingParser(ErrorReporter errors, Template source, TemplateNamer namer, TemplateStylingOption tso, LocationTracker locTracker) {
        super(errors, locTracker);
        this.source = source;
        this.namer = namer;
        this.customizer = tso;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ExprToken tok = ExprToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.tellParent(tok.location);
        if ("|".equals(tok.text)) {
            return TDAParseTemplateElements.parseStyling(this.errors, tok.location, this.source, this.namer, toks, tso -> this.customizer.conditionalStylings.add((TemplateStylingOption)tso), this);
        }
        if ("=>".equals(tok.text)) {
            return TDAParseTemplateElements.parseEventHandling(tok, this.errors, this.source, toks, ev -> this.customizer.events.add((TemplateEvent)ev), this);
        }
        this.errors.message(toks, "syntax error");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition pos) {
    }
}

